/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0014J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0013*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007J\u0012\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010#\u001a\u00020\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/OtherUtil;", "", "<init>", "()V", "modResource", "Lnet/minecraft/resources/ResourceLocation;", "path", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item;", "getItemStack", "(Lnet/minecraft/world/item/Item;)Lnet/minecraft/world/item/ItemStack;", "withColor", "Lnet/minecraft/network/chat/MutableComponent;", "color", "Lnet/minecraft/ChatFormatting;", "entityUuidMap", "", "Ljava/util/UUID;", "Lnet/minecraft/world/entity/LivingEntity;", "getNearbyEntityFromUuid", "uuid", "searchAroundEntity", "getUuidOrNull", "Lnet/minecraft/nbt/CompoundTag;", "key", "getEntityType", "Lnet/minecraft/world/entity/EntityType;", "resourceLocation", "getPotionContents", "Lnet/minecraft/world/item/alchemy/PotionContents;", "getPotion", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "getPotionStack", "potion", "geneticsresequenced-1.21"})
public final class OtherUtil {
    @NotNull
    public static final OtherUtil INSTANCE = new OtherUtil();
    @NotNull
    private static final Map<UUID, LivingEntity> entityUuidMap = new LinkedHashMap();

    private OtherUtil() {
    }

    @NotNull
    public final ResourceLocation modResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"geneticsresequenced", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public final ItemStack getItemStack(@NotNull Item $this$itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$itemStack, (String)"<this>");
        ItemStack itemStack = $this$itemStack.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    @NotNull
    public final MutableComponent withColor(@NotNull MutableComponent $this$withColor, @NotNull ChatFormatting color) {
        Intrinsics.checkNotNullParameter((Object)$this$withColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        MutableComponent mutableComponent = $this$withColor.withStyle(arg_0 -> OtherUtil.withColor$lambda$0(color, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return mutableComponent;
    }

    @Nullable
    public final LivingEntity getNearbyEntityFromUuid(@NotNull UUID uuid, @NotNull LivingEntity searchAroundEntity) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)searchAroundEntity, (String)"searchAroundEntity");
        LivingEntity mappedValue = entityUuidMap.get(uuid);
        if (mappedValue != null) {
            return mappedValue;
        }
        List nearbyEntities = searchAroundEntity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, searchAroundEntity, searchAroundEntity.getBoundingBox().inflate(50.0));
        for (LivingEntity entity : nearbyEntities) {
            if (!Intrinsics.areEqual((Object)entity.getUUID(), (Object)uuid)) continue;
            entityUuidMap.put(uuid, entity);
            return entity;
        }
        return null;
    }

    @Nullable
    public final UUID getUuidOrNull(@NotNull CompoundTag $this$getUuidOrNull, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getUuidOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!$this$getUuidOrNull.hasUUID(key)) {
            return null;
        }
        return $this$getUuidOrNull.getUUID(key);
    }

    @NotNull
    public final EntityType<?> getEntityType(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Object object = BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EntityType entityType = (EntityType)object;
        if (entityType == EntityType.PIG && !Intrinsics.areEqual((Object)resourceLocation, (Object)BuiltInRegistries.ENTITY_TYPE.getDefaultKey())) {
            throw new IllegalArgumentException("Unknown entity type: " + resourceLocation);
        }
        return entityType;
    }

    @Nullable
    public final PotionContents getPotionContents(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
    }

    @Nullable
    public final Holder<Potion> getPotion(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Object object = this.getPotionContents(itemStack);
        return object != null && (object = object.potion()) != null ? (Holder)((Optional)object).get() : null;
    }

    @NotNull
    public final ItemStack getPotionStack(@NotNull Holder<Potion> potion) {
        Intrinsics.checkNotNullParameter(potion, (String)"potion");
        ItemStack itemStack = PotionContents.createItemStack((Item)Items.POTION, potion);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createItemStack(...)");
        return itemStack;
    }

    private static final Style withColor$lambda$0(ChatFormatting $color, Style it) {
        Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
        return it.withColor($color);
    }
}

