/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/VirusRecipe;", "Lnet/neoforged/neoforge/common/brewing/IBrewingRecipe;", "inputDnaGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "outputGene", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;)V", "getInputDnaGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getOutputGene", "isInput", "", "pBottomSlot", "Lnet/minecraft/world/item/ItemStack;", "isIngredient", "pTopSlot", "getOutput", "geneticsresequenced-1.21"})
public final class VirusRecipe
implements IBrewingRecipe {
    @NotNull
    private final Gene inputDnaGene;
    @NotNull
    private final Gene outputGene;

    public VirusRecipe(@NotNull Gene inputDnaGene, @NotNull Gene outputGene) {
        Intrinsics.checkNotNullParameter((Object)inputDnaGene, (String)"inputDnaGene");
        Intrinsics.checkNotNullParameter((Object)outputGene, (String)"outputGene");
        this.inputDnaGene = inputDnaGene;
        this.outputGene = outputGene;
    }

    @NotNull
    public final Gene getInputDnaGene() {
        return this.inputDnaGene;
    }

    @NotNull
    public final Gene getOutputGene() {
        return this.outputGene;
    }

    public boolean isInput(@NotNull ItemStack pBottomSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        if (!Intrinsics.areEqual((Object)pBottomSlot.getItem(), (Object)Items.POTION)) {
            return false;
        }
        Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(pBottomSlot);
        if (holder == null) {
            return false;
        }
        Holder<Potion> inputPotion = holder;
        return Intrinsics.areEqual(inputPotion, ModPotions.INSTANCE.getVIRAL_AGENTS());
    }

    public boolean isIngredient(@NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!Intrinsics.areEqual((Object)pTopSlot.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get())) {
            return false;
        }
        return Intrinsics.areEqual((Object)DnaHelixItem.Companion.getGene(pTopSlot), (Object)this.inputDnaGene);
    }

    @NotNull
    public ItemStack getOutput(@NotNull ItemStack pBottomSlot, @NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!this.isInput(pBottomSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (!this.isIngredient(pTopSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack itemStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
        ItemStack output = DnaHelixItem.Companion.setGene(itemStack, this.outputGene);
        return output;
    }
}

