/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/SetPotionEntityRecipe;", "Lnet/neoforged/neoforge/common/brewing/IBrewingRecipe;", "<init>", "()V", "isInput", "", "pBottomSlot", "Lnet/minecraft/world/item/ItemStack;", "isIngredient", "pTopSlot", "getOutput", "geneticsresequenced-1.21"})
public final class SetPotionEntityRecipe
implements IBrewingRecipe {
    public boolean isInput(@NotNull ItemStack pBottomSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        if (!Intrinsics.areEqual((Object)pBottomSlot.getItem(), (Object)Items.POTION)) {
            return false;
        }
        if (EntityDnaItem.Companion.hasEntity(pBottomSlot)) {
            return false;
        }
        Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(pBottomSlot);
        if (holder == null) {
            return false;
        }
        Holder<Potion> inputPotion = holder;
        return Intrinsics.areEqual(inputPotion, ModPotions.INSTANCE.getCELL_GROWTH()) || Intrinsics.areEqual(inputPotion, ModPotions.INSTANCE.getMUTATION());
    }

    public boolean isIngredient(@NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!Intrinsics.areEqual((Object)pTopSlot.getItem(), (Object)ModItems.INSTANCE.getCELL().get())) {
            return false;
        }
        return EntityDnaItem.Companion.hasEntity(pTopSlot);
    }

    @NotNull
    public ItemStack getOutput(@NotNull ItemStack pBottomSlot, @NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!this.isInput(pBottomSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (!this.isIngredient(pTopSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(pTopSlot);
        if (entityType == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EntityType<?> ingredientEntity = entityType;
        ItemStack output = pBottomSlot.copy();
        Intrinsics.checkNotNull((Object)output);
        EntityDnaItem.Companion.setEntityType(output, ingredientEntity);
        return output;
    }
}

