/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/GmoRecipe;", "Lnet/neoforged/neoforge/common/brewing/IBrewingRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "ingredientItem", "Lnet/minecraft/world/item/Item;", "idealGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "geneChance", "", "isMutation", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/Item;Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;FZ)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getIngredientItem", "()Lnet/minecraft/world/item/Item;", "getIdealGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getGeneChance", "()F", "()Z", "requiredPotion", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "Lnet/minecraft/world/item/alchemy/Potion;", "getRequiredPotion", "()Lnet/neoforged/neoforge/registries/DeferredHolder;", "getSuccess", "Lnet/minecraft/world/item/ItemStack;", "isInput", "pBottomSlot", "isIngredient", "pTopSlot", "getOutput", "geneticsresequenced-1.21"})
public final class GmoRecipe
implements IBrewingRecipe {
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Item ingredientItem;
    @NotNull
    private final Gene idealGene;
    private final float geneChance;
    private final boolean isMutation;
    @NotNull
    private final DeferredHolder<Potion, Potion> requiredPotion;

    public GmoRecipe(@NotNull EntityType<?> entityType, @NotNull Item ingredientItem, @NotNull Gene idealGene, float geneChance, boolean isMutation) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)ingredientItem, (String)"ingredientItem");
        Intrinsics.checkNotNullParameter((Object)idealGene, (String)"idealGene");
        this.entityType = entityType;
        this.ingredientItem = ingredientItem;
        this.idealGene = idealGene;
        this.geneChance = geneChance;
        this.isMutation = isMutation;
        this.requiredPotion = this.isMutation ? ModPotions.INSTANCE.getMUTATION() : ModPotions.INSTANCE.getCELL_GROWTH();
    }

    public /* synthetic */ GmoRecipe(EntityType entityType, Item item, Gene gene, float f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(entityType, item, gene, f, bl);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final Item getIngredientItem() {
        return this.ingredientItem;
    }

    @NotNull
    public final Gene getIdealGene() {
        return this.idealGene;
    }

    public final float getGeneChance() {
        return this.geneChance;
    }

    public final boolean isMutation() {
        return this.isMutation;
    }

    @NotNull
    public final DeferredHolder<Potion, Potion> getRequiredPotion() {
        return this.requiredPotion;
    }

    @NotNull
    public final ItemStack getSuccess() {
        ItemStack output = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)output);
        GmoCell.Companion.setDetails(output, this.entityType, this.idealGene);
        return output;
    }

    public boolean isInput(@NotNull ItemStack pBottomSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        if (!Intrinsics.areEqual((Object)pBottomSlot.getItem(), (Object)Items.POTION)) {
            return false;
        }
        Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(pBottomSlot);
        if (holder == null) {
            return false;
        }
        Holder<Potion> inputPotion = holder;
        if (!Intrinsics.areEqual(inputPotion, this.requiredPotion)) {
            return false;
        }
        return Intrinsics.areEqual(EntityDnaItem.Companion.getEntityType(pBottomSlot), this.entityType);
    }

    public boolean isIngredient(@NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        return Intrinsics.areEqual((Object)pTopSlot.getItem(), (Object)this.ingredientItem);
    }

    @NotNull
    public ItemStack getOutput(@NotNull ItemStack pBottomSlot, @NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!this.isInput(pBottomSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (!this.isIngredient(pTopSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack output = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)output);
        Object object = ModGenes.INSTANCE.getBASIC().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        GmoCell.Companion.setDetails(output, this.entityType, (Gene)object);
        return output;
    }
}

