/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.BlackDeathRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.SetPotionEntityRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.SubstrateCellRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.VirusRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020,R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001b\u0010\u001b\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\n\u001a\u0004\b \u0010\u001dR\u001b\u0010\"\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\n\u001a\u0004\b#\u0010\u001dR\u001b\u0010%\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\n\u001a\u0004\b&\u0010\u001dR\u001b\u0010(\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\n\u001a\u0004\b)\u0010\u001d\u00a8\u0006-"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BrewingRecipes;", "", "<init>", "()V", "modPotions", "", "Lnet/minecraft/world/item/alchemy/Potion;", "getModPotions", "()Ljava/util/List;", "modPotions$delegate", "Lkotlin/Lazy;", "allRecipes", "", "Lnet/neoforged/neoforge/common/brewing/IBrewingRecipe;", "getAllRecipes", "tooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "potion", "Lnet/minecraft/core/Holder;", "itemLike", "Lnet/minecraft/world/level/ItemLike;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "substratePotionStack", "getSubstratePotionStack", "()Lnet/minecraft/world/item/ItemStack;", "substratePotionStack$delegate", "cellGrowthPotionStack", "getCellGrowthPotionStack", "cellGrowthPotionStack$delegate", "mutationPotionStack", "getMutationPotionStack", "mutationPotionStack$delegate", "viralAgentsPotionStack", "getViralAgentsPotionStack", "viralAgentsPotionStack$delegate", "curePotionStack", "getCurePotionStack", "curePotionStack$delegate", "setRecipes", "Lnet/neoforged/neoforge/event/brewing/RegisterBrewingRecipesEvent;", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nBrewingRecipes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrewingRecipes.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BrewingRecipes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1557#2:234\n1628#2,3:235\n*S KotlinDebug\n*F\n+ 1 BrewingRecipes.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BrewingRecipes\n*L\n29#1:234\n29#1:235,3\n*E\n"})
public final class BrewingRecipes {
    @NotNull
    public static final BrewingRecipes INSTANCE = new BrewingRecipes();
    @NotNull
    private static final Lazy modPotions$delegate = LazyKt.lazy(BrewingRecipes::modPotions_delegate$lambda$1);
    @NotNull
    private static final List<IBrewingRecipe> allRecipes = new ArrayList();
    @NotNull
    private static final Lazy substratePotionStack$delegate = LazyKt.lazy(BrewingRecipes::substratePotionStack_delegate$lambda$5);
    @NotNull
    private static final Lazy cellGrowthPotionStack$delegate = LazyKt.lazy(BrewingRecipes::cellGrowthPotionStack_delegate$lambda$6);
    @NotNull
    private static final Lazy mutationPotionStack$delegate = LazyKt.lazy(BrewingRecipes::mutationPotionStack_delegate$lambda$7);
    @NotNull
    private static final Lazy viralAgentsPotionStack$delegate = LazyKt.lazy(BrewingRecipes::viralAgentsPotionStack_delegate$lambda$8);
    @NotNull
    private static final Lazy curePotionStack$delegate = LazyKt.lazy(BrewingRecipes::curePotionStack_delegate$lambda$9);

    private BrewingRecipes() {
    }

    private final List<Potion> getModPotions() {
        Lazy lazy = modPotions$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<IBrewingRecipe> getAllRecipes() {
        return allRecipes;
    }

    public final void tooltip(@NotNull ItemTooltipEvent event) {
        EntityType<?> itemEntity;
        Gene itemGene;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack stack = event.getItemStack();
        Intrinsics.checkNotNull((Object)stack);
        Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(stack);
        if (holder == null) {
            return;
        }
        Holder<Potion> itemPotion = holder;
        if (Intrinsics.areEqual(itemPotion, ModPotions.INSTANCE.getZOMBIFY_VILLAGER()) || Intrinsics.areEqual(itemPotion, ModPotions.INSTANCE.getPANACEA())) {
            return;
        }
        if (!this.getModPotions().contains(itemPotion.value())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.POTION)) {
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.potion.ignore", new Object[0]).withStyle(BrewingRecipes::tooltip$lambda$2));
        }
        if ((itemGene = DnaHelixItem.Companion.getGene(stack)) != null) {
            Object[] objectArray = new Object[]{itemGene.getNameComponent()};
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray).withStyle(BrewingRecipes::tooltip$lambda$3));
        }
        if ((itemEntity = EntityDnaItem.Companion.getEntityType(stack)) != null) {
            Object[] objectArray = new Object[]{itemEntity.getDescription()};
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.helix_entity", objectArray).withStyle(BrewingRecipes::tooltip$lambda$4));
        }
    }

    private final Ingredient ingredient(Holder<Potion> potion) {
        Ingredient ingredient = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack(potion));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    private final Ingredient ingredient(ItemLike itemLike) {
        ItemLike[] itemLikeArray = new ItemLike[]{itemLike};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    private final Ingredient ingredient(ItemStack itemStack) {
        Ingredient ingredient = DataComponentIngredient.of((boolean)false, (ItemStack)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    @NotNull
    public final ItemStack getSubstratePotionStack() {
        Lazy lazy = substratePotionStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    @NotNull
    public final ItemStack getCellGrowthPotionStack() {
        Lazy lazy = cellGrowthPotionStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    @NotNull
    public final ItemStack getMutationPotionStack() {
        Lazy lazy = mutationPotionStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    @NotNull
    public final ItemStack getViralAgentsPotionStack() {
        Lazy lazy = viralAgentsPotionStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    @NotNull
    public final ItemStack getCurePotionStack() {
        Lazy lazy = curePotionStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    public final void setRecipes(@NotNull RegisterBrewingRecipesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        allRecipes.clear();
        Holder holder = Potions.MUNDANE;
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"MUNDANE");
        BrewingRecipe substrateRecipe = new BrewingRecipe(this.ingredient((Holder<Potion>)holder), this.ingredient((ItemLike)ModItems.INSTANCE.getORGANIC_MATTER()), this.getSubstratePotionStack());
        Ingredient ingredient = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getSUBSTRATE()));
        ItemStack itemStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
        BrewingRecipe cellGrowthRecipe = new BrewingRecipe(ingredient, this.ingredient(DnaHelixItem.Companion.setBasic(itemStack)), this.getCellGrowthPotionStack());
        Ingredient ingredient2 = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getCELL_GROWTH()));
        Item item = Items.FERMENTED_SPIDER_EYE;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"FERMENTED_SPIDER_EYE");
        BrewingRecipe mutationRecipe = new BrewingRecipe(ingredient2, this.ingredient((ItemLike)item), this.getMutationPotionStack());
        Ingredient ingredient3 = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getMUTATION()));
        Item item2 = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"CHORUS_FRUIT");
        BrewingRecipe viralRecipe = new BrewingRecipe(ingredient3, this.ingredient((ItemLike)item2), this.getViralAgentsPotionStack());
        Ingredient ingredient4 = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getVIRAL_AGENTS()));
        ItemStack itemStack2 = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"toStack(...)");
        BrewingRecipe panaceaRecipe = new BrewingRecipe(ingredient4, this.ingredient(DnaHelixItem.Companion.setGene(itemStack2, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getREGENERATION()))), this.getCurePotionStack());
        Object[] objectArray = new BrewingRecipe[]{substrateRecipe, cellGrowthRecipe, mutationRecipe, viralRecipe, panaceaRecipe};
        allRecipes.addAll(CollectionsKt.listOf((Object[])objectArray));
        SubstrateCellRecipe substrateDuplicationRecipe = new SubstrateCellRecipe();
        allRecipes.add(substrateDuplicationRecipe);
        SetPotionEntityRecipe setPcgEntityRecipe = new SetPotionEntityRecipe();
        allRecipes.add(setPcgEntityRecipe);
        Object[] objectArray2 = new GmoRecipe[12];
        EntityType entityType = EntityType.BLAZE;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"BLAZE");
        Item item3 = Items.GLOWSTONE_DUST;
        Intrinsics.checkNotNullExpressionValue((Object)item3, (String)"GLOWSTONE_DUST");
        Object object = ModGenes.INSTANCE.getBIOLUMINESCENCE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        objectArray2[0] = new GmoRecipe(entityType, item3, (Gene)object, 0.85f, false, 16, null);
        EntityType entityType2 = EntityType.MAGMA_CUBE;
        Intrinsics.checkNotNullExpressionValue((Object)entityType2, (String)"MAGMA_CUBE");
        Item item4 = Items.GLOWSTONE_DUST;
        Intrinsics.checkNotNullExpressionValue((Object)item4, (String)"GLOWSTONE_DUST");
        Object object2 = ModGenes.INSTANCE.getBIOLUMINESCENCE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        objectArray2[1] = new GmoRecipe(entityType2, item4, (Gene)object2, 0.85f, false, 16, null);
        EntityType entityType3 = EntityType.VILLAGER;
        Intrinsics.checkNotNullExpressionValue((Object)entityType3, (String)"VILLAGER");
        Item item5 = Items.EMERALD;
        Intrinsics.checkNotNullExpressionValue((Object)item5, (String)"EMERALD");
        Object object3 = ModGenes.INSTANCE.getEMERALD_HEART().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        objectArray2[2] = new GmoRecipe(entityType3, item5, (Gene)object3, 0.85f, false, 16, null);
        EntityType entityType4 = EntityType.SHULKER;
        Intrinsics.checkNotNullExpressionValue((Object)entityType4, (String)"SHULKER");
        Item item6 = Items.EMERALD_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)item6, (String)"EMERALD_BLOCK");
        Object object4 = ModGenes.INSTANCE.getKEEP_INVENTORY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        objectArray2[3] = new GmoRecipe(entityType4, item6, (Gene)object4, 0.45f, false, 16, null);
        EntityType entityType5 = EntityType.RABBIT;
        Intrinsics.checkNotNullExpressionValue((Object)entityType5, (String)"RABBIT");
        Item item7 = Items.GOLDEN_BOOTS;
        Intrinsics.checkNotNullExpressionValue((Object)item7, (String)"GOLDEN_BOOTS");
        Object object5 = ModGenes.INSTANCE.getSPEED().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        objectArray2[4] = new GmoRecipe(entityType5, item7, (Gene)object5, 0.65f, false, 16, null);
        EntityType entityType6 = EntityType.RABBIT;
        Intrinsics.checkNotNullExpressionValue((Object)entityType6, (String)"RABBIT");
        Item item8 = Items.EMERALD;
        Intrinsics.checkNotNullExpressionValue((Object)item8, (String)"EMERALD");
        Object object6 = ModGenes.INSTANCE.getLUCK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        objectArray2[5] = new GmoRecipe(entityType6, item8, (Gene)object6, 0.75f, false, 16, null);
        EntityType entityType7 = EntityType.IRON_GOLEM;
        Intrinsics.checkNotNullExpressionValue((Object)entityType7, (String)"IRON_GOLEM");
        Item item9 = Items.GOLDEN_APPLE;
        Intrinsics.checkNotNullExpressionValue((Object)item9, (String)"GOLDEN_APPLE");
        Object object7 = ModGenes.INSTANCE.getREGENERATION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        objectArray2[6] = new GmoRecipe(entityType7, item9, (Gene)object7, 0.3f, false, 16, null);
        EntityType entityType8 = EntityType.CHICKEN;
        Intrinsics.checkNotNullExpressionValue((Object)entityType8, (String)"CHICKEN");
        Item item10 = Items.EGG;
        Intrinsics.checkNotNullExpressionValue((Object)item10, (String)"EGG");
        Object object8 = ModGenes.INSTANCE.getLAY_EGG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
        objectArray2[7] = new GmoRecipe(entityType8, item10, (Gene)object8, 1.0f, false, 16, null);
        EntityType entityType9 = EntityType.PIG;
        Intrinsics.checkNotNullExpressionValue((Object)entityType9, (String)"PIG");
        Item item11 = Items.PORKCHOP;
        Intrinsics.checkNotNullExpressionValue((Object)item11, (String)"PORKCHOP");
        Object object9 = ModGenes.INSTANCE.getMEATY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
        objectArray2[8] = new GmoRecipe(entityType9, item11, (Gene)object9, 1.0f, false, 16, null);
        EntityType entityType10 = EntityType.ENDERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)entityType10, (String)"ENDERMAN");
        Item item12 = Items.ENDER_PEARL;
        Intrinsics.checkNotNullExpressionValue((Object)item12, (String)"ENDER_PEARL");
        Object object10 = ModGenes.INSTANCE.getTELEPORT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"get(...)");
        objectArray2[9] = new GmoRecipe(entityType10, item12, (Gene)object10, 0.45f, false, 16, null);
        EntityType entityType11 = EntityType.ENDERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)entityType11, (String)"ENDERMAN");
        Item item13 = Items.GOLDEN_APPLE;
        Intrinsics.checkNotNullExpressionValue((Object)item13, (String)"GOLDEN_APPLE");
        Object object11 = ModGenes.INSTANCE.getMORE_HEARTS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"get(...)");
        objectArray2[10] = new GmoRecipe(entityType11, item13, (Gene)object11, 0.2f, false, 16, null);
        EntityType entityType12 = EntityType.MOOSHROOM;
        Intrinsics.checkNotNullExpressionValue((Object)entityType12, (String)"MOOSHROOM");
        Item item14 = Items.MUSHROOM_STEM;
        Intrinsics.checkNotNullExpressionValue((Object)item14, (String)"MUSHROOM_STEM");
        Object object12 = ModGenes.INSTANCE.getPHOTOSYNTHESIS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"get(...)");
        objectArray2[11] = new GmoRecipe(entityType12, item14, (Gene)object12, 0.7f, false, 16, null);
        List geneFocusBrews = CollectionsKt.listOf((Object[])objectArray2);
        allRecipes.addAll(geneFocusBrews);
        Object[] objectArray3 = new GmoRecipe[13];
        EntityType entityType13 = EntityType.ENDER_DRAGON;
        Intrinsics.checkNotNullExpressionValue((Object)entityType13, (String)"ENDER_DRAGON");
        Item item15 = Items.ELYTRA;
        Intrinsics.checkNotNullExpressionValue((Object)item15, (String)"ELYTRA");
        Object object13 = ModGenes.INSTANCE.getFLIGHT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"get(...)");
        objectArray3[0] = new GmoRecipe(entityType13, item15, (Gene)object13, 0.55f, true);
        EntityType entityType14 = EntityType.POLAR_BEAR;
        Intrinsics.checkNotNullExpressionValue((Object)entityType14, (String)"POLAR_BEAR");
        Item item16 = Items.NETHERITE_SWORD;
        Intrinsics.checkNotNullExpressionValue((Object)item16, (String)"NETHERITE_SWORD");
        Object object14 = ModGenes.INSTANCE.getSTRENGTH_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"get(...)");
        objectArray3[1] = new GmoRecipe(entityType14, item16, (Gene)object14, 0.5f, true);
        EntityType entityType15 = EntityType.SHULKER;
        Intrinsics.checkNotNullExpressionValue((Object)entityType15, (String)"SHULKER");
        Item item17 = Items.NETHERITE_CHESTPLATE;
        Intrinsics.checkNotNullExpressionValue((Object)item17, (String)"NETHERITE_CHESTPLATE");
        Object object15 = ModGenes.INSTANCE.getRESISTANCE_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object15, (String)"get(...)");
        objectArray3[2] = new GmoRecipe(entityType15, item17, (Gene)object15, 0.5f, true);
        EntityType entityType16 = EntityType.POLAR_BEAR;
        Intrinsics.checkNotNullExpressionValue((Object)entityType16, (String)"POLAR_BEAR");
        Item item18 = Items.DIAMOND_SWORD;
        Intrinsics.checkNotNullExpressionValue((Object)item18, (String)"DIAMOND_SWORD");
        Object object16 = ModGenes.INSTANCE.getCLAWS_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object16, (String)"get(...)");
        objectArray3[3] = new GmoRecipe(entityType16, item18, (Gene)object16, 0.75f, true);
        EntityType entityType17 = EntityType.RABBIT;
        Intrinsics.checkNotNullExpressionValue((Object)entityType17, (String)"RABBIT");
        Item item19 = Items.DIAMOND_BOOTS;
        Intrinsics.checkNotNullExpressionValue((Object)item19, (String)"DIAMOND_BOOTS");
        Object object17 = ModGenes.INSTANCE.getSPEED_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object17, (String)"get(...)");
        objectArray3[4] = new GmoRecipe(entityType17, item19, (Gene)object17, 0.5f, true);
        EntityType entityType18 = EntityType.OCELOT;
        Intrinsics.checkNotNullExpressionValue((Object)entityType18, (String)"OCELOT");
        Item item20 = Items.NETHERITE_BOOTS;
        Intrinsics.checkNotNullExpressionValue((Object)item20, (String)"NETHERITE_BOOTS");
        Object object18 = ModGenes.INSTANCE.getSPEED_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object18, (String)"get(...)");
        objectArray3[5] = new GmoRecipe(entityType18, item20, (Gene)object18, 0.5f, true);
        EntityType entityType19 = EntityType.RABBIT;
        Intrinsics.checkNotNullExpressionValue((Object)entityType19, (String)"RABBIT");
        Item item21 = Items.NETHERITE_PICKAXE;
        Intrinsics.checkNotNullExpressionValue((Object)item21, (String)"NETHERITE_PICKAXE");
        Object object19 = ModGenes.INSTANCE.getHASTE_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object19, (String)"get(...)");
        objectArray3[6] = new GmoRecipe(entityType19, item21, (Gene)object19, 0.35f, true);
        EntityType entityType20 = EntityType.SILVERFISH;
        Intrinsics.checkNotNullExpressionValue((Object)entityType20, (String)"SILVERFISH");
        Item item22 = Items.NETHERITE_PICKAXE;
        Intrinsics.checkNotNullExpressionValue((Object)item22, (String)"NETHERITE_PICKAXE");
        Object object20 = ModGenes.INSTANCE.getEFFICIENCY_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object20, (String)"get(...)");
        objectArray3[7] = new GmoRecipe(entityType20, item22, (Gene)object20, 0.25f, true);
        EntityType entityType21 = EntityType.ZOMBIE;
        Intrinsics.checkNotNullExpressionValue((Object)entityType21, (String)"ZOMBIE");
        Item item23 = Items.FERMENTED_SPIDER_EYE;
        Intrinsics.checkNotNullExpressionValue((Object)item23, (String)"FERMENTED_SPIDER_EYE");
        Object object21 = ModGenes.INSTANCE.getSCARE_ZOMBIES().get();
        Intrinsics.checkNotNullExpressionValue((Object)object21, (String)"get(...)");
        objectArray3[8] = new GmoRecipe(entityType21, item23, (Gene)object21, 0.5f, true);
        EntityType entityType22 = EntityType.SPIDER;
        Intrinsics.checkNotNullExpressionValue((Object)entityType22, (String)"SPIDER");
        Item item24 = Items.FERMENTED_SPIDER_EYE;
        Intrinsics.checkNotNullExpressionValue((Object)item24, (String)"FERMENTED_SPIDER_EYE");
        Object object22 = ModGenes.INSTANCE.getSCARE_SPIDERS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object22, (String)"get(...)");
        objectArray3[9] = new GmoRecipe(entityType22, item24, (Gene)object22, 0.5f, true);
        EntityType entityType23 = EntityType.ENDER_DRAGON;
        Intrinsics.checkNotNullExpressionValue((Object)entityType23, (String)"ENDER_DRAGON");
        Item item25 = Items.ENCHANTED_GOLDEN_APPLE;
        Intrinsics.checkNotNullExpressionValue((Object)item25, (String)"ENCHANTED_GOLDEN_APPLE");
        Object object23 = ModGenes.INSTANCE.getREGENERATION_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object23, (String)"get(...)");
        objectArray3[10] = new GmoRecipe(entityType23, item25, (Gene)object23, 0.35f, true);
        EntityType entityType24 = EntityType.PIG;
        Intrinsics.checkNotNullExpressionValue((Object)entityType24, (String)"PIG");
        Item item26 = Items.BLAZE_POWDER;
        Intrinsics.checkNotNullExpressionValue((Object)item26, (String)"BLAZE_POWDER");
        Object object24 = ModGenes.INSTANCE.getMEATY_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object24, (String)"get(...)");
        objectArray3[11] = new GmoRecipe(entityType24, item26, (Gene)object24, 0.75f, true);
        EntityType entityType25 = EntityType.ENDERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)entityType25, (String)"ENDERMAN");
        Item item27 = Items.GOLDEN_APPLE;
        Intrinsics.checkNotNullExpressionValue((Object)item27, (String)"GOLDEN_APPLE");
        Object object25 = ModGenes.INSTANCE.getMORE_HEARTS_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object25, (String)"get(...)");
        objectArray3[12] = new GmoRecipe(entityType25, item27, (Gene)object25, 0.25f, true);
        List mutationBrews = CollectionsKt.listOf((Object[])objectArray3);
        allRecipes.addAll(mutationBrews);
        IBrewingRecipe[] iBrewingRecipeArray = new IBrewingRecipe[22];
        Object object26 = ModGenes.INSTANCE.getPOISON_IMMUNITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object26, (String)"get(...)");
        Gene gene = (Gene)object26;
        Object object27 = ModGenes.INSTANCE.getPOISON().get();
        Intrinsics.checkNotNullExpressionValue((Object)object27, (String)"get(...)");
        iBrewingRecipeArray[0] = new VirusRecipe(gene, (Gene)object27);
        Object object28 = ModGenes.INSTANCE.getWITHER_HIT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object28, (String)"get(...)");
        Gene gene2 = (Gene)object28;
        Object object29 = ModGenes.INSTANCE.getPOISON_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object29, (String)"get(...)");
        iBrewingRecipeArray[1] = new VirusRecipe(gene2, (Gene)object29);
        Object object30 = ModGenes.INSTANCE.getWITHER_PROOF().get();
        Intrinsics.checkNotNullExpressionValue((Object)object30, (String)"get(...)");
        Gene gene3 = (Gene)object30;
        Object object31 = ModGenes.INSTANCE.getWITHER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object31, (String)"get(...)");
        iBrewingRecipeArray[2] = new VirusRecipe(gene3, (Gene)object31);
        Object object32 = ModGenes.INSTANCE.getSTRENGTH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object32, (String)"get(...)");
        Gene gene4 = (Gene)object32;
        Object object33 = ModGenes.INSTANCE.getWEAKNESS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object33, (String)"get(...)");
        iBrewingRecipeArray[3] = new VirusRecipe(gene4, (Gene)object33);
        Object object34 = ModGenes.INSTANCE.getNIGHT_VISION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object34, (String)"get(...)");
        Gene gene5 = (Gene)object34;
        Object object35 = ModGenes.INSTANCE.getBLINDNESS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object35, (String)"get(...)");
        iBrewingRecipeArray[4] = new VirusRecipe(gene5, (Gene)object35);
        Object object36 = ModGenes.INSTANCE.getSPEED().get();
        Intrinsics.checkNotNullExpressionValue((Object)object36, (String)"get(...)");
        Gene gene6 = (Gene)object36;
        Object object37 = ModGenes.INSTANCE.getSLOWNESS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object37, (String)"get(...)");
        iBrewingRecipeArray[5] = new VirusRecipe(gene6, (Gene)object37);
        Object object38 = ModGenes.INSTANCE.getSPEED_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object38, (String)"get(...)");
        Gene gene7 = (Gene)object38;
        Object object39 = ModGenes.INSTANCE.getSLOWNESS_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object39, (String)"get(...)");
        iBrewingRecipeArray[6] = new VirusRecipe(gene7, (Gene)object39);
        Object object40 = ModGenes.INSTANCE.getSPEED_FOUR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object40, (String)"get(...)");
        Gene gene8 = (Gene)object40;
        Object object41 = ModGenes.INSTANCE.getSLOWNESS_SIX().get();
        Intrinsics.checkNotNullExpressionValue((Object)object41, (String)"get(...)");
        iBrewingRecipeArray[7] = new VirusRecipe(gene8, (Gene)object41);
        Object object42 = ModGenes.INSTANCE.getMILKY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object42, (String)"get(...)");
        Gene gene9 = (Gene)object42;
        Object object43 = ModGenes.INSTANCE.getNAUSEA().get();
        Intrinsics.checkNotNullExpressionValue((Object)object43, (String)"get(...)");
        iBrewingRecipeArray[8] = new VirusRecipe(gene9, (Gene)object43);
        Object object44 = ModGenes.INSTANCE.getMEATY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object44, (String)"get(...)");
        Gene gene10 = (Gene)object44;
        Object object45 = ModGenes.INSTANCE.getNAUSEA().get();
        Intrinsics.checkNotNullExpressionValue((Object)object45, (String)"get(...)");
        iBrewingRecipeArray[9] = new VirusRecipe(gene10, (Gene)object45);
        Object object46 = ModGenes.INSTANCE.getLAY_EGG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object46, (String)"get(...)");
        Gene gene11 = (Gene)object46;
        Object object47 = ModGenes.INSTANCE.getNAUSEA().get();
        Intrinsics.checkNotNullExpressionValue((Object)object47, (String)"get(...)");
        iBrewingRecipeArray[10] = new VirusRecipe(gene11, (Gene)object47);
        Object object48 = ModGenes.INSTANCE.getNO_HUNGER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object48, (String)"get(...)");
        Gene gene12 = (Gene)object48;
        Object object49 = ModGenes.INSTANCE.getHUNGER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object49, (String)"get(...)");
        iBrewingRecipeArray[11] = new VirusRecipe(gene12, (Gene)object49);
        Object object50 = ModGenes.INSTANCE.getFIRE_PROOF().get();
        Intrinsics.checkNotNullExpressionValue((Object)object50, (String)"get(...)");
        Gene gene13 = (Gene)object50;
        Object object51 = ModGenes.INSTANCE.getFLAMBE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object51, (String)"get(...)");
        iBrewingRecipeArray[12] = new VirusRecipe(gene13, (Gene)object51);
        Object object52 = ModGenes.INSTANCE.getLUCK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object52, (String)"get(...)");
        Gene gene14 = (Gene)object52;
        Object object53 = ModGenes.INSTANCE.getCURSED().get();
        Intrinsics.checkNotNullExpressionValue((Object)object53, (String)"get(...)");
        iBrewingRecipeArray[13] = new VirusRecipe(gene14, (Gene)object53);
        Object object54 = ModGenes.INSTANCE.getHASTE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object54, (String)"get(...)");
        Gene gene15 = (Gene)object54;
        Object object55 = ModGenes.INSTANCE.getMINING_FATIGUE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object55, (String)"get(...)");
        iBrewingRecipeArray[14] = new VirusRecipe(gene15, (Gene)object55);
        Object object56 = ModGenes.INSTANCE.getSCARE_CREEPERS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object56, (String)"get(...)");
        Gene gene16 = (Gene)object56;
        Object object57 = ModGenes.INSTANCE.getGREEN_DEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object57, (String)"get(...)");
        iBrewingRecipeArray[15] = new VirusRecipe(gene16, (Gene)object57);
        Object object58 = ModGenes.INSTANCE.getSCARE_SKELETONS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object58, (String)"get(...)");
        Gene gene17 = (Gene)object58;
        Object object59 = ModGenes.INSTANCE.getUN_UNDEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object59, (String)"get(...)");
        iBrewingRecipeArray[16] = new VirusRecipe(gene17, (Gene)object59);
        Object object60 = ModGenes.INSTANCE.getSCARE_ZOMBIES().get();
        Intrinsics.checkNotNullExpressionValue((Object)object60, (String)"get(...)");
        Gene gene18 = (Gene)object60;
        Object object61 = ModGenes.INSTANCE.getUN_UNDEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object61, (String)"get(...)");
        iBrewingRecipeArray[17] = new VirusRecipe(gene18, (Gene)object61);
        Object object62 = ModGenes.INSTANCE.getRESISTANCE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object62, (String)"get(...)");
        Gene gene19 = (Gene)object62;
        Object object63 = ModGenes.INSTANCE.getGRAY_DEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object63, (String)"get(...)");
        iBrewingRecipeArray[18] = new VirusRecipe(gene19, (Gene)object63);
        Object object64 = ModGenes.INSTANCE.getDRAGON_BREATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object64, (String)"get(...)");
        Gene gene20 = (Gene)object64;
        Object object65 = ModGenes.INSTANCE.getWHITE_DEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object65, (String)"get(...)");
        iBrewingRecipeArray[19] = new VirusRecipe(gene20, (Gene)object65);
        iBrewingRecipeArray[20] = new BlackDeathRecipe();
        Ingredient ingredient5 = this.ingredient(this.getViralAgentsPotionStack());
        ItemStack itemStack3 = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"toStack(...)");
        iBrewingRecipeArray[21] = new BrewingRecipe(ingredient5, this.ingredient(DnaHelixItem.Companion.setGene(itemStack3, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getEMERALD_HEART()))), OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getZOMBIFY_VILLAGER())));
        List virusBrews = CollectionsKt.listOf((Object[])iBrewingRecipeArray);
        allRecipes.addAll(virusBrews);
        for (IBrewingRecipe recipe : allRecipes) {
            event.getBuilder().addRecipe(recipe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List modPotions_delegate$lambda$1() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Collection collection = ModPotions.INSTANCE.getPOTION_REGISTRY().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntries(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeferredHolder deferredHolder = (DeferredHolder)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Potion)it.get());
        }
        return (List)var3_3;
    }

    private static final Style tooltip$lambda$2(Style it) {
        return it.withColor(ChatFormatting.RED);
    }

    private static final Style tooltip$lambda$3(Style it) {
        return it.withColor(ChatFormatting.GRAY);
    }

    private static final Style tooltip$lambda$4(Style it) {
        return it.withColor(ChatFormatting.GRAY);
    }

    private static final ItemStack substratePotionStack_delegate$lambda$5() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getSUBSTRATE()));
    }

    private static final ItemStack cellGrowthPotionStack_delegate$lambda$6() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getCELL_GROWTH()));
    }

    private static final ItemStack mutationPotionStack_delegate$lambda$7() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getMUTATION()));
    }

    private static final ItemStack viralAgentsPotionStack_delegate$lambda$8() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getVIRAL_AGENTS()));
    }

    private static final ItemStack curePotionStack_delegate$lambda$9() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getPANACEA()));
    }
}

