/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BlackDeathRecipe;", "Lnet/neoforged/neoforge/common/brewing/IBrewingRecipe;", "<init>", "()V", "isInput", "", "pBottomSlot", "Lnet/minecraft/world/item/ItemStack;", "isIngredient", "pTopSlot", "getOutput", "Companion", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nBlackDeathRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackDeathRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BlackDeathRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n774#2:52\n865#2,2:53\n*S KotlinDebug\n*F\n+ 1 BlackDeathRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BlackDeathRecipe\n*L\n28#1:52\n28#1:53,2\n*E\n"})
public final class BlackDeathRecipe
implements IBrewingRecipe {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final List<Gene> requiredGenes;

    public boolean isInput(@NotNull ItemStack pBottomSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        if (!Intrinsics.areEqual((Object)pBottomSlot.getItem(), (Object)Items.POTION)) {
            return false;
        }
        PotionContents potionContents = (PotionContents)pBottomSlot.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        PotionContents potionContents2 = potionContents;
        Potion inputPotion = (Potion)((Holder)potionContents2.potion().get()).value();
        return Intrinsics.areEqual((Object)inputPotion, (Object)ModPotions.INSTANCE.getVIRAL_AGENTS().get());
    }

    public boolean isIngredient(@NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        Item item = pTopSlot.getItem();
        if (!Intrinsics.areEqual((Object)item, (Object)ModItems.INSTANCE.getSYRINGE().get()) && !Intrinsics.areEqual((Object)item, (Object)ModItems.INSTANCE.getMETAL_SYRINGE().get())) {
            return false;
        }
        if (SyringeItem.Companion.isContaminated(pTopSlot)) {
            return false;
        }
        Set<Gene> syringeGenes = SyringeItem.Companion.getGenes(pTopSlot);
        return syringeGenes.containsAll((Collection)requiredGenes);
    }

    @NotNull
    public ItemStack getOutput(@NotNull ItemStack pBottomSlot, @NotNull ItemStack pTopSlot) {
        Intrinsics.checkNotNullParameter((Object)pBottomSlot, (String)"pBottomSlot");
        Intrinsics.checkNotNullParameter((Object)pTopSlot, (String)"pTopSlot");
        if (!this.isInput(pBottomSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (!this.isIngredient(pTopSlot)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack output = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)output);
        DnaHelixItem.Companion.setGene(output, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getBLACK_DEATH()));
        return output;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$filter$iv = GeneRegistry.INSTANCE.getRegistrySorted();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Gene it = (Gene)element$iv$iv;
            boolean bl = false;
            if (!(it.isNegative() && it.isActive() && !it.isHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        requiredGenes = CollectionsKt.minus((Iterable)((List)var3_3), (Object)ModGenes.INSTANCE.getBLACK_DEATH().get());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/brewing/BlackDeathRecipe$Companion;", "", "<init>", "()V", "requiredGenes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "kotlin.jvm.PlatformType", "getRequiredGenes", "()Ljava/util/List;", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Gene> getRequiredGenes() {
            return requiredGenes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

