/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.components.BooleanItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.item.components.GeneListItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.item.components.SpecificEntityItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J(\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "getUseDuration", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pHolder", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "pLevel", "Lnet/minecraft/world/level/Level;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "onUseTick", "", "pLivingEntity", "pRemainingUseDuration", "releaseUsing", "pTimeCharged", "getName", "Lnet/minecraft/network/chat/Component;", "appendHoverText", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21"})
public class SyringeItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceKey<DamageType> stepOnSyringeDamageKey;
    @NotNull
    private static final ResourceKey<DamageType> useSyringeDamageKey;

    public SyringeItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pHolder) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHolder, (String)"pHolder");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        ItemStack realStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)realStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    public void onUseTick(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        if (pRemainingUseDuration <= 1) {
            pLivingEntity.stopUsingItem();
            this.releaseUsing(pStack, pLevel, pLivingEntity, pRemainingUseDuration);
        }
    }

    public void releaseUsing(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeCharged) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        if (!(pLivingEntity instanceof Player) || pTimeCharged > 1) {
            return;
        }
        if (pLivingEntity instanceof FakePlayer) {
            return;
        }
        if (Companion.isContaminated(pStack)) {
            if (!pLevel.isClientSide) {
                pLivingEntity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.contaminated", new Object[0]));
            }
            return;
        }
        if (Companion.hasBlood(pStack)) {
            Companion.injectEntity(pStack, pLivingEntity);
        } else {
            dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem$Companion.setEntity$default(Companion, pStack, pLivingEntity, false, 4, null);
        }
        LivingEntity livingEntity = pLivingEntity;
        Player $this$releaseUsing_u24lambda_u240 = (Player)livingEntity;
        boolean bl = false;
        $this$releaseUsing_u24lambda_u240.hurt(Companion.damageSourceUseSyringe(pLevel, pLivingEntity), 1.0f);
        $this$releaseUsing_u24lambda_u240.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
        $this$releaseUsing_u24lambda_u240.getCooldowns().addCooldown((Item)ModItems.INSTANCE.getSYRINGE().get(), 10);
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return Companion.hasBlood(pStack) ? (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.syringe.full", new Object[0]) : (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.syringe.empty", new Object[0]);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Set<Gene> removingGenes;
        Set<Gene> addingGenes;
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        String bloodOwner = Companion.getEntityName(pStack);
        if (Companion.hasBlood(pStack) && bloodOwner != null) {
            Object[] objectArray = new Object[]{bloodOwner};
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.blood_owner", objectArray), ChatFormatting.GRAY));
        }
        if (Companion.isContaminated(pStack)) {
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.contaminated", new Object[0]), ChatFormatting.DARK_GREEN));
        }
        if (!((Collection)(addingGenes = Companion.getGenes(pStack))).isEmpty()) {
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.adding", new Object[0]), ChatFormatting.GRAY));
            for (Gene gene : addingGenes) {
                MutableComponent component = Component.literal((String)"\u2022 ").withStyle(arg_0 -> SyringeItem.appendHoverText$lambda$1(gene, arg_0)).append((Component)gene.getNameComponent());
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
        if (!((Collection)(removingGenes = Companion.getAntigenes(pStack))).isEmpty()) {
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.syringe.removing", new Object[0]), ChatFormatting.GRAY));
            for (Gene gene : removingGenes) {
                MutableComponent component = Component.literal((String)"\u2022 ").withStyle(arg_0 -> SyringeItem.appendHoverText$lambda$2(gene, arg_0)).append((Component)gene.getNameComponent());
                Intrinsics.checkNotNull((Object)component);
                pTooltipComponents.add((Component)component);
            }
        }
    }

    private static final Style appendHoverText$lambda$1(Gene $gene, Style it) {
        Intrinsics.checkNotNullParameter((Object)$gene, (String)"$gene");
        return it.withColor($gene.getNameComponent().getStyle().getColor());
    }

    private static final Style appendHoverText$lambda$2(Gene $gene, Style it) {
        Intrinsics.checkNotNullParameter((Object)$gene, (String)"$gene");
        return it.withColor($gene.getNameComponent().getStyle().getColor());
    }

    static {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("step_on_syringe"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        stepOnSyringeDamageKey = resourceKey;
        ResourceKey resourceKey2 = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("use_syringe"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"create(...)");
        useSyringeDamageKey = resourceKey2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0018J\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0018J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010$\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0018J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0018J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u000bR\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion;", "", "<init>", "()V", "isSyringe", "", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ItemStack;", "isBeingUsed", "syringeStack", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "setEntity", "", "pStack", "setContaminated", "getEntityUuid", "Ljava/util/UUID;", "getEntityName", "", "injectEntity", "removeGenes", "syringeAntigenes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "addGenes", "syringeGenes", "hasBlood", "getGenes", "canAddGene", "gene", "addGene", "clearGenes", "isContaminated", "value", "getAntigenes", "canAddAntigene", "addAntigene", "stepOnSyringeDamageKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "damageSourceStepOnSyringe", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "thrower", "useSyringeDamageKey", "damageSourceUseSyringe", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nSyringeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n774#2:364\n865#2,2:365\n*S KotlinDebug\n*F\n+ 1 SyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/SyringeItem$Companion\n*L\n88#1:364\n88#1:365,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSyringe(@NotNull Item $this$isSyringe) {
            Intrinsics.checkNotNullParameter((Object)$this$isSyringe, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isSyringe, (Object)ModItems.INSTANCE.getSYRINGE().get()) || Intrinsics.areEqual((Object)$this$isSyringe, (Object)ModItems.INSTANCE.getMETAL_SYRINGE().get());
        }

        public final boolean isSyringe(@NotNull ItemStack $this$isSyringe) {
            Intrinsics.checkNotNullParameter((Object)$this$isSyringe, (String)"<this>");
            Item item = $this$isSyringe.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            return this.isSyringe(item);
        }

        public final boolean isBeingUsed(@NotNull ItemStack syringeStack, @Nullable LivingEntity entity) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            if (entity == null) {
                return false;
            }
            return Intrinsics.areEqual((Object)entity.getUseItem(), (Object)syringeStack);
        }

        public final void setEntity(@NotNull ItemStack pStack, @Nullable LivingEntity entity, boolean setContaminated) {
            Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
            if (entity == null) {
                pStack.remove(SpecificEntityItemComponent.Companion.getComponent());
                return;
            }
            UUID uUID = entity.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            String string = entity.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            SpecificEntityItemComponent newComponent = new SpecificEntityItemComponent(uUID, string);
            pStack.set(SpecificEntityItemComponent.Companion.getComponent(), (Object)newComponent);
            if (setContaminated) {
                this.setContaminated(pStack, true);
            }
        }

        public static /* synthetic */ void setEntity$default(Companion companion, ItemStack itemStack, LivingEntity livingEntity, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.setEntity(itemStack, livingEntity, bl);
        }

        private final UUID getEntityUuid(ItemStack syringeStack) {
            return SpecificEntityItemComponent.Companion.getEntityUuid(syringeStack);
        }

        @Nullable
        public final String getEntityName(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            return SpecificEntityItemComponent.Companion.getEntityName(syringeStack);
        }

        /*
         * WARNING - void declaration
         */
        public final void injectEntity(@NotNull ItemStack syringeStack, @NotNull LivingEntity entity) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            UUID uUID = this.getEntityUuid(syringeStack);
            if (uUID == null) {
                return;
            }
            UUID syringeEntityUuid = uUID;
            if (!Intrinsics.areEqual((Object)entity.getUUID(), (Object)syringeEntityUuid)) {
                return;
            }
            if (entity instanceof Player) {
                set = this.getGenes(syringeStack);
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.getGenes(syringeStack);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Gene it = (Gene)element$iv$iv;
                    boolean bl = false;
                    if (!it.getCanMobsHave()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            Set genesToAdd = set;
            this.addGenes(entity, genesToAdd);
            this.removeGenes(entity, this.getAntigenes(syringeStack));
            this.clearGenes(syringeStack);
            dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem$Companion.setEntity$default(this, syringeStack, null, false, 4, null);
        }

        private final void removeGenes(LivingEntity entity, Set<Gene> syringeAntigenes) {
            Set<Gene> entityGenesBefore = GenesData.Companion.getGenes(entity);
            for (Gene antigene : syringeAntigenes) {
                GenesData.Companion.removeGene(entity, antigene);
            }
            Set<Gene> entityGenesAfter = GenesData.Companion.getGenes(entity);
            Set genesRemoved = SetsKt.minus(entityGenesBefore, (Iterable)entityGenesAfter);
            Set genesNotRemoved = SetsKt.minus(syringeAntigenes, (Iterable)genesRemoved);
            if (entity.level().isClientSide) {
                Object[] objectArray;
                for (Gene removedGene : genesRemoved) {
                    objectArray = new Object[]{removedGene.getNameComponent()};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.anti_gene.success", objectArray));
                }
                for (Gene notRemovedGene : genesNotRemoved) {
                    objectArray = new Object[]{notRemovedGene.getNameComponent()};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.anti_gene.fail", objectArray));
                }
            }
        }

        private final void addGenes(LivingEntity entity, Set<Gene> syringeGenes) {
            Set<Gene> entityGenesBefore = GenesData.Companion.getGenes(entity);
            Set<Gene> genesToAdd = entity instanceof Player ? syringeGenes : syringeGenes;
            for (Gene gene : genesToAdd) {
                GenesData.Companion.addGene(entity, gene);
            }
            Set<Gene> entityGenesAfter = GenesData.Companion.getGenes(entity);
            Set genesAdded = SetsKt.minus(entityGenesAfter, (Iterable)entityGenesBefore);
            Set genesNotAdded = SetsKt.minus(genesToAdd, (Iterable)genesAdded);
            if (entity.level().isClientSide) {
                Object[] objectArray;
                for (Gene addedGene : genesAdded) {
                    objectArray = new Object[]{addedGene.getNameComponent()};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.injected", objectArray));
                }
                for (Gene notAddedGene : genesNotAdded) {
                    objectArray = new Object[]{notAddedGene.getNameComponent()};
                    entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.syringe.failed", objectArray));
                }
            }
        }

        public final boolean hasBlood(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            return SpecificEntityItemComponent.Companion.hasEntity(syringeStack);
        }

        @NotNull
        public final Set<Gene> getGenes(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Object object = (GeneListItemComponent)syringeStack.get(GeneListItemComponent.Companion.getGenesComponent());
            if (object == null || (object = ((GeneListItemComponent)object).getGenes()) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        public final boolean canAddGene(@NotNull ItemStack syringeStack, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            return this.hasBlood(syringeStack) && !this.getGenes(syringeStack).contains(gene);
        }

        public final boolean addGene(@NotNull ItemStack syringeStack, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            if (!this.canAddGene(syringeStack, gene)) {
                return false;
            }
            Set<Gene> currentGenes = this.getGenes(syringeStack);
            Set newGenes = SetsKt.plus(currentGenes, (Object)gene);
            GeneListItemComponent newComponent = new GeneListItemComponent(newGenes);
            syringeStack.set(GeneListItemComponent.Companion.getGenesComponent(), (Object)newComponent);
            return true;
        }

        private final void clearGenes(ItemStack syringeStack) {
            syringeStack.remove(GeneListItemComponent.Companion.getGenesComponent());
        }

        public final boolean isContaminated(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            BooleanItemComponent booleanItemComponent = (BooleanItemComponent)syringeStack.get(BooleanItemComponent.Companion.isContaminatedComponent());
            return booleanItemComponent != null ? booleanItemComponent.getValue() : false;
        }

        public final void setContaminated(@NotNull ItemStack syringeStack, boolean value) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            syringeStack.set(BooleanItemComponent.Companion.isContaminatedComponent(), (Object)new BooleanItemComponent(value));
        }

        @NotNull
        public final Set<Gene> getAntigenes(@NotNull ItemStack syringeStack) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Object object = (GeneListItemComponent)syringeStack.get(GeneListItemComponent.Companion.getAntigenesComponent());
            if (object == null || (object = ((GeneListItemComponent)object).getGenes()) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }

        public final boolean canAddAntigene(@NotNull ItemStack syringeStack, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            return this.hasBlood(syringeStack) && !this.getAntigenes(syringeStack).contains(gene) && !this.getGenes(syringeStack).contains(gene);
        }

        public final boolean addAntigene(@NotNull ItemStack syringeStack, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)syringeStack, (String)"syringeStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            if (!this.canAddAntigene(syringeStack, gene)) {
                return false;
            }
            Set<Gene> currentAntigenes = this.getAntigenes(syringeStack);
            Set newGenes = SetsKt.plus(currentAntigenes, (Object)gene);
            GeneListItemComponent newComponent = new GeneListItemComponent(newGenes);
            syringeStack.set(GeneListItemComponent.Companion.getAntigenesComponent(), (Object)newComponent);
            return true;
        }

        @NotNull
        public final DamageSource damageSourceStepOnSyringe(@NotNull Level level, @Nullable LivingEntity thrower) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            DamageSource damageSource = level.damageSources().source(stepOnSyringeDamageKey, (Entity)thrower);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        @NotNull
        public final DamageSource damageSourceUseSyringe(@NotNull Level level, @Nullable LivingEntity thrower) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            DamageSource damageSource = level.damageSources().source(useSyringeDamageKey, (Entity)thrower);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

