/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.ModTags;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.enchantment.ModEnchantments;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/ScraperItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "pLevel", "Lnet/minecraft/world/level/Level;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pInteractionHand", "Lnet/minecraft/world/InteractionHand;", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "pStack", "pInteractionTarget", "Lnet/minecraft/world/entity/LivingEntity;", "pUsedHand", "Companion", "geneticsresequenced-1.21"})
public final class ScraperItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceKey<DamageType> useSyringeDamageKey;

    public ScraperItem() {
        super(new Item.Properties().durability(200));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pInteractionHand) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pInteractionHand, (String)"pInteractionHand");
        ItemStack realStack = pPlayer.getItemInHand(pInteractionHand);
        if (!pPlayer.isCrouching() || pPlayer instanceof FakePlayer) {
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)realStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            return interactionResultHolder2;
        }
        Intrinsics.checkNotNull((Object)realStack);
        boolean scrapeWorked = ScraperItem.Companion.scrapeEntity(pPlayer, realStack, pInteractionHand, (LivingEntity)pPlayer);
        if (scrapeWorked) {
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.success((Object)realStack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        } else {
            InteractionResultHolder interactionResultHolder4 = InteractionResultHolder.pass((Object)realStack);
            Intrinsics.checkNotNull((Object)interactionResultHolder4);
            interactionResultHolder = interactionResultHolder4;
        }
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pInteractionTarget, (String)"pInteractionTarget");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        if (pInteractionTarget.getType().is(ModTags.INSTANCE.getSCRAPER_ENTITY_BLACKLIST())) {
            if (!pPlayer.level().isClientSide) {
                pPlayer.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.scraper.cant_scrape", new Object[0]));
            }
            return InteractionResult.FAIL;
        }
        return ScraperItem.Companion.scrapeEntity(pPlayer, pStack, pUsedHand, pInteractionTarget) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    static {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("use_scraper"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        useSyringeDamageKey = resourceKey;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/ScraperItem$Companion;", "", "<init>", "()V", "scrapeEntity", "", "player", "Lnet/minecraft/world/entity/player/Player;", "stack", "Lnet/minecraft/world/item/ItemStack;", "hand", "Lnet/minecraft/world/InteractionHand;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "useSyringeDamageKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "getDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "source", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean scrapeEntity(Player player, ItemStack stack, InteractionHand hand, LivingEntity target) {
            boolean hasDelicateTouch;
            if (player.getCooldowns().isOnCooldown((Item)ModItems.INSTANCE.getSCRAPER().get())) {
                return false;
            }
            if (target.hurtTime > 0) {
                return false;
            }
            ItemStack itemStack = ModItems.INSTANCE.getORGANIC_MATTER().toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            EntityType entityType = target.getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
            ItemStack organicStack = EntityDnaItem.Companion.setEntityType(itemStack, entityType);
            if (!player.getInventory().add(organicStack)) {
                player.drop(organicStack, false);
            }
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            boolean bl = hasDelicateTouch = stack.getEnchantmentLevel(ModEnchantments.INSTANCE.getDelicateTouchHolder(level)) != 0;
            if (hasDelicateTouch) {
                player.getCooldowns().addCooldown((Item)ModItems.INSTANCE.getSCRAPER().get(), 10);
            } else {
                Level level2 = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
                target.hurt(this.getDamageSource(level2, (LivingEntity)player), 1.0f);
            }
            EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(stack);
            stack.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
            return true;
        }

        private final DamageSource getDamageSource(Level level, LivingEntity source) {
            DamageSource damageSource = level.damageSources().source(useSyringeDamageKey, (Entity)source);
            Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
            return damageSource;
        }

        static /* synthetic */ DamageSource getDamageSource$default(Companion companion, Level level, LivingEntity livingEntity, int n, Object object) {
            if ((n & 2) != 0) {
                livingEntity = null;
            }
            return companion.getDamageSource(level, livingEntity);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

