/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.components.PlasmidProgressItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "appendHoverText", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21"})
public final class PlasmidItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PlasmidItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        Gene gene = Companion.getGene(pStack);
        if (gene == null) {
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.empty", new Object[0]), ChatFormatting.GRAY));
            return;
        }
        Object[] objectArray = new Object[]{gene.getNameComponent()};
        pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.gene", objectArray), ChatFormatting.GRAY));
        if (Companion.isComplete(pStack)) {
            v0 = pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.complete", new Object[0]), ChatFormatting.GRAY));
        } else {
            int amountNeeded = gene.getDnaPointsRequired();
            int amount = Companion.getAmount(pStack);
            Object[] objectArray2 = new Object[]{amount, amountNeeded};
            v0 = pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid.amount", objectArray2), ChatFormatting.GRAY));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion;", "", "<init>", "()V", "hasGene", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "setGene", "", "gene", "amount", "", "getAmount", "setAmount", "increaseAmount", "isComplete", "getCompletedPlasmid", "getAllPlasmids", "", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nPlasmidItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlasmidItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n774#2:109\n865#2,2:110\n1557#2:112\n1628#2,3:113\n*S KotlinDebug\n*F\n+ 1 PlasmidItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/PlasmidItem$Companion\n*L\n62#1:109\n62#1:110,2\n62#1:112\n62#1:113,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return itemStack.has(PlasmidProgressItemComponent.Companion.getComponent());
        }

        @Nullable
        public final Gene getGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            PlasmidProgressItemComponent plasmidProgressItemComponent = (PlasmidProgressItemComponent)itemStack.get(PlasmidProgressItemComponent.Companion.getComponent());
            return plasmidProgressItemComponent != null ? plasmidProgressItemComponent.getGene() : null;
        }

        public final void setGene(@NotNull ItemStack itemStack, @NotNull Gene gene, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            PlasmidProgressItemComponent component = new PlasmidProgressItemComponent(gene, amount);
            itemStack.set(PlasmidProgressItemComponent.Companion.getComponent(), (Object)component);
        }

        public static /* synthetic */ void setGene$default(Companion companion, ItemStack itemStack, Gene gene, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            companion.setGene(itemStack, gene, n);
        }

        public final int getAmount(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            PlasmidProgressItemComponent plasmidProgressItemComponent = (PlasmidProgressItemComponent)itemStack.get(PlasmidProgressItemComponent.Companion.getComponent());
            return plasmidProgressItemComponent != null ? plasmidProgressItemComponent.getDnaPoints() : 0;
        }

        public final void setAmount(@NotNull ItemStack itemStack, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Gene gene = this.getGene(itemStack);
            if (gene == null) {
                return;
            }
            PlasmidProgressItemComponent component = new PlasmidProgressItemComponent(gene, amount);
            itemStack.set(PlasmidProgressItemComponent.Companion.getComponent(), (Object)component);
        }

        public final void increaseAmount(@NotNull ItemStack itemStack, int amount) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            this.setAmount(itemStack, this.getAmount(itemStack) + amount);
        }

        public static /* synthetic */ void increaseAmount$default(Companion companion, ItemStack itemStack, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            companion.increaseAmount(itemStack, n);
        }

        public final boolean isComplete(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Gene gene = this.getGene(itemStack);
            if (gene == null) {
                return false;
            }
            Gene gene2 = gene;
            return this.getAmount(itemStack) >= gene2.getDnaPointsRequired();
        }

        @NotNull
        public final ItemStack getCompletedPlasmid(@NotNull Gene gene) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            ItemStack $this$getCompletedPlasmid_u24lambda_u240 = itemStack = ModItems.INSTANCE.getPLASMID().toStack();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$getCompletedPlasmid_u24lambda_u240);
            Companion.setGene($this$getCompletedPlasmid_u24lambda_u240, gene, gene.getDnaPointsRequired());
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"apply(...)");
            return itemStack2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllPlasmids() {
            void $this$mapTo$iv$iv;
            Gene it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = GeneRegistry.INSTANCE.getRegistrySorted();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Gene)element$iv$iv;
                boolean bl = false;
                if (!(!it.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Gene)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getCompletedPlasmid(it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

