/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.item.components.SpecificEntityItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0016J(\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem;", "Ldev/aaronhowser/mods/geneticsresequenced/item/SyringeItem;", "<init>", "()V", "inventoryTick", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pLevel", "Lnet/minecraft/world/level/Level;", "pEntity", "Lnet/minecraft/world/entity/Entity;", "pSlotId", "", "pIsSelected", "", "getUseDuration", "pHolder", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "onUseTick", "pLivingEntity", "pRemainingUseDuration", "releaseUsing", "pTimeLeft", "getName", "Lnet/minecraft/network/chat/Component;", "Companion", "geneticsresequenced-1.21"})
public final class MetalSyringeItem
extends SyringeItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pEntity, (String)"pEntity");
        if (!pIsSelected) {
            return;
        }
        if (!(pEntity instanceof Player)) {
            return;
        }
        if (pEntity.tickCount % 40 != 0) {
            return;
        }
        if (!SyringeItem.Companion.hasBlood(pStack)) {
            return;
        }
        Object object = (SpecificEntityItemComponent)pStack.get(SpecificEntityItemComponent.Companion.getComponent());
        if (object == null || (object = ((SpecificEntityItemComponent)object).getEntityUuid()) == null) {
            return;
        }
        Object entityUuid = object;
        LivingEntity livingEntity = OtherUtil.INSTANCE.getNearbyEntityFromUuid((UUID)entityUuid, (LivingEntity)pEntity);
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 120, 0, false, false, false));
    }

    @Override
    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity pHolder) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHolder, (String)"pHolder");
        return 40;
    }

    @Override
    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return UseAnim.BOW;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @Override
    public void onUseTick(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        if (pRemainingUseDuration <= 1) {
            pLivingEntity.stopUsingItem();
            this.releaseUsing(pStack, pLevel, pLivingEntity, pRemainingUseDuration);
        }
    }

    @Override
    public void releaseUsing(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeLeft) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pLivingEntity, (String)"pLivingEntity");
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        if (pTimeLeft > 1) {
            return;
        }
        if (pLivingEntity instanceof FakePlayer) {
            return;
        }
        AttributeInstance attributeInstance = pLivingEntity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        double reachDistance = attributeInstance != null ? attributeInstance.getValue() : 3.0;
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)((Entity)pLivingEntity), (Vec3)((Player)pLivingEntity).getEyePosition(), (Vec3)((Player)pLivingEntity).getEyePosition().add(((Player)pLivingEntity).getLookAngle().scale(reachDistance)), (AABB)((Player)pLivingEntity).getBoundingBox().inflate(reachDistance), MetalSyringeItem::releaseUsing$lambda$0, (double)reachDistance);
        if (entityHitResult == null) {
            return;
        }
        EntityHitResult entityHitResult2 = entityHitResult;
        Entity entity = entityHitResult2.getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity targetEntity = livingEntity;
        if (SyringeItem.Companion.hasBlood(pStack)) {
            MetalSyringeItem.Companion.useFullSyringe(pStack, (Player)pLivingEntity, targetEntity);
        } else {
            LivingEntity livingEntity2;
            MetalSyringeItem.Companion.extractBlood(pStack, targetEntity);
            SyringeItem.Companion.setContaminated(pStack, true);
            LivingEntity $this$releaseUsing_u24lambda_u241 = livingEntity2 = targetEntity;
            boolean bl = false;
            $this$releaseUsing_u24lambda_u241.hurt(SyringeItem.Companion.damageSourceUseSyringe(pLevel, pLivingEntity), 1.0f);
            $this$releaseUsing_u24lambda_u241.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
        }
    }

    @Override
    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return SyringeItem.Companion.hasBlood(pStack) ? (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.metal_syringe.full", new Object[0]) : (Component)ModLanguageProvider.Companion.toComponent("item.geneticsresequenced.metal_syringe.empty", new Object[0]);
    }

    private static final boolean releaseUsing$lambda$0(Entity it) {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion;", "", "<init>", "()V", "useFullSyringe", "", "syringeStack", "Lnet/minecraft/world/item/ItemStack;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pTarget", "Lnet/minecraft/world/entity/LivingEntity;", "tryInjectBlood", "pInteractionTarget", "extractBlood", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nMetalSyringeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalSyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n774#2:177\n865#2,2:178\n*S KotlinDebug\n*F\n+ 1 MetalSyringeItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/MetalSyringeItem$Companion\n*L\n70#1:177\n70#1:178,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void useFullSyringe(ItemStack syringeStack, Player pPlayer, LivingEntity pTarget) {
            Object object = (SpecificEntityItemComponent)syringeStack.get(SpecificEntityItemComponent.Companion.getComponent());
            if (object == null || (object = ((SpecificEntityItemComponent)object).getEntityUuid()) == null) {
                return;
            }
            Object uuid = object;
            if (!Intrinsics.areEqual((Object)pTarget.getUUID(), (Object)uuid)) {
                return;
            }
            if (SyringeItem.Companion.isContaminated(syringeStack)) {
                if (!pPlayer.level().isClientSide) {
                    pPlayer.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.contaminated", new Object[0]));
                }
                return;
            }
            this.tryInjectBlood(syringeStack, pPlayer, pTarget);
        }

        /*
         * WARNING - void declaration
         */
        private final void tryInjectBlood(ItemStack syringeStack, Player pPlayer, LivingEntity pInteractionTarget) {
            SpecificEntityItemComponent specificEntityItemComponent = (SpecificEntityItemComponent)syringeStack.get(SpecificEntityItemComponent.Companion.getComponent());
            if (specificEntityItemComponent == null) {
                return;
            }
            SpecificEntityItemComponent component = specificEntityItemComponent;
            UUID entityUuid = component.getEntityUuid();
            if (!Intrinsics.areEqual((Object)entityUuid, (Object)pInteractionTarget.getUUID())) {
                dev.aaronhowser.mods.geneticsresequenced.item.MetalSyringeItem$Companion.tryInjectBlood$sendMessage(pPlayer, (Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.mismatch", new Object[0]));
                return;
            }
            if (!(pInteractionTarget instanceof Player)) {
                void $this$filterTo$iv$iv;
                Set<Gene> syringeGenes = SyringeItem.Companion.getGenes(syringeStack);
                Object[] $this$filter$iv = (Object[])syringeGenes;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Gene it = (Gene)element$iv$iv;
                    boolean bl = false;
                    if (!it.isNegative()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List genesCantAdd = (List)destination$iv$iv;
                for (Gene gene : genesCantAdd) {
                    objectArray = new Object[]{gene.getNameComponent()};
                    dev.aaronhowser.mods.geneticsresequenced.item.MetalSyringeItem$Companion.tryInjectBlood$sendMessage(pPlayer, (Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.metal_syringe.no_mobs", objectArray));
                }
            }
            SyringeItem.Companion.injectEntity(syringeStack, pInteractionTarget);
        }

        private final void extractBlood(ItemStack syringeStack, LivingEntity pInteractionTarget) {
            UUID uUID = pInteractionTarget.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            String string = pInteractionTarget.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            SpecificEntityItemComponent itemComponent = new SpecificEntityItemComponent(uUID, string);
            syringeStack.set(SpecificEntityItemComponent.Companion.getComponent(), (Object)itemComponent);
        }

        private static final void tryInjectBlood$sendMessage(Player $pPlayer, Component message) {
            if (!$pPlayer.level().isClientSide) {
                $pPlayer.sendSystemMessage(message);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

