/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.components.GeneItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem;", "Ldev/aaronhowser/mods/geneticsresequenced/item/EntityDnaItem;", "<init>", "()V", "appendHoverText", "", "pStack", "Lnet/minecraft/world/item/ItemStack;", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "showNoGeneTooltips", "Companion", "geneticsresequenced-1.21"})
public final class DnaHelixItem
extends EntityDnaItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        Gene gene = Companion.getGene(pStack);
        if (gene == null) {
            this.showNoGeneTooltips(pStack, pTooltipComponents);
        } else {
            Object[] objectArray = new Object[]{gene.getNameComponent()};
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray), ChatFormatting.GRAY));
        }
    }

    private final void showNoGeneTooltips(ItemStack pStack, List<Component> pTooltipComponents) {
        Object[] objectArray = new Object[]{Gene.Companion.getUnknownGeneComponent()};
        pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray), ChatFormatting.GRAY));
        EntityType<?> entity = EntityDnaItem.Companion.getEntityType(pStack);
        if (entity != null) {
            Object[] objectArray2 = new Object[]{entity.getDescription()};
            pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.helix_entity", objectArray2), ChatFormatting.GRAY));
        }
        try {
            boolean isCreative = ClientUtil.INSTANCE.playerIsCreative();
            if (isCreative) {
                MutableComponent component = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.dna_item.creative", new Object[0]), ChatFormatting.GRAY);
                pTooltipComponents.add((Component)component);
            }
        }
        catch (Exception e) {
            GeneticsResequenced.Companion.getLOGGER().error("DnaHelixItem isCreative check failed", (Throwable)e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion;", "", "<init>", "()V", "hasGene", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "setGene", "gene", "Lnet/minecraft/core/Holder;", "setBasic", "getAllHelices", "", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nDnaHelixItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnaHelixItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1557#2:108\n1628#2,2:109\n1630#2:112\n1#3:111\n*S KotlinDebug\n*F\n+ 1 DnaHelixItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/DnaHelixItem$Companion\n*L\n47#1:108\n47#1:109,2\n47#1:112\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return itemStack.has(GeneItemComponent.Companion.getComponent());
        }

        @Nullable
        public final Gene getGene(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            GeneItemComponent geneItemComponent = (GeneItemComponent)itemStack.get(GeneItemComponent.Companion.getComponent());
            return geneItemComponent != null ? geneItemComponent.getGene() : null;
        }

        @NotNull
        public final ItemStack setGene(@NotNull ItemStack itemStack, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            Object object = gene.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
            this.setGene(itemStack, (Gene)object);
            return itemStack;
        }

        @NotNull
        public final ItemStack setGene(@NotNull ItemStack itemStack, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            itemStack.set(GeneItemComponent.Companion.getComponent(), (Object)new GeneItemComponent(gene));
            return itemStack;
        }

        @NotNull
        public final ItemStack setBasic(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return this.setGene(itemStack, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getBASIC()));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllHelices() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GeneRegistry.INSTANCE.getRegistrySorted();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void gene;
                ItemStack itemStack;
                Gene gene2 = (Gene)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ItemStack $this$getAllHelices_u24lambda_u241_u24lambda_u240 = itemStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$this$getAllHelices_u24lambda_u241_u24lambda_u240);
                Companion.setGene($this$getAllHelices_u24lambda_u241_u24lambda_u240, (Gene)gene);
                collection.add(itemStack);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

