/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.item;

import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.components.BooleanItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/AntiFieldOrbItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "pLevel", "Lnet/minecraft/world/level/Level;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pUsedHand", "Lnet/minecraft/world/InteractionHand;", "isFoil", "", "pStack", "appendHoverText", "", "pContext", "Lnet/minecraft/world/item/Item$TooltipContext;", "pTooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "pTooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "geneticsresequenced-1.21"})
public final class AntiFieldOrbItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AntiFieldOrbItem() {
        super(new Item.Properties().stacksTo(1).component(BooleanItemComponent.Companion.isActiveComponent(), (Object)new BooleanItemComponent(false)));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pUsedHand, (String)"pUsedHand");
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        AntiFieldOrbItem.Companion.toggleEnabled(itemStack);
        InteractionResultHolder interactionResultHolder = super.use(pLevel, pPlayer, pUsedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        return AntiFieldOrbItem.Companion.isEnabled(pStack);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Intrinsics.checkNotNullParameter(pTooltipComponents, (String)"pTooltipComponents");
        Intrinsics.checkNotNullParameter((Object)pTooltipFlag, (String)"pTooltipFlag");
        String componentString = AntiFieldOrbItem.Companion.isEnabled(pStack) ? "tooltip.geneticsresequenced.antifield_active" : "tooltip.geneticsresequenced.antifield_inactive";
        pTooltipComponents.add((Component)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent(componentString, new Object[0]), ChatFormatting.GRAY));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/item/AntiFieldOrbItem$Companion;", "", "<init>", "()V", "isEnabled", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "toggleEnabled", "", "isActiveForPlayer", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nAntiFieldOrbItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntiFieldOrbItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/AntiFieldOrbItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1755#2,3:71\n*S KotlinDebug\n*F\n+ 1 AntiFieldOrbItem.kt\ndev/aaronhowser/mods/geneticsresequenced/item/AntiFieldOrbItem$Companion\n*L\n38#1:71,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isEnabled(ItemStack itemStack) {
            BooleanItemComponent booleanItemComponent = (BooleanItemComponent)itemStack.get(BooleanItemComponent.Companion.isActiveComponent());
            return booleanItemComponent != null ? booleanItemComponent.getValue() : false;
        }

        private final void toggleEnabled(ItemStack itemStack) {
            itemStack.set(BooleanItemComponent.Companion.isActiveComponent(), (Object)new BooleanItemComponent(!this.isEnabled(itemStack)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isActiveForPlayer(@NotNull Player player) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            NonNullList nonNullList = player.getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
            Iterable $this$any$iv = (Iterable)nonNullList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                ItemStack it = (ItemStack)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getItem(), (Object)ModItems.INSTANCE.getANTI_FIELD_ORB().get())) {
                    Intrinsics.checkNotNull((Object)it);
                    if (Companion.isEnabled(it)) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

