/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.ModTags;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.block.AntiFieldBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.BioluminescenceBlock;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.item.AntiFieldOrbItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000eJ\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\nR4\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes;", "", "<init>", "()V", "handleBioluminescence", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "handlePhotosynthesis", "handleNoHunger", "Lnet/minecraft/world/entity/player/Player;", "handleTickingGenes", "handleDeathGenes", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "virusDamageKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "kotlin.jvm.PlatformType", "Lnet/minecraft/resources/ResourceKey;", "virusDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "mapOfGeneToInferiorGenes", "", "", "handlePotionGenes", "potionGenes", "", "handlePotionGeneRemoved", "removedGene", "recentlyMeated2", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "handleMeaty2", "recentlyLaidEgg", "handleLayEgg", "handleMobSight", "handleItemMagnet", "player", "itemMagnetBlacklistTooltip", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "handleXpMagnet", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nTickGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1#2:330\n808#3,11:331\n1863#3,2:342\n*S KotlinDebug\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n*L\n249#1:331,11\n259#1:342,2\n*E\n"})
public final class TickGenes {
    @NotNull
    public static final TickGenes INSTANCE = new TickGenes();
    private static final ResourceKey<DamageType> virusDamageKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("virus"));
    @NotNull
    private static final Map<Gene, List<Gene>> mapOfGeneToInferiorGenes;
    @NotNull
    private static final GeneCooldown recentlyMeated2;
    @NotNull
    private static final GeneCooldown recentlyLaidEgg;

    private TickGenes() {
    }

    public final void handleBioluminescence(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!((Gene)ModGenes.INSTANCE.getBIOLUMINESCENCE().get()).isActive()) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getBioluminescenceCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        Level level = entity.level();
        if (level.getBrightness(LightLayer.BLOCK, entity.blockPosition()) > 8) {
            return;
        }
        Object object2 = ModGenes.INSTANCE.getBIOLUMINESCENCE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(entity, (Gene)object2)) {
            return;
        }
        BlockState headBlock = level.getBlockState(entity.blockPosition().above());
        if (!headBlock.isAir()) {
            return;
        }
        level.setBlockAndUpdate(entity.blockPosition().above(), ((BioluminescenceBlock)((Object)ModBlocks.INSTANCE.getBIOLUMINESCENCE_BLOCK().get())).defaultBlockState());
    }

    public final void handlePhotosynthesis(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!((Gene)ModGenes.INSTANCE.getPHOTOSYNTHESIS().get()).isActive()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getPhotosynthesisCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        Object object2 = ModGenes.INSTANCE.getPHOTOSYNTHESIS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(entity, (Gene)object2)) {
            return;
        }
        FoodData foodData = ((Player)entity).getFoodData();
        if (!foodData.needsFood()) {
            return;
        }
        boolean inDirectSunlight = entity.level().canSeeSky(entity.blockPosition());
        boolean isDay = entity.level().isDay();
        if (!inDirectSunlight || !isDay) {
            return;
        }
        Object object3 = ServerConfig.Companion.getPhotoSynthesisHungerAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        foodData.eat(((Number)object3).intValue(), (float)((Number)ServerConfig.Companion.getPhotoSynthesisSaturationAmount().get()).doubleValue());
    }

    public final void handleNoHunger(@NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!((Gene)ModGenes.INSTANCE.getNO_HUNGER().get()).isActive()) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getNoHungerCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Object object2 = ModGenes.INSTANCE.getNO_HUNGER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object2)) {
            return;
        }
        FoodData foodData = entity.getFoodData();
        int n2 = foodData.getFoodLevel();
        Object object3 = ServerConfig.Companion.getNoHungerMinimum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        int n3 = ((Number)object3).intValue();
        foodData.setFoodLevel(Math.max(n2, n3));
    }

    public final void handleTickingGenes(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getPassivesCheckCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!(entity instanceof Mob) && !(entity instanceof Player)) {
            return;
        }
        Set<Gene> genes = GenesData.Companion.getGenes(entity);
        List potionGenes = new ArrayList();
        for (Gene gene : genes) {
            Gene gene2;
            if (!gene.isActive()) continue;
            if (gene.getPotion() != null) {
                potionGenes.add(gene);
            }
            if (Intrinsics.areEqual((Object)(gene2 = gene), (Object)ModGenes.INSTANCE.getWATER_BREATHING().get())) {
                entity.setAirSupply(entity.getMaxAirSupply());
                continue;
            }
            if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getFLAMBE().get())) {
                entity.setRemainingFireTicks(((Number)ServerConfig.Companion.getPassivesCheckCooldown().get()).intValue() * 2 * 20);
                continue;
            }
            if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getLAY_EGG().get())) {
                this.handleLayEgg(entity);
                continue;
            }
            if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getMEATY_TWO().get())) {
                this.handleMeaty2(entity);
                continue;
            }
            if (!Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getGREEN_DEATH().get()) && !Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getUN_UNDEATH().get()) && !Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getGRAY_DEATH().get()) && !Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getWHITE_DEATH().get()) && !Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getBLACK_DEATH().get())) continue;
            this.handleDeathGenes(entity, gene);
        }
        this.handlePotionGenes(entity, potionGenes);
    }

    private final void handleDeathGenes(LivingEntity entity, Gene gene) {
        Function1 function1;
        Gene gene2;
        if (Intrinsics.areEqual((Object)gene, (Object)ModGenes.INSTANCE.getBLACK_DEATH().get())) {
            Level level = entity.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            entity.hurt(this.virusDamageSource(level), entity.getMaxHealth() * (float)1000);
            entity.kill();
            if (entity.isAlive()) {
                DamageSources damageSources = entity.level().damageSources();
                entity.hurt(damageSources.fellOutOfWorld(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.magic(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.wither(), entity.getMaxHealth() * (float)1000);
                if (entity.isAlive()) {
                    entity.remove(Entity.RemovalReason.KILLED);
                }
            }
        }
        if (Intrinsics.areEqual((Object)(gene2 = gene), (Object)ModGenes.INSTANCE.getGREEN_DEATH().get())) {
            function1 = TickGenes::handleDeathGenes$lambda$0;
        } else if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getUN_UNDEATH().get())) {
            function1 = TickGenes::handleDeathGenes$lambda$1;
        } else if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getGRAY_DEATH().get())) {
            function1 = TickGenes::handleDeathGenes$lambda$2;
        } else if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getWHITE_DEATH().get())) {
            function1 = TickGenes::handleDeathGenes$lambda$3;
        } else {
            return;
        }
        Function1 entityPredicate = function1;
        if (!((Boolean)entityPredicate.invoke((Object)entity)).booleanValue()) {
            return;
        }
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        entity.hurt(this.virusDamageSource(level), Math.max(entity.getHealth() / (float)2, 2.0f));
    }

    private final DamageSource virusDamageSource(Level level) {
        DamageSource damageSource = level.damageSources().source(virusDamageKey);
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
        return damageSource;
    }

    private final void handlePotionGenes(LivingEntity entity, List<Gene> potionGenes) {
        if (potionGenes.isEmpty()) {
            return;
        }
        List genesToSkip = new ArrayList();
        for (Gene gene : CollectionsKt.toList((Iterable)potionGenes)) {
            List<Gene> redundantGenes;
            if (mapOfGeneToInferiorGenes.get(gene) == null) continue;
            boolean bl = false;
            genesToSkip.addAll((Collection)redundantGenes);
        }
        potionGenes.removeAll(genesToSkip);
        for (Gene gene : potionGenes) {
            MobEffectInstance potion;
            if (gene.getPotion() == null) continue;
            entity.removeEffect(potion.getEffect());
            entity.addEffect(potion);
        }
    }

    public final void handlePotionGeneRemoved(@NotNull LivingEntity entity, @NotNull Gene removedGene) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)removedGene, (String)"removedGene");
        MobEffectInstance mobEffectInstance = removedGene.getPotion();
        if (mobEffectInstance == null) {
            return;
        }
        MobEffectInstance potion = mobEffectInstance;
        entity.removeEffect(potion.getEffect());
    }

    private final void handleMeaty2(LivingEntity entity) {
        Object v1;
        block2: {
            boolean newlyMeated = recentlyMeated2.add(entity);
            if (!newlyMeated) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity meatEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.COOKED_PORKCHOP, 1 + luck));
        entity.level().addFreshEntity((Entity)meatEntity);
    }

    private final void handleLayEgg(LivingEntity entity) {
        Object v1;
        block2: {
            boolean hasNotRecentlyLainEgg = recentlyLaidEgg.add(entity);
            if (!hasNotRecentlyLainEgg) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity eggEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.EGG, 1 + luck));
        entity.level().addFreshEntity((Entity)eggEntity);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleMobSight(@NotNull Player entity) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!((Gene)ModGenes.INSTANCE.getMOB_SIGHT().get()).isActive()) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getMobSightCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Object object2 = ModGenes.INSTANCE.getMOB_SIGHT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object2)) {
            return;
        }
        AABB aABB = entity.getBoundingBox();
        Object object3 = ServerConfig.Companion.getMobSightRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        AABB searchArea = aABB.inflate(((Number)object3).doubleValue());
        List list = entity.level().getEntities((Entity)entity, searchArea);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Mob)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nearbyLivingEntities = (List)destination$iv$iv;
        MobEffectInstance glowingEffect = new MobEffectInstance(MobEffects.GLOWING, Math.max(((Number)ServerConfig.Companion.getMobSightCooldown().get()).intValue() * 4, 600), 0, false, false);
        Iterable $this$forEach$iv = nearbyLivingEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            it.addEffect(glowingEffect);
        }
    }

    public final void handleItemMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Gene)ModGenes.INSTANCE.getITEM_MAGNET().get()).isActive()) {
            return;
        }
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getItemMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)player;
        Object object2 = ModGenes.INSTANCE.getITEM_MAGNET().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object2)) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object3 = ServerConfig.Companion.getItemMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, aABB.inflate(((Number)object3).doubleValue()));
        for (ItemEntity itemEntity : nearbyItems) {
            if (itemEntity.getItem().getCount() <= 0 || Intrinsics.areEqual((Object)itemEntity.getOwner(), (Object)player) && itemEntity.getAge() < 60 || itemEntity.getItem().is(ModTags.INSTANCE.getMAGNET_ITEM_BLACKLIST())) continue;
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = itemEntity.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            itemEntity.playerTouch(player);
        }
    }

    public final void itemMagnetBlacklistTooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Boolean)ClientConfig.Companion.getItemMagnetBlacklistTooltip().get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Player player2 = player;
        LivingEntity livingEntity = (LivingEntity)player2;
        Object object = ModGenes.INSTANCE.getITEM_MAGNET().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object)) {
            return;
        }
        ItemStack item = event.getItemStack();
        if (!item.is(ModTags.INSTANCE.getMAGNET_ITEM_BLACKLIST())) {
            return;
        }
        MutableComponent component = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.item_magnet_blacklist", new Object[0]), ChatFormatting.DARK_GRAY);
        event.getToolTip().add(component);
    }

    public final void handleXpMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Gene)ModGenes.INSTANCE.getXP_MAGNET().get()).isActive()) {
            return;
        }
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getXpMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)player;
        Object object2 = ModGenes.INSTANCE.getXP_MAGNET().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object2)) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object3 = ServerConfig.Companion.getXpMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        List nearbyXpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, aABB.inflate(((Number)object3).doubleValue()));
        for (ExperienceOrb xpOrb : nearbyXpOrbs) {
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = xpOrb.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            xpOrb.playerTouch(player);
            player.takeXpDelay = 1;
        }
    }

    private static final boolean handleDeathGenes$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof Creeper;
    }

    private static final boolean handleDeathGenes$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().is(EntityTypeTags.UNDEAD);
    }

    private static final boolean handleDeathGenes$lambda$2(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AgeableMob || it instanceof Zombie || it instanceof Piglin;
    }

    private static final boolean handleDeathGenes$lambda$3(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().getCategory() == MobCategory.MONSTER;
    }

    static {
        Pair[] pairArray = new Pair[9];
        Object[] objectArray = new Gene[]{ModGenes.INSTANCE.getSPEED().get(), ModGenes.INSTANCE.getSPEED_TWO().get()};
        pairArray[0] = TuplesKt.to((Object)ModGenes.INSTANCE.getSPEED_FOUR().get(), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[1] = TuplesKt.to((Object)ModGenes.INSTANCE.getSPEED_TWO().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getSPEED().get()));
        pairArray[2] = TuplesKt.to((Object)ModGenes.INSTANCE.getREGENERATION_FOUR().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getREGENERATION().get()));
        pairArray[3] = TuplesKt.to((Object)ModGenes.INSTANCE.getHASTE_TWO().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getHASTE().get()));
        pairArray[4] = TuplesKt.to((Object)ModGenes.INSTANCE.getRESISTANCE_TWO().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getRESISTANCE().get()));
        pairArray[5] = TuplesKt.to((Object)ModGenes.INSTANCE.getSTRENGTH_TWO().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getSTRENGTH().get()));
        pairArray[6] = TuplesKt.to((Object)ModGenes.INSTANCE.getPOISON_FOUR().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getPOISON().get()));
        pairArray[7] = TuplesKt.to((Object)ModGenes.INSTANCE.getSLOWNESS_FOUR().get(), (Object)CollectionsKt.listOf((Object)ModGenes.INSTANCE.getSLOWNESS().get()));
        objectArray = new Gene[]{ModGenes.INSTANCE.getSLOWNESS().get(), ModGenes.INSTANCE.getSLOWNESS_FOUR().get()};
        pairArray[8] = TuplesKt.to((Object)ModGenes.INSTANCE.getSLOWNESS_SIX().get(), (Object)CollectionsKt.listOf((Object[])objectArray));
        mapOfGeneToInferiorGenes = MapsKt.mapOf((Pair[])pairArray);
        Object object = ModGenes.INSTANCE.getMEATY_TWO().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Gene gene = (Gene)object;
        Object object2 = ServerConfig.Companion.getMeaty2Cooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        recentlyMeated2 = new GeneCooldown(gene, ((Number)object2).intValue(), false);
        Object object3 = ModGenes.INSTANCE.getLAY_EGG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Gene gene2 = (Gene)object3;
        Object object4 = ServerConfig.Companion.getEggCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        recentlyLaidEgg = new GeneCooldown(gene2, ((Number)object4).intValue(), false);
    }
}

