/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.vectorutil.v3d.Vec3UtilKt;
import thedarkcolour.kotlinforforge.neoforge.forge.vectorutil.v3d.Vec3iUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/PacketGenes;", "", "<init>", "()V", "recentTeleports", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "teleport", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "recentDragonsBreath", "dragonBreath", "geneticsresequenced-1.21"})
public final class PacketGenes {
    @NotNull
    public static final PacketGenes INSTANCE = new PacketGenes();
    @NotNull
    private static final GeneCooldown recentTeleports;
    @NotNull
    private static final GeneCooldown recentDragonsBreath;

    private PacketGenes() {
    }

    public final void teleport(@NotNull ServerPlayer player) {
        Direction sideHit;
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Gene)ModGenes.INSTANCE.getTELEPORT().get()).isActive()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)player;
        Object object = ModGenes.INSTANCE.getTELEPORT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object)) {
            return;
        }
        boolean wasNotOnCooldown = recentTeleports.add((LivingEntity)player);
        if (!wasNotOnCooldown) {
            return;
        }
        Vec3 vec32 = player.getLookAngle().normalize();
        Object object2 = ServerConfig.Companion.getTeleportDistance().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Vec3 teleportDestination = vec32.scale(((Number)object2).doubleValue());
        BlockHitResult blockHitResult = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(teleportDestination), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        BlockHitResult lookingAtBlock = blockHitResult;
        if (lookingAtBlock.getType() == HitResult.Type.MISS) {
            vec3 = player.getEyePosition().add(teleportDestination);
        } else {
            Vec3 blockLocation = lookingAtBlock.getLocation();
            Direction direction = sideHit = lookingAtBlock.getDirection();
            Vec3 offset = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> new Vec3(0.0, -2.0, 0.0);
                case 2 -> new Vec3(0.0, 0.5, 0.0);
                default -> {
                    Vec3i v8 = sideHit.getNormal();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getNormal(...)");
                    yield Vec3iUtilKt.toVec3((Vec3i)v8);
                }
            };
            vec3 = blockLocation.add(offset);
        }
        Vec3 destination = vec3;
        Level level = player.level();
        sideHit = destination;
        Intrinsics.checkNotNull((Object)sideHit);
        BlockState blockAtNewFootLocation = level.getBlockState(new BlockPos(Vec3UtilKt.toVec3i((Vec3)sideHit).offset(0, -1, 0)));
        BlockGetter blockGetter = (BlockGetter)player.level();
        Vec3 vec33 = destination;
        Intrinsics.checkNotNull((Object)vec33);
        boolean footBlockIsSolid = blockAtNewFootLocation.entityCanStandOn(blockGetter, new BlockPos(Vec3UtilKt.toVec3i((Vec3)vec33)), (Entity)player);
        if (footBlockIsSolid) {
            destination = destination.add(0.0, 1.0, 0.0);
        }
        player.teleportTo(destination.x, destination.y, destination.z);
    }

    public final void dragonBreath(@NotNull ServerPlayer player) {
        DragonFireball dragonFireball;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Gene)ModGenes.INSTANCE.getDRAGON_BREATH().get()).isActive()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)player;
        Object object = ModGenes.INSTANCE.getDRAGON_BREATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object)) {
            return;
        }
        boolean wasNotOnCooldown = recentDragonsBreath.add((LivingEntity)player);
        if (!wasNotOnCooldown) {
            return;
        }
        DragonFireball $this$dragonBreath_u24lambda_u240 = dragonFireball = new DragonFireball(player.level(), (LivingEntity)player, player.getLookAngle());
        boolean bl = false;
        $this$dragonBreath_u24lambda_u240.setPos(player.getEyePosition());
        DragonFireball entityDragonFireball = dragonFireball;
        player.level().addFreshEntity((Entity)entityDragonFireball);
    }

    static {
        Object object = ModGenes.INSTANCE.getTELEPORT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Gene gene = (Gene)object;
        Object object2 = ServerConfig.Companion.getTeleportCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        recentTeleports = new GeneCooldown(gene, ((Number)object2).intValue(), false, 4, null);
        Object object3 = ModGenes.INSTANCE.getDRAGON_BREATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Gene gene2 = (Gene)object3;
        Object object4 = ServerConfig.Companion.getDragonsBreathCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        recentDragonsBreath = new GeneCooldown(gene2, ((Number)object4).intValue(), false, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

