/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttributes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/AttributeGenes;", "", "<init>", "()V", "handleEfficiency", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$BreakSpeed;", "handleWallClimbing", "player", "Lnet/minecraft/world/entity/player/Player;", "returnModifiersOnDeath", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "respawnWithMaxHealth", "geneticsresequenced-1.21"})
public final class AttributeGenes {
    @NotNull
    public static final AttributeGenes INSTANCE = new AttributeGenes();

    private AttributeGenes() {
    }

    public final void handleEfficiency(@NotNull PlayerEvent.BreakSpeed event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Gene)ModGenes.INSTANCE.getEFFICIENCY().get()).isActive()) {
            return;
        }
        AttributeInstance attributeInstance = event.getEntity().getAttributes().getInstance((Holder)ModAttributes.INSTANCE.getEFFICIENCY());
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance efficiencyAttribute = attributeInstance;
        if (efficiencyAttribute.getValue() <= 0.0) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() + (float)(1.0 + efficiencyAttribute.getValue() * efficiencyAttribute.getValue()));
    }

    public final void handleWallClimbing(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Gene)ModGenes.INSTANCE.getWALL_CLIMBING().get()).isActive()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)player;
        Object object = ModGenes.INSTANCE.getWALL_CLIMBING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!GenesData.Companion.hasGene(livingEntity, (Gene)object)) {
            return;
        }
        if (player.horizontalCollision || player.minorHorizontalCollision) {
            double d = player.getDeltaMovement().x;
            Double d2 = player.isCrouching() ? Double.valueOf(0.0) : (Double)ServerConfig.Companion.getWallClimbSpeed().get();
            Intrinsics.checkNotNull((Object)d2);
            player.setDeltaMovement(d, ((Number)d2).doubleValue(), player.getDeltaMovement().z);
            player.fallDistance = 0.0f;
        }
    }

    public final void returnModifiersOnDeath(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        for (Gene gene : GenesData.Companion.getGenes((LivingEntity)player)) {
            gene.setAttributeModifiers((LivingEntity)player, true);
        }
    }

    public final void respawnWithMaxHealth(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        player.setHealth(player.getMaxHealth());
    }
}

