/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.entity;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.advancement.AdvancementTriggers;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.event.CustomEvents;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import dev.aaronhowser.mods.geneticsresequenced.packet.ModPacketHandler;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.GeneChangedPacket;
import dev.aaronhowser.mods.geneticsresequenced.util.ModScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents;", "", "<init>", "()V", "onGeneChanged", "", "event", "Ldev/aaronhowser/mods/geneticsresequenced/event/CustomEvents$GeneChangeEvent$Post;", "checkForMissingRequirements", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "tellAllPlayersGeneChanged", "changedGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "wasAdded", "", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nGeneEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n774#2:105\n865#2:106\n1734#2,3:107\n866#2:110\n1863#2,2:111\n*S KotlinDebug\n*F\n+ 1 GeneEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents\n*L\n53#1:105\n53#1:106\n54#1:107,3\n53#1:110\n57#1:111,2\n*E\n"})
public final class GeneEvents {
    @NotNull
    public static final GeneEvents INSTANCE = new GeneEvents();

    private GeneEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onGeneChanged(@NotNull CustomEvents.GeneChangeEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        LivingEntity livingEntity = event.component1();
        Gene gene = event.component2();
        boolean wasAdded = event.component3();
        this.tellAllPlayersGeneChanged(livingEntity, gene, wasAdded);
        gene.setAttributeModifiers(livingEntity, wasAdded);
        if (!wasAdded && gene.getPotion() != null) {
            TickGenes.INSTANCE.handlePotionGeneRemoved(livingEntity, gene);
        }
        if (livingEntity instanceof ServerPlayer) {
            AdvancementTriggers.INSTANCE.geneAdvancements((ServerPlayer)livingEntity, gene, wasAdded);
        }
        ModScheduler.INSTANCE.scheduleTaskInTicks(1, () -> GeneEvents.onGeneChanged$lambda$0(livingEntity));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForMissingRequirements(LivingEntity entity) {
        void $this$filterTo$iv$iv;
        Set<Gene> genes = GenesData.Companion.getGenes(entity);
        Iterable $this$filter$iv = genes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                Gene gene = (Gene)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = gene.getRequiredGenes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Gene it = (Gene)element$iv;
                        boolean bl3 = false;
                        if (genes.contains(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!(!bl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List genesWithMissingRequirements = (List)destination$iv$iv;
        Iterable $this$forEach$iv = genesWithMissingRequirements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Gene gene = (Gene)element$iv;
            boolean bl = false;
            GenesData.Companion.removeGene(entity, gene);
            MutableComponent requiredGenesComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_missing_requirements.list", new Object[0]);
            for (Gene requiredGene : gene.getRequiredGenes()) {
                boolean hasGene = genes.contains(requiredGene);
                if (hasGene) continue;
                requiredGenesComponent.append((Component)Component.literal((String)"\n - ").append((Component)requiredGene.getNameComponent()));
            }
            if (entity.level().isClientSide) continue;
            Object[] objectArray = new Object[]{gene.getNameComponent()};
            entity.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_missing_requirements", objectArray).withStyle(arg_0 -> GeneEvents.checkForMissingRequirements$lambda$4$lambda$3(requiredGenesComponent, arg_0)));
        }
    }

    private final void tellAllPlayersGeneChanged(LivingEntity entity, Gene changedGene, boolean wasAdded) {
        if (entity.level().isClientSide) {
            return;
        }
        MinecraftServer server = entity.getServer();
        if (server == null) {
            GeneticsResequenced.Companion.getLOGGER().error("Server is null when trying to tell all players about gene change");
            return;
        }
        ModPacketHandler.INSTANCE.messageAllPlayers(new GeneChangedPacket(entity.getId(), changedGene.getId(), wasAdded));
    }

    private static final void onGeneChanged$lambda$0(LivingEntity $livingEntity) {
        Intrinsics.checkNotNullParameter((Object)$livingEntity, (String)"$livingEntity");
        INSTANCE.checkForMissingRequirements($livingEntity);
    }

    private static final Style checkForMissingRequirements$lambda$4$lambda$3(MutableComponent $requiredGenesComponent, Style it) {
        Intrinsics.checkNotNullParameter((Object)$requiredGenesComponent, (String)"$requiredGenesComponent");
        return it.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)$requiredGenesComponent));
    }
}

