/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.data.MobGeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J,\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/MobGeneRegistry;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "<init>", "()V", "assignGenes", "", "entityRl", "Lnet/minecraft/resources/ResourceLocation;", "genes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "", "apply", "pObject", "", "Lcom/google/gson/JsonElement;", "pResourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "pProfiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "Companion", "EntityGenes", "geneticsresequenced-1.21"})
public final class MobGeneRegistry
extends SimpleJsonResourceReloadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<EntityType<?>, Map<Gene, Integer>> entityGeneMap = new LinkedHashMap();

    public MobGeneRegistry() {
        super(new GsonBuilder().setPrettyPrinting().create(), "geneticsresequenced/entity_genes");
    }

    private final void assignGenes(ResourceLocation entityRl, Map<Gene, Integer> genes) {
        EntityType<?> entityType = OtherUtil.INSTANCE.getEntityType(entityRl);
        Map map = entityGeneMap.get(entityType);
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map currentGenes = map;
        currentGenes.putAll(genes);
        entityGeneMap.put(entityType, currentGenes);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        Intrinsics.checkNotNullParameter(pObject, (String)"pObject");
        Intrinsics.checkNotNullParameter((Object)pResourceManager, (String)"pResourceManager");
        Intrinsics.checkNotNullParameter((Object)pProfiler, (String)"pProfiler");
        entityGeneMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                Object object = ((Pair)EntityGenes.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(arg_0 -> MobGeneRegistry.apply$lambda$0(key, arg_0))).getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
                EntityGenes entityGenes = (EntityGenes)object;
                String string = entityGenes.getEntity().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String[] stringArray = new String[]{":"};
                String entityName = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                String string2 = key.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String[] stringArray2 = new String[]{":"};
                String fileName = (String)StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
                if (!Intrinsics.areEqual((Object)entityName, (Object)fileName)) {
                    GeneticsResequenced.Companion.getLOGGER().warn("Mob-Gene data for " + key + " has the entity " + entityName + " instead of " + fileName + ". This may be a mistake.");
                }
                this.assignGenes(entityGenes.getEntity(), entityGenes.getGenes());
                GeneticsResequenced.Companion.getLOGGER().debug("Loaded gene-mob data: " + entityGenes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final IllegalArgumentException apply$lambda$0(ResourceLocation $key, String it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return new IllegalArgumentException("Failed to decode entity genes for " + $key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0007J\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\r\u001a\u00020\u000eR*\u0010\u0004\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/MobGeneRegistry$Companion;", "", "<init>", "()V", "entityGeneMap", "", "Lnet/minecraft/world/entity/EntityType;", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "", "getRegistry", "getGeneWeights", "entityType", "entityRl", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<EntityType<?>, Map<Gene, Integer>> getRegistry() {
            return MapsKt.toMap((Map)entityGeneMap);
        }

        @NotNull
        public final Map<Gene, Integer> getGeneWeights(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            Map map = (Map)entityGeneMap.get(entityType);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        @NotNull
        public final Map<Gene, Integer> getGeneWeights(@NotNull ResourceLocation entityRl) {
            Intrinsics.checkNotNullParameter((Object)entityRl, (String)"entityRl");
            EntityType<?> entityType = OtherUtil.INSTANCE.getEntityType(entityRl);
            return this.getGeneWeights(entityType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/MobGeneRegistry$EntityGenes;", "", "entity", "Lnet/minecraft/resources/ResourceLocation;", "genes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Map;)V", "getEntity", "()Lnet/minecraft/resources/ResourceLocation;", "getGenes", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "geneticsresequenced-1.21"})
    public static final class EntityGenes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation entity;
        @NotNull
        private final Map<Gene, Integer> genes;
        @NotNull
        private static final Codec<EntityGenes> CODEC;

        public EntityGenes(@NotNull ResourceLocation entity, @NotNull Map<Gene, Integer> genes) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(genes, (String)"genes");
            this.entity = entity;
            this.genes = genes;
        }

        @NotNull
        public final ResourceLocation getEntity() {
            return this.entity;
        }

        @NotNull
        public final Map<Gene, Integer> getGenes() {
            return this.genes;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.entity;
        }

        @NotNull
        public final Map<Gene, Integer> component2() {
            return this.genes;
        }

        @NotNull
        public final EntityGenes copy(@NotNull ResourceLocation entity, @NotNull Map<Gene, Integer> genes) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(genes, (String)"genes");
            return new EntityGenes(entity, genes);
        }

        public static /* synthetic */ EntityGenes copy$default(EntityGenes entityGenes, ResourceLocation resourceLocation, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = entityGenes.entity;
            }
            if ((n & 2) != 0) {
                map = entityGenes.genes;
            }
            return entityGenes.copy(resourceLocation, map);
        }

        @NotNull
        public String toString() {
            return "EntityGenes(entity=" + this.entity + ", genes=" + this.genes + ")";
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + ((Object)this.genes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityGenes)) {
                return false;
            }
            EntityGenes entityGenes = (EntityGenes)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)entityGenes.entity)) {
                return false;
            }
            return Intrinsics.areEqual(this.genes, entityGenes.genes);
        }

        private static final ResourceLocation CODEC$lambda$2$lambda$0(KProperty1 $tmp0, EntityGenes p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Map CODEC$lambda$2$lambda$1(KProperty1 $tmp0, EntityGenes p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Map)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(arg_0 -> EntityGenes.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.unboundedMap(Gene.Companion.getCODEC(), (Codec)((Codec)Codec.INT)).fieldOf("genes").forGetter(arg_0 -> EntityGenes.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, EntityGenes::new);
        }

        static {
            Codec codec = RecordCodecBuilder.create(EntityGenes::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/MobGeneRegistry$EntityGenes$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/data/MobGeneRegistry$EntityGenes;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "geneticsresequenced-1.21"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<EntityGenes> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

