/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.data.GeneRequirementRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "<init>", "()V", "apply", "", "pObject", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "pResourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "pProfiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "GeneRequirement", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nGeneRequirementRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneRequirementRegistry.kt\ndev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,67:1\n1863#2,2:68\n216#3,2:70\n*S KotlinDebug\n*F\n+ 1 GeneRequirementRegistry.kt\ndev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry\n*L\n40#1:68,2\n62#1:70,2\n*E\n"})
public final class GeneRequirementRegistry
extends SimpleJsonResourceReloadListener {
    public GeneRequirementRegistry() {
        super(new GsonBuilder().setPrettyPrinting().create(), "geneticsresequenced/gene_requirements");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        Intrinsics.checkNotNullParameter(pObject, (String)"pObject");
        Intrinsics.checkNotNullParameter((Object)pResourceManager, (String)"pResourceManager");
        Intrinsics.checkNotNullParameter((Object)pProfiler, (String)"pProfiler");
        Iterable $this$forEach$iv = (Iterable)GeneRegistry.INSTANCE.getGENE_REGISTRY();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Gene it = (Gene)element$iv;
            boolean bl = false;
            it.removeRequiredGenes((Collection<Gene>)it.getRequiredGenes());
        }
        Map requirements = new LinkedHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                Object object = ((Pair)GeneRequirement.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(arg_0 -> GeneRequirementRegistry.apply$lambda$1(key, arg_0))).getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
                GeneRequirement geneRequirement = (GeneRequirement)object;
                Gene gene = geneRequirement.component1();
                List<Gene> requiresGenes = geneRequirement.component2();
                requirements.put(gene, CollectionsKt.plus((Collection)requirements.getOrDefault(gene, CollectionsKt.emptyList()), (Iterable)requiresGenes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map $this$forEach$iv2 = requirements;
        boolean bl = false;
        Iterator iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            Gene gene = (Gene)entry.getKey();
            List requiresGenes = (List)entry.getValue();
            GeneticsResequenced.Companion.getLOGGER().debug("Adding required genes for " + gene + ": " + CollectionsKt.joinToString$default((Iterable)requiresGenes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            gene.addRequiredGenes(requiresGenes);
        }
    }

    private static final IllegalArgumentException apply$lambda$1(ResourceLocation $key, String it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return new IllegalArgumentException("Failed to decode entity genes for " + $key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry$GeneRequirement;", "", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "requiresGenes", "", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;Ljava/util/List;)V", "getGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getRequiresGenes", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21"})
    public static final class GeneRequirement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Gene gene;
        @NotNull
        private final List<Gene> requiresGenes;
        @NotNull
        private static final Codec<GeneRequirement> CODEC;

        public GeneRequirement(@NotNull Gene gene, @NotNull List<Gene> requiresGenes) {
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            Intrinsics.checkNotNullParameter(requiresGenes, (String)"requiresGenes");
            this.gene = gene;
            this.requiresGenes = requiresGenes;
        }

        @NotNull
        public final Gene getGene() {
            return this.gene;
        }

        @NotNull
        public final List<Gene> getRequiresGenes() {
            return this.requiresGenes;
        }

        @NotNull
        public final Gene component1() {
            return this.gene;
        }

        @NotNull
        public final List<Gene> component2() {
            return this.requiresGenes;
        }

        @NotNull
        public final GeneRequirement copy(@NotNull Gene gene, @NotNull List<Gene> requiresGenes) {
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            Intrinsics.checkNotNullParameter(requiresGenes, (String)"requiresGenes");
            return new GeneRequirement(gene, requiresGenes);
        }

        public static /* synthetic */ GeneRequirement copy$default(GeneRequirement geneRequirement, Gene gene, List list, int n, Object object) {
            if ((n & 1) != 0) {
                gene = geneRequirement.gene;
            }
            if ((n & 2) != 0) {
                list = geneRequirement.requiresGenes;
            }
            return geneRequirement.copy(gene, list);
        }

        @NotNull
        public String toString() {
            return "GeneRequirement(gene=" + this.gene + ", requiresGenes=" + this.requiresGenes + ")";
        }

        public int hashCode() {
            int result = this.gene.hashCode();
            result = result * 31 + ((Object)this.requiresGenes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneRequirement)) {
                return false;
            }
            GeneRequirement geneRequirement = (GeneRequirement)other;
            if (!Intrinsics.areEqual((Object)this.gene, (Object)geneRequirement.gene)) {
                return false;
            }
            return Intrinsics.areEqual(this.requiresGenes, geneRequirement.requiresGenes);
        }

        private static final Gene CODEC$lambda$2$lambda$0(KProperty1 $tmp0, GeneRequirement p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Gene)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final List CODEC$lambda$2$lambda$1(KProperty1 $tmp0, GeneRequirement p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (List)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Gene.Companion.getCODEC().fieldOf("gene").forGetter(arg_0 -> GeneRequirement.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.list(Gene.Companion.getCODEC()).fieldOf("requiresGenes").forGetter(arg_0 -> GeneRequirement.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, GeneRequirement::new);
        }

        static {
            Codec codec = RecordCodecBuilder.create(GeneRequirement::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry$GeneRequirement$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirementRegistry$GeneRequirement;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "geneticsresequenced-1.21"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<GeneRequirement> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

