/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/config/ServerConfig;", "", "builder", "Lnet/neoforged/neoforge/common/ModConfigSpec$Builder;", "<init>", "(Lnet/neoforged/neoforge/common/ModConfigSpec$Builder;)V", "generalConfigs", "", "machineConfigs", "geneConfigs", "Companion", "geneticsresequenced-1.21"})
public final class ServerConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModConfigSpec.Builder builder;
    @NotNull
    private static final Pair<ServerConfig, ModConfigSpec> configPair;
    @NotNull
    private static final ServerConfig CONFIG;
    @NotNull
    private static final ModConfigSpec CONFIG_SPEC;
    public static ModConfigSpec.BooleanValue keepGenesOnDeath;
    public static ModConfigSpec.IntValue minimumCooldownForNotification;
    public static ModConfigSpec.IntValue antifieldBlockRadius;
    public static ModConfigSpec.IntValue coalGeneratorEnergyCapacity;
    public static ModConfigSpec.IntValue coalGeneratorEnergyTransferRate;
    public static ModConfigSpec.IntValue coalGeneratorEnergyPerTick;
    public static ModConfigSpec.IntValue incubatorTicksPerBrew;
    public static ModConfigSpec.IntValue incubatorLowTempTickFactor;
    public static ModConfigSpec.ConfigValue<List<String>> disabledGenes;
    public static ModConfigSpec.BooleanValue disableGivingPlayersNegativeGenes;
    public static ModConfigSpec.IntValue bioluminescenceCooldown;
    public static ModConfigSpec.IntValue bioluminescenceDuration;
    public static ModConfigSpec.DoubleValue clawsChance;
    public static ModConfigSpec.DoubleValue clawsDamage;
    public static ModConfigSpec.DoubleValue chillChance;
    public static ModConfigSpec.IntValue chillDuration;
    public static ModConfigSpec.IntValue eggCooldown;
    public static ModConfigSpec.IntValue emeraldHeartCooldown;
    public static ModConfigSpec.DoubleValue emeraldHeartChatChance;
    public static ModConfigSpec.IntValue dragonsBreathCooldown;
    public static ModConfigSpec.IntValue itemMagnetCooldown;
    public static ModConfigSpec.DoubleValue itemMagnetRadius;
    public static ModConfigSpec.DoubleValue johnnyAttackMultiplier;
    public static ModConfigSpec.IntValue meatyCooldown;
    public static ModConfigSpec.IntValue meaty2Cooldown;
    public static ModConfigSpec.IntValue milkyCooldown;
    public static ModConfigSpec.IntValue mobSightCooldown;
    public static ModConfigSpec.DoubleValue mobSightRadius;
    public static ModConfigSpec.IntValue noHungerCooldown;
    public static ModConfigSpec.IntValue noHungerMinimum;
    public static ModConfigSpec.IntValue passivesCheckCooldown;
    public static ModConfigSpec.IntValue photosynthesisCooldown;
    public static ModConfigSpec.IntValue photoSynthesisHungerAmount;
    public static ModConfigSpec.DoubleValue photoSynthesisSaturationAmount;
    public static ModConfigSpec.IntValue slimyDeathCooldown;
    public static ModConfigSpec.DoubleValue slimyDeathHealthMultiplier;
    public static ModConfigSpec.IntValue slimyDeathDespawnCheckTimer;
    public static ModConfigSpec.IntValue slimyDeathDespawnTime;
    public static ModConfigSpec.IntValue teleportCooldown;
    public static ModConfigSpec.DoubleValue teleportDistance;
    public static ModConfigSpec.DoubleValue thornsChance;
    public static ModConfigSpec.DoubleValue thornsDamage;
    public static ModConfigSpec.DoubleValue thornsHungerDrain;
    public static ModConfigSpec.DoubleValue wallClimbSpeed;
    public static ModConfigSpec.IntValue woolyCooldown;
    public static ModConfigSpec.IntValue xpMagnetCooldown;
    public static ModConfigSpec.DoubleValue xpMagnetRadius;

    public ServerConfig(@NotNull ModConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.generalConfigs();
        this.machineConfigs();
        this.geneConfigs();
        this.builder.build();
    }

    private final void generalConfigs() {
        this.builder.push("general");
        Companion.setKeepGenesOnDeath(this.builder.comment("Keep genes on death").define("keepGenesOnDeath", true));
        Companion.setMinimumCooldownForNotification(this.builder.comment("When a cooldown ends, it notifies the player, unless the cooldown is shorter than this value (in ticks)").defineInRange("minimumCooldownForNotification", 1200, 1, Integer.MAX_VALUE));
        Companion.setAntifieldBlockRadius(this.builder.comment("How far should the Antifield Block prevent Item/XP Magnet Genes from working (in blocks)").defineInRange("antifieldBlockRadius", 25, 1, Integer.MAX_VALUE));
        this.builder.pop();
    }

    private final void machineConfigs() {
        this.builder.push("machines");
        Companion.setCoalGeneratorEnergyCapacity(this.builder.comment("How much energy should the Coal Generator be able to store").defineInRange("coalGeneratorEnergyCapacity", 100000, 1, Integer.MAX_VALUE));
        Companion.setCoalGeneratorEnergyTransferRate(this.builder.comment("How much energy should the Coal Generator be able to transfer per tick").defineInRange("coalGeneratorEnergyTransferRate", 256, 1, Integer.MAX_VALUE));
        Companion.setCoalGeneratorEnergyPerTick(this.builder.comment("How much energy should the Coal Generator generate per tick (1 item takes 200 ticks to burn in a Furnace)").defineInRange("coalGeneratorEnergyPerTick", 6, 1, Integer.MAX_VALUE));
        Companion.setIncubatorTicksPerBrew(this.builder.comment("How many ticks should the Incubator take to brew a potion? A vanilla brewing stand takes 400 ticks").defineInRange("incubatorTicksPerBrew", 200, 1, Integer.MAX_VALUE));
        Companion.setIncubatorLowTempTickFactor(this.builder.comment("How many times slower should the Advanced Incubator be when it's at low temperature? Default is 120, which makes it take a full Minecraft day (excluding Overclockers)").defineInRange("incubatorLowTempTickFactor", 120, 1, Integer.MAX_VALUE));
        this.builder.pop();
    }

    private final void geneConfigs() {
        this.builder.push("genes");
        Companion.setDisabledGenes((ModConfigSpec.ConfigValue<List<String>>)this.builder.comment("List of genes to disable.\nExample: [\"geneticsresequenced:wooly\",\"geneticsresequenced:lay_egg\"]").defineList("disabledGenes", CollectionsKt.emptyList(), ServerConfig::geneConfigs$lambda$0));
        Companion.setDisableGivingPlayersNegativeGenes(this.builder.comment("Set true to prevent players from being given negative genes").define("disableGivingPlayersNegativeGenes", false));
        Companion.setBioluminescenceDuration(this.builder.comment("How long should light sources from the Bioluminescence gene last (in ticks)").defineInRange("bioluminescenceDuration", 600, 1, Integer.MAX_VALUE));
        Companion.setBioluminescenceCooldown(this.builder.comment("How often entities with the Bioluminescence gene should emit light (in ticks)").defineInRange("bioluminescenceCooldown", 10, 1, Integer.MAX_VALUE));
        Companion.setEggCooldown(this.builder.comment("How many ticks to wait before someone with the Lay Egg gene lays an egg again").defineInRange("eggCooldown", 6000, 1, Integer.MAX_VALUE));
        Companion.setClawsChance(this.builder.comment("What probability should the Claws gene have (doubled if the player has Claws 2 gene)").defineInRange("clawsBaseChance", 0.33, 0.0, 1.0));
        Companion.setClawsDamage(this.builder.comment("How much damage to deal when the Claws gene procs").defineInRange("clawsDamage", 8.0, 0.0, Double.MAX_VALUE));
        Companion.setChillChance(this.builder.comment("What probability should the Chill gene have").defineInRange("chillChance", 0.75, 0.0, 1.0));
        Companion.setChillDuration(this.builder.comment("How long should the Chill gene slow entities down for (in ticks)").defineInRange("chillDuration", 300, 1, Integer.MAX_VALUE));
        Companion.setEmeraldHeartCooldown(this.builder.comment("How many ticks to wait before the Emerald Heart gene can proc again").defineInRange("emeraldHeartCooldown", 1200, 1, Integer.MAX_VALUE));
        Companion.setEmeraldHeartChatChance(this.builder.comment("What probability should there be of making a Villager sound when you send a chat message with Emerald Heart?").defineInRange("emeraldHeartChatChance", 0.4, 0.0, 1.0));
        Companion.setDragonsBreathCooldown(this.builder.comment("How many ticks to wait before someone with the Dragon's Breath gene can breathe fire again").defineInRange("dragonsBreathCooldown", 100, 1, Integer.MAX_VALUE));
        Companion.setItemMagnetCooldown(this.builder.comment("How often should the Item Magnet gene attract items (in ticks)").defineInRange("itemMagnetCooldown", 10, 1, Integer.MAX_VALUE));
        Companion.setItemMagnetRadius(this.builder.comment("How far should the Item Magnet gene attract items (in blocks)").defineInRange("itemMagnetRadius", 8.0, 1.0, Double.MAX_VALUE));
        Companion.setJohnnyAttackMultiplier(this.builder.comment("How much should the Johnny gene multiply damage by, when using an Axe?").defineInRange("johnnyAttackMultiplier", 1.25, 0.0, Double.MAX_VALUE));
        Companion.setMeatyCooldown(this.builder.comment("How many ticks to wait before someone with the Meaty gene can be sheared again").defineInRange("meatyCooldown", 1200, 1, Integer.MAX_VALUE));
        Companion.setMeaty2Cooldown(this.builder.comment("How many ticks to wait before someone with the Meaty 2 gene drops meat again").defineInRange("meaty2Cooldown", 6000, 1, Integer.MAX_VALUE));
        Companion.setMilkyCooldown(this.builder.comment("How many ticks to wait before someone with the Milky gene can be milked again").defineInRange("milkyCooldown", 1, 1, Integer.MAX_VALUE));
        Companion.setMobSightRadius(this.builder.comment("How far from the player should Mob Sight detect entities (in blocks)").defineInRange("mobSightRadius", 32.0, 1.0, Double.MAX_VALUE));
        Companion.setMobSightCooldown(this.builder.comment("How often should the Mob Sight gene check for entities (in ticks)").defineInRange("mobSightCooldown", 20, 1, Integer.MAX_VALUE));
        Companion.setNoHungerCooldown(this.builder.comment("How often should the No Hunger gene check to reset hunger (in ticks)").defineInRange("noHungerCooldown", 80, 1, Integer.MAX_VALUE));
        Companion.setNoHungerMinimum(this.builder.comment("What's the minimum hunger level to reset to").defineInRange("noHungerMinimum", 10, 1, 20));
        Companion.setPassivesCheckCooldown(this.builder.comment("How often should passive genes (potions, Flame, Lay Egg, Meaty 2) be checked for effects (in ticks)").defineInRange("passivesCheckCooldown", 40, 1, Integer.MAX_VALUE));
        Companion.setPhotosynthesisCooldown(this.builder.comment("How often entities with the Photosynthesis gene should regain hunger (in ticks)").defineInRange("photosynthesisCooldown", 600, 1, Integer.MAX_VALUE));
        Companion.setPhotoSynthesisHungerAmount(this.builder.comment("How much hunger to regain when the Photosynthesis gene procs").defineInRange("photoSynthesisHungerAmount", 1, 0, Integer.MAX_VALUE));
        Companion.setPhotoSynthesisSaturationAmount(this.builder.comment("How much saturation to regain when the Photosynthesis gene procs").defineInRange("photoSynthesisSaturationAmount", 0.5, 0.0, Double.MAX_VALUE));
        Companion.setSlimyDeathCooldown(this.builder.comment("How many ticks to wait before someone with the Slimy Death gene can spawn slimes again").defineInRange("slimyDeathCooldown", 12000, 1, Integer.MAX_VALUE));
        Companion.setSlimyDeathHealthMultiplier(this.builder.comment("How much health should entities who survive via Slimy Death regain upon death, as a percentage of their max health").defineInRange("slimyDeathHealthMultiplier", 0.5, 0.0, 1.0));
        Companion.setSlimyDeathDespawnCheckTimer(this.builder.comment("How often should Support Slimes check if they should despawn? They despawn if there's nothing to attack, or if they aren't near their owner.").defineInRange("slimyDeathDespawnCheckTimer", 20, 1, Integer.MAX_VALUE));
        Companion.setSlimyDeathDespawnTime(this.builder.comment("How long should Support Slimes have to remain in valid despawning conditions before they actually despawn?").defineInRange("slimyDeathDespawnTime", 200, 1, Integer.MAX_VALUE));
        Companion.setTeleportCooldown(this.builder.comment("How many ticks to wait before someone with the Teleport gene can teleport again").defineInRange("teleportCooldown", 20, 1, Integer.MAX_VALUE));
        Companion.setTeleportDistance(this.builder.comment("How far should the Teleport gene teleport the player, at maximum").defineInRange("teleportDistance", 10.0, 1.0, Double.MAX_VALUE));
        Companion.setThornsChance(this.builder.comment("What probability should the Thorns gene have").defineInRange("thornsChance", 0.15, 0.0, 1.0));
        Companion.setThornsDamage(this.builder.comment("How much damage to deal back to the attacker when they hit a target with the Thorns gene").defineInRange("thornsDamage", 1.5, 0.0, Double.MAX_VALUE));
        Companion.setThornsHungerDrain(this.builder.comment("How much hunger to drain when the Thorns gene deals damage").defineInRange("thornsHungerDrain", 1.0, 0.0, Double.MAX_VALUE));
        Companion.setWallClimbSpeed(this.builder.comment("How fast should the player climb walls with the Wall Climbing gene").defineInRange("wallClimbSpeed", 0.144, 0.0, Double.MAX_VALUE));
        Companion.setWoolyCooldown(this.builder.comment("How many ticks to wait before someone with the Wooly gene can be sheared again (skipped if they eat grass)").defineInRange("woolyCooldown", 1200, 1, Integer.MAX_VALUE));
        Companion.setXpMagnetCooldown(this.builder.comment("How often should the XP Magnet gene attract XP orbs (in ticks)").defineInRange("xpMagnetCooldown", 10, 1, Integer.MAX_VALUE));
        Companion.setXpMagnetRadius(this.builder.comment("How far should the XP Magnet gene attract XP orbs (in blocks)").defineInRange("xpMagnetRadius", 8.0, 1.0, Double.MAX_VALUE));
        this.builder.pop();
    }

    private static final boolean geneConfigs$lambda$0(Object it) {
        return it instanceof String;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"configure(...)");
        configPair = pair;
        Object object = configPair.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
        CONFIG = (ServerConfig)object;
        Object object2 = configPair.getRight();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getRight(...)");
        CONFIG_SPEC = (ModConfigSpec)object2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\bk\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001a\u0010#\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u001a\u0010&\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\u0019R\u001a\u0010)\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R&\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0011\"\u0004\b6\u0010\u0013R\u001a\u00107\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0017\"\u0004\b9\u0010\u0019R\u001a\u0010:\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0017\"\u0004\b<\u0010\u0019R\u001a\u0010=\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR\u001a\u0010F\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010@\"\u0004\bH\u0010BR\u001a\u0010I\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0017\"\u0004\bK\u0010\u0019R\u001a\u0010L\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0017\"\u0004\bN\u0010\u0019R\u001a\u0010O\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0017\"\u0004\bQ\u0010\u0019R\u001a\u0010R\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010@\"\u0004\bT\u0010BR\u001a\u0010U\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0017\"\u0004\bW\u0010\u0019R\u001a\u0010X\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0017\"\u0004\bZ\u0010\u0019R\u001a\u0010[\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010@\"\u0004\b]\u0010BR\u001a\u0010^\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010@\"\u0004\b`\u0010BR\u001a\u0010a\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u0017\"\u0004\bc\u0010\u0019R\u001a\u0010d\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u0017\"\u0004\bf\u0010\u0019R\u001a\u0010g\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010\u0017\"\u0004\bi\u0010\u0019R\u001a\u0010j\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\u0017\"\u0004\bl\u0010\u0019R\u001a\u0010m\u001a\u00020>X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010@\"\u0004\bo\u0010BR\u001a\u0010p\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010\u0017\"\u0004\br\u0010\u0019R\u001a\u0010s\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010\u0017\"\u0004\bu\u0010\u0019R\u001a\u0010v\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010\u0017\"\u0004\bx\u0010\u0019R\u001a\u0010y\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u0017\"\u0004\b{\u0010\u0019R\u001a\u0010|\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010\u0017\"\u0004\b~\u0010\u0019R\u001c\u0010\u007f\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010@\"\u0005\b\u0081\u0001\u0010BR\u001d\u0010\u0082\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0017\"\u0005\b\u0084\u0001\u0010\u0019R\u001d\u0010\u0085\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0086\u0001\u0010@\"\u0005\b\u0087\u0001\u0010BR\u001d\u0010\u0088\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0089\u0001\u0010\u0017\"\u0005\b\u008a\u0001\u0010\u0019R\u001d\u0010\u008b\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008c\u0001\u0010\u0017\"\u0005\b\u008d\u0001\u0010\u0019R\u001d\u0010\u008e\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008f\u0001\u0010\u0017\"\u0005\b\u0090\u0001\u0010\u0019R\u001d\u0010\u0091\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0092\u0001\u0010@\"\u0005\b\u0093\u0001\u0010BR\u001d\u0010\u0094\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0095\u0001\u0010@\"\u0005\b\u0096\u0001\u0010BR\u001d\u0010\u0097\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0098\u0001\u0010@\"\u0005\b\u0099\u0001\u0010BR\u001d\u0010\u009a\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009b\u0001\u0010@\"\u0005\b\u009c\u0001\u0010BR\u001d\u0010\u009d\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009e\u0001\u0010@\"\u0005\b\u009f\u0001\u0010BR\u001d\u0010\u00a0\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a1\u0001\u0010\u0017\"\u0005\b\u00a2\u0001\u0010\u0019R\u001d\u0010\u00a3\u0001\u001a\u00020\u0015X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a4\u0001\u0010\u0017\"\u0005\b\u00a5\u0001\u0010\u0019R\u001d\u0010\u00a6\u0001\u001a\u00020>X\u0086.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a7\u0001\u0010@\"\u0005\b\u00a8\u0001\u0010B\u00a8\u0006\u00a9\u0001"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/config/ServerConfig$Companion;", "", "<init>", "()V", "configPair", "Lorg/apache/commons/lang3/tuple/Pair;", "Ldev/aaronhowser/mods/geneticsresequenced/config/ServerConfig;", "Lnet/neoforged/neoforge/common/ModConfigSpec;", "CONFIG", "getCONFIG", "()Ldev/aaronhowser/mods/geneticsresequenced/config/ServerConfig;", "CONFIG_SPEC", "getCONFIG_SPEC", "()Lnet/neoforged/neoforge/common/ModConfigSpec;", "keepGenesOnDeath", "Lnet/neoforged/neoforge/common/ModConfigSpec$BooleanValue;", "getKeepGenesOnDeath", "()Lnet/neoforged/neoforge/common/ModConfigSpec$BooleanValue;", "setKeepGenesOnDeath", "(Lnet/neoforged/neoforge/common/ModConfigSpec$BooleanValue;)V", "minimumCooldownForNotification", "Lnet/neoforged/neoforge/common/ModConfigSpec$IntValue;", "getMinimumCooldownForNotification", "()Lnet/neoforged/neoforge/common/ModConfigSpec$IntValue;", "setMinimumCooldownForNotification", "(Lnet/neoforged/neoforge/common/ModConfigSpec$IntValue;)V", "antifieldBlockRadius", "getAntifieldBlockRadius", "setAntifieldBlockRadius", "coalGeneratorEnergyCapacity", "getCoalGeneratorEnergyCapacity", "setCoalGeneratorEnergyCapacity", "coalGeneratorEnergyTransferRate", "getCoalGeneratorEnergyTransferRate", "setCoalGeneratorEnergyTransferRate", "coalGeneratorEnergyPerTick", "getCoalGeneratorEnergyPerTick", "setCoalGeneratorEnergyPerTick", "incubatorTicksPerBrew", "getIncubatorTicksPerBrew", "setIncubatorTicksPerBrew", "incubatorLowTempTickFactor", "getIncubatorLowTempTickFactor", "setIncubatorLowTempTickFactor", "disabledGenes", "Lnet/neoforged/neoforge/common/ModConfigSpec$ConfigValue;", "", "", "getDisabledGenes", "()Lnet/neoforged/neoforge/common/ModConfigSpec$ConfigValue;", "setDisabledGenes", "(Lnet/neoforged/neoforge/common/ModConfigSpec$ConfigValue;)V", "disableGivingPlayersNegativeGenes", "getDisableGivingPlayersNegativeGenes", "setDisableGivingPlayersNegativeGenes", "bioluminescenceCooldown", "getBioluminescenceCooldown", "setBioluminescenceCooldown", "bioluminescenceDuration", "getBioluminescenceDuration", "setBioluminescenceDuration", "clawsChance", "Lnet/neoforged/neoforge/common/ModConfigSpec$DoubleValue;", "getClawsChance", "()Lnet/neoforged/neoforge/common/ModConfigSpec$DoubleValue;", "setClawsChance", "(Lnet/neoforged/neoforge/common/ModConfigSpec$DoubleValue;)V", "clawsDamage", "getClawsDamage", "setClawsDamage", "chillChance", "getChillChance", "setChillChance", "chillDuration", "getChillDuration", "setChillDuration", "eggCooldown", "getEggCooldown", "setEggCooldown", "emeraldHeartCooldown", "getEmeraldHeartCooldown", "setEmeraldHeartCooldown", "emeraldHeartChatChance", "getEmeraldHeartChatChance", "setEmeraldHeartChatChance", "dragonsBreathCooldown", "getDragonsBreathCooldown", "setDragonsBreathCooldown", "itemMagnetCooldown", "getItemMagnetCooldown", "setItemMagnetCooldown", "itemMagnetRadius", "getItemMagnetRadius", "setItemMagnetRadius", "johnnyAttackMultiplier", "getJohnnyAttackMultiplier", "setJohnnyAttackMultiplier", "meatyCooldown", "getMeatyCooldown", "setMeatyCooldown", "meaty2Cooldown", "getMeaty2Cooldown", "setMeaty2Cooldown", "milkyCooldown", "getMilkyCooldown", "setMilkyCooldown", "mobSightCooldown", "getMobSightCooldown", "setMobSightCooldown", "mobSightRadius", "getMobSightRadius", "setMobSightRadius", "noHungerCooldown", "getNoHungerCooldown", "setNoHungerCooldown", "noHungerMinimum", "getNoHungerMinimum", "setNoHungerMinimum", "passivesCheckCooldown", "getPassivesCheckCooldown", "setPassivesCheckCooldown", "photosynthesisCooldown", "getPhotosynthesisCooldown", "setPhotosynthesisCooldown", "photoSynthesisHungerAmount", "getPhotoSynthesisHungerAmount", "setPhotoSynthesisHungerAmount", "photoSynthesisSaturationAmount", "getPhotoSynthesisSaturationAmount", "setPhotoSynthesisSaturationAmount", "slimyDeathCooldown", "getSlimyDeathCooldown", "setSlimyDeathCooldown", "slimyDeathHealthMultiplier", "getSlimyDeathHealthMultiplier", "setSlimyDeathHealthMultiplier", "slimyDeathDespawnCheckTimer", "getSlimyDeathDespawnCheckTimer", "setSlimyDeathDespawnCheckTimer", "slimyDeathDespawnTime", "getSlimyDeathDespawnTime", "setSlimyDeathDespawnTime", "teleportCooldown", "getTeleportCooldown", "setTeleportCooldown", "teleportDistance", "getTeleportDistance", "setTeleportDistance", "thornsChance", "getThornsChance", "setThornsChance", "thornsDamage", "getThornsDamage", "setThornsDamage", "thornsHungerDrain", "getThornsHungerDrain", "setThornsHungerDrain", "wallClimbSpeed", "getWallClimbSpeed", "setWallClimbSpeed", "woolyCooldown", "getWoolyCooldown", "setWoolyCooldown", "xpMagnetCooldown", "getXpMagnetCooldown", "setXpMagnetCooldown", "xpMagnetRadius", "getXpMagnetRadius", "setXpMagnetRadius", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerConfig getCONFIG() {
            return CONFIG;
        }

        @NotNull
        public final ModConfigSpec getCONFIG_SPEC() {
            return CONFIG_SPEC;
        }

        @NotNull
        public final ModConfigSpec.BooleanValue getKeepGenesOnDeath() {
            ModConfigSpec.BooleanValue booleanValue = keepGenesOnDeath;
            if (booleanValue != null) {
                return booleanValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepGenesOnDeath");
            return null;
        }

        public final void setKeepGenesOnDeath(@NotNull ModConfigSpec.BooleanValue booleanValue) {
            Intrinsics.checkNotNullParameter((Object)booleanValue, (String)"<set-?>");
            keepGenesOnDeath = booleanValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getMinimumCooldownForNotification() {
            ModConfigSpec.IntValue intValue = minimumCooldownForNotification;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"minimumCooldownForNotification");
            return null;
        }

        public final void setMinimumCooldownForNotification(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            minimumCooldownForNotification = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getAntifieldBlockRadius() {
            ModConfigSpec.IntValue intValue = antifieldBlockRadius;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"antifieldBlockRadius");
            return null;
        }

        public final void setAntifieldBlockRadius(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            antifieldBlockRadius = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getCoalGeneratorEnergyCapacity() {
            ModConfigSpec.IntValue intValue = coalGeneratorEnergyCapacity;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"coalGeneratorEnergyCapacity");
            return null;
        }

        public final void setCoalGeneratorEnergyCapacity(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            coalGeneratorEnergyCapacity = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getCoalGeneratorEnergyTransferRate() {
            ModConfigSpec.IntValue intValue = coalGeneratorEnergyTransferRate;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"coalGeneratorEnergyTransferRate");
            return null;
        }

        public final void setCoalGeneratorEnergyTransferRate(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            coalGeneratorEnergyTransferRate = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getCoalGeneratorEnergyPerTick() {
            ModConfigSpec.IntValue intValue = coalGeneratorEnergyPerTick;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"coalGeneratorEnergyPerTick");
            return null;
        }

        public final void setCoalGeneratorEnergyPerTick(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            coalGeneratorEnergyPerTick = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getIncubatorTicksPerBrew() {
            ModConfigSpec.IntValue intValue = incubatorTicksPerBrew;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"incubatorTicksPerBrew");
            return null;
        }

        public final void setIncubatorTicksPerBrew(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            incubatorTicksPerBrew = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getIncubatorLowTempTickFactor() {
            ModConfigSpec.IntValue intValue = incubatorLowTempTickFactor;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"incubatorLowTempTickFactor");
            return null;
        }

        public final void setIncubatorLowTempTickFactor(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            incubatorLowTempTickFactor = intValue;
        }

        @NotNull
        public final ModConfigSpec.ConfigValue<List<String>> getDisabledGenes() {
            ModConfigSpec.ConfigValue<List<String>> configValue = disabledGenes;
            if (configValue != null) {
                return configValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"disabledGenes");
            return null;
        }

        public final void setDisabledGenes(@NotNull ModConfigSpec.ConfigValue<List<String>> configValue) {
            Intrinsics.checkNotNullParameter(configValue, (String)"<set-?>");
            disabledGenes = configValue;
        }

        @NotNull
        public final ModConfigSpec.BooleanValue getDisableGivingPlayersNegativeGenes() {
            ModConfigSpec.BooleanValue booleanValue = disableGivingPlayersNegativeGenes;
            if (booleanValue != null) {
                return booleanValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"disableGivingPlayersNegativeGenes");
            return null;
        }

        public final void setDisableGivingPlayersNegativeGenes(@NotNull ModConfigSpec.BooleanValue booleanValue) {
            Intrinsics.checkNotNullParameter((Object)booleanValue, (String)"<set-?>");
            disableGivingPlayersNegativeGenes = booleanValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getBioluminescenceCooldown() {
            ModConfigSpec.IntValue intValue = bioluminescenceCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"bioluminescenceCooldown");
            return null;
        }

        public final void setBioluminescenceCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            bioluminescenceCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getBioluminescenceDuration() {
            ModConfigSpec.IntValue intValue = bioluminescenceDuration;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"bioluminescenceDuration");
            return null;
        }

        public final void setBioluminescenceDuration(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            bioluminescenceDuration = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getClawsChance() {
            ModConfigSpec.DoubleValue doubleValue = clawsChance;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"clawsChance");
            return null;
        }

        public final void setClawsChance(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            clawsChance = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getClawsDamage() {
            ModConfigSpec.DoubleValue doubleValue = clawsDamage;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"clawsDamage");
            return null;
        }

        public final void setClawsDamage(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            clawsDamage = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getChillChance() {
            ModConfigSpec.DoubleValue doubleValue = chillChance;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"chillChance");
            return null;
        }

        public final void setChillChance(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            chillChance = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getChillDuration() {
            ModConfigSpec.IntValue intValue = chillDuration;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"chillDuration");
            return null;
        }

        public final void setChillDuration(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            chillDuration = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getEggCooldown() {
            ModConfigSpec.IntValue intValue = eggCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"eggCooldown");
            return null;
        }

        public final void setEggCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            eggCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getEmeraldHeartCooldown() {
            ModConfigSpec.IntValue intValue = emeraldHeartCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"emeraldHeartCooldown");
            return null;
        }

        public final void setEmeraldHeartCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            emeraldHeartCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getEmeraldHeartChatChance() {
            ModConfigSpec.DoubleValue doubleValue = emeraldHeartChatChance;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"emeraldHeartChatChance");
            return null;
        }

        public final void setEmeraldHeartChatChance(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            emeraldHeartChatChance = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getDragonsBreathCooldown() {
            ModConfigSpec.IntValue intValue = dragonsBreathCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"dragonsBreathCooldown");
            return null;
        }

        public final void setDragonsBreathCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            dragonsBreathCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getItemMagnetCooldown() {
            ModConfigSpec.IntValue intValue = itemMagnetCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemMagnetCooldown");
            return null;
        }

        public final void setItemMagnetCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            itemMagnetCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getItemMagnetRadius() {
            ModConfigSpec.DoubleValue doubleValue = itemMagnetRadius;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemMagnetRadius");
            return null;
        }

        public final void setItemMagnetRadius(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            itemMagnetRadius = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getJohnnyAttackMultiplier() {
            ModConfigSpec.DoubleValue doubleValue = johnnyAttackMultiplier;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"johnnyAttackMultiplier");
            return null;
        }

        public final void setJohnnyAttackMultiplier(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            johnnyAttackMultiplier = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getMeatyCooldown() {
            ModConfigSpec.IntValue intValue = meatyCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"meatyCooldown");
            return null;
        }

        public final void setMeatyCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            meatyCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getMeaty2Cooldown() {
            ModConfigSpec.IntValue intValue = meaty2Cooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"meaty2Cooldown");
            return null;
        }

        public final void setMeaty2Cooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            meaty2Cooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getMilkyCooldown() {
            ModConfigSpec.IntValue intValue = milkyCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"milkyCooldown");
            return null;
        }

        public final void setMilkyCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            milkyCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getMobSightCooldown() {
            ModConfigSpec.IntValue intValue = mobSightCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"mobSightCooldown");
            return null;
        }

        public final void setMobSightCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            mobSightCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getMobSightRadius() {
            ModConfigSpec.DoubleValue doubleValue = mobSightRadius;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"mobSightRadius");
            return null;
        }

        public final void setMobSightRadius(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            mobSightRadius = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getNoHungerCooldown() {
            ModConfigSpec.IntValue intValue = noHungerCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"noHungerCooldown");
            return null;
        }

        public final void setNoHungerCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            noHungerCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getNoHungerMinimum() {
            ModConfigSpec.IntValue intValue = noHungerMinimum;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"noHungerMinimum");
            return null;
        }

        public final void setNoHungerMinimum(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            noHungerMinimum = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getPassivesCheckCooldown() {
            ModConfigSpec.IntValue intValue = passivesCheckCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"passivesCheckCooldown");
            return null;
        }

        public final void setPassivesCheckCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            passivesCheckCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getPhotosynthesisCooldown() {
            ModConfigSpec.IntValue intValue = photosynthesisCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"photosynthesisCooldown");
            return null;
        }

        public final void setPhotosynthesisCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            photosynthesisCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getPhotoSynthesisHungerAmount() {
            ModConfigSpec.IntValue intValue = photoSynthesisHungerAmount;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"photoSynthesisHungerAmount");
            return null;
        }

        public final void setPhotoSynthesisHungerAmount(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            photoSynthesisHungerAmount = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getPhotoSynthesisSaturationAmount() {
            ModConfigSpec.DoubleValue doubleValue = photoSynthesisSaturationAmount;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"photoSynthesisSaturationAmount");
            return null;
        }

        public final void setPhotoSynthesisSaturationAmount(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            photoSynthesisSaturationAmount = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getSlimyDeathCooldown() {
            ModConfigSpec.IntValue intValue = slimyDeathCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"slimyDeathCooldown");
            return null;
        }

        public final void setSlimyDeathCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            slimyDeathCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getSlimyDeathHealthMultiplier() {
            ModConfigSpec.DoubleValue doubleValue = slimyDeathHealthMultiplier;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"slimyDeathHealthMultiplier");
            return null;
        }

        public final void setSlimyDeathHealthMultiplier(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            slimyDeathHealthMultiplier = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getSlimyDeathDespawnCheckTimer() {
            ModConfigSpec.IntValue intValue = slimyDeathDespawnCheckTimer;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"slimyDeathDespawnCheckTimer");
            return null;
        }

        public final void setSlimyDeathDespawnCheckTimer(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            slimyDeathDespawnCheckTimer = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getSlimyDeathDespawnTime() {
            ModConfigSpec.IntValue intValue = slimyDeathDespawnTime;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"slimyDeathDespawnTime");
            return null;
        }

        public final void setSlimyDeathDespawnTime(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            slimyDeathDespawnTime = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getTeleportCooldown() {
            ModConfigSpec.IntValue intValue = teleportCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"teleportCooldown");
            return null;
        }

        public final void setTeleportCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            teleportCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getTeleportDistance() {
            ModConfigSpec.DoubleValue doubleValue = teleportDistance;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"teleportDistance");
            return null;
        }

        public final void setTeleportDistance(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            teleportDistance = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getThornsChance() {
            ModConfigSpec.DoubleValue doubleValue = thornsChance;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"thornsChance");
            return null;
        }

        public final void setThornsChance(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            thornsChance = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getThornsDamage() {
            ModConfigSpec.DoubleValue doubleValue = thornsDamage;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"thornsDamage");
            return null;
        }

        public final void setThornsDamage(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            thornsDamage = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getThornsHungerDrain() {
            ModConfigSpec.DoubleValue doubleValue = thornsHungerDrain;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"thornsHungerDrain");
            return null;
        }

        public final void setThornsHungerDrain(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            thornsHungerDrain = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getWallClimbSpeed() {
            ModConfigSpec.DoubleValue doubleValue = wallClimbSpeed;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"wallClimbSpeed");
            return null;
        }

        public final void setWallClimbSpeed(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            wallClimbSpeed = doubleValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getWoolyCooldown() {
            ModConfigSpec.IntValue intValue = woolyCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"woolyCooldown");
            return null;
        }

        public final void setWoolyCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            woolyCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.IntValue getXpMagnetCooldown() {
            ModConfigSpec.IntValue intValue = xpMagnetCooldown;
            if (intValue != null) {
                return intValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"xpMagnetCooldown");
            return null;
        }

        public final void setXpMagnetCooldown(@NotNull ModConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            xpMagnetCooldown = intValue;
        }

        @NotNull
        public final ModConfigSpec.DoubleValue getXpMagnetRadius() {
            ModConfigSpec.DoubleValue doubleValue = xpMagnetRadius;
            if (doubleValue != null) {
                return doubleValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"xpMagnetRadius");
            return null;
        }

        public final void setXpMagnetRadius(@NotNull ModConfigSpec.DoubleValue doubleValue) {
            Intrinsics.checkNotNullParameter((Object)doubleValue, (String)"<set-?>");
            xpMagnetRadius = doubleValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

