/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.plasmid_injector;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/plasmid_injector/PlasmidInjectorEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "isMetal", "", "isAntiPlasmid", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;ZZ)V", "getGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "()Z", "plasmid", "Ldev/emi/emi/api/stack/EmiIngredient;", "syringeBefore", "syringeAfter", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "geneticsresequenced-1.21"})
public final class PlasmidInjectorEmiRecipe
implements EmiRecipe {
    @NotNull
    private final Gene gene;
    private final boolean isMetal;
    private final boolean isAntiPlasmid;
    @NotNull
    private final EmiIngredient plasmid;
    @NotNull
    private final EmiIngredient syringeBefore;
    @NotNull
    private final EmiStack syringeAfter;

    public PlasmidInjectorEmiRecipe(@NotNull Gene gene, boolean isMetal, boolean isAntiPlasmid) {
        Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
        this.gene = gene;
        this.isMetal = isMetal;
        this.isAntiPlasmid = isAntiPlasmid;
        ItemStack plasmidStack = this.isAntiPlasmid ? ModItems.INSTANCE.getANTI_PLASMID().toStack() : ModItems.INSTANCE.getPLASMID().toStack();
        Intrinsics.checkNotNull((Object)plasmidStack);
        PlasmidItem.Companion.setGene(plasmidStack, this.gene, this.gene.getDnaPointsRequired());
        ItemStack[] itemStackArray = new ItemStack[]{plasmidStack};
        this.plasmid = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        ItemStack syringeStack = this.isMetal ? ModItems.INSTANCE.getMETAL_SYRINGE().toStack() : ModItems.INSTANCE.getSYRINGE().toStack();
        LocalPlayer localPlayer = ClientUtil.INSTANCE.getLocalPlayer();
        if (localPlayer == null) {
            throw new IllegalStateException("Local player is null");
        }
        LocalPlayer localPlayer2 = localPlayer;
        LivingEntity entity = this.isMetal ? (LivingEntity)new Cow(EntityType.COW, localPlayer2.level()) : (LivingEntity)localPlayer2;
        Intrinsics.checkNotNull((Object)syringeStack);
        SyringeItem.Companion.setEntity(syringeStack, entity, false);
        ItemStack[] itemStackArray2 = new ItemStack[]{syringeStack};
        this.syringeBefore = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray2));
        boolean bl = this.isAntiPlasmid ? SyringeItem.Companion.addAntigene(syringeStack, this.gene) : SyringeItem.Companion.addGene(syringeStack, this.gene);
        this.syringeAfter = EmiStack.of((ItemStack)syringeStack);
    }

    @NotNull
    public final Gene getGene() {
        return this.gene;
    }

    public final boolean isMetal() {
        return this.isMetal;
    }

    public final boolean isAntiPlasmid() {
        return this.isAntiPlasmid;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getPLASMID_INJECTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        String string = this.gene.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String syringeString = this.isMetal ? "/metal" : "";
        String plasmidString = this.isAntiPlasmid ? "/anti" : "";
        return OtherUtil.INSTANCE.modResource("/plasmid_injector/" + geneString + syringeString + plasmidString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        Object[] objectArray = new EmiIngredient[]{this.plasmid, this.syringeBefore};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.syringeAfter);
    }

    public int getDisplayWidth() {
        return 102;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 48, 1);
        widgets.addSlot(this.plasmid, 0, 0);
        widgets.addSlot(this.syringeBefore, 24, 0);
        widgets.addSlot((EmiIngredient)this.syringeAfter, 78, 0).recipeContext((EmiRecipe)this);
    }
}

