/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.plasmid_infuser;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/plasmid_infuser/PlasmidInfuserEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "basic", "", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;Z)V", "getGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getBasic", "()Z", "helix", "Ldev/emi/emi/api/stack/EmiIngredient;", "plasmid", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "tooltips", "Lnet/minecraft/network/chat/Component;", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "geneticsresequenced-1.21"})
public final class PlasmidInfuserEmiRecipe
implements EmiRecipe {
    @NotNull
    private final Gene gene;
    private final boolean basic;
    @NotNull
    private final EmiIngredient helix;
    @NotNull
    private final EmiStack plasmid;
    @NotNull
    private final List<Component> tooltips;

    public PlasmidInfuserEmiRecipe(@NotNull Gene gene, boolean basic) {
        Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
        this.gene = gene;
        this.basic = basic;
        int stackSize = this.basic ? this.gene.getDnaPointsRequired() : this.gene.getDnaPointsRequired() / 2;
        ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack(stackSize);
        Intrinsics.checkNotNull((Object)helixStack);
        ItemStack[] itemStackArray = this.basic ? (Gene)ModGenes.INSTANCE.getBASIC().get() : this.gene;
        Intrinsics.checkNotNull((Object)itemStackArray);
        DnaHelixItem.Companion.setGene(helixStack, (Gene)itemStackArray);
        itemStackArray = new ItemStack[]{helixStack};
        this.helix = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        ItemStack plasmidStack = ModItems.INSTANCE.getPLASMID().toStack();
        Intrinsics.checkNotNull((Object)plasmidStack);
        PlasmidItem.Companion.setGene(plasmidStack, this.gene, this.gene.getDnaPointsRequired());
        this.plasmid = EmiStack.of((ItemStack)plasmidStack);
        Object[] objectArray = new MutableComponent[3];
        Object[] objectArray2 = new Object[]{OtherUtil.INSTANCE.withColor(this.gene.getNameComponent(), ChatFormatting.GRAY), this.gene.getDnaPointsRequired()};
        objectArray[0] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.points_required", objectArray2), ChatFormatting.GRAY);
        objectArray[1] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.basic", new Object[0]), ChatFormatting.GRAY);
        objectArray[2] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.plasmid_infuser.matching", new Object[0]), ChatFormatting.GRAY);
        this.tooltips = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Gene getGene() {
        return this.gene;
    }

    public final boolean getBasic() {
        return this.basic;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getPLASMID_INFUSER_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        String string = this.gene.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String basicString = this.basic ? "/basic" : "";
        return OtherUtil.INSTANCE.modResource("/plasmid_infuser/" + geneString + basicString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.helix);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.plasmid);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.helix, 0, 0);
        widgets.addSlot((EmiIngredient)this.plasmid, 58, 0).recipeContext((EmiRecipe)this);
        widgets.addTooltipText(this.tooltips, 0, 0, 76, 18);
    }
}

