/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.dna_extractor;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/dna_extractor/CellToHelixEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "<init>", "(Lnet/minecraft/world/entity/EntityType;)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "cell", "Ldev/emi/emi/api/stack/EmiIngredient;", "helix", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "geneticsresequenced-1.21"})
public final class CellToHelixEmiRecipe
implements EmiRecipe {
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final EmiIngredient cell;
    @NotNull
    private final EmiStack helix;

    public CellToHelixEmiRecipe(@NotNull EntityType<?> entityType) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        this.entityType = entityType;
        ItemStack cellStack = ModItems.INSTANCE.getCELL().toStack();
        Intrinsics.checkNotNull((Object)cellStack);
        EntityDnaItem.Companion.setEntityType(cellStack, this.entityType);
        this.cell = EmiIngredient.of((Ingredient)DataComponentIngredient.of((boolean)false, (ItemStack)cellStack));
        ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)helixStack);
        EntityDnaItem.Companion.setEntityType(helixStack, this.entityType);
        this.helix = EmiStack.of((ItemStack)helixStack);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getDNA_EXTRACTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        ResourceLocation entityTypeRl = resourceLocation;
        String string = entityTypeRl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        return OtherUtil.INSTANCE.modResource("/dna_extractor/" + entityString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.cell);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.helix);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.cell, 0, 0);
        widgets.addSlot((EmiIngredient)this.helix, 58, 0).recipeContext((EmiRecipe)this);
    }
}

