/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.dna_decryptor;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/dna_decryptor/DecryptHelixEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "chance", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;F)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getChance", "()F", "encryptedHelix", "Ldev/emi/emi/api/stack/EmiIngredient;", "decryptedHelix", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "geneticsresequenced-1.21"})
public final class DecryptHelixEmiRecipe
implements EmiRecipe {
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Gene gene;
    private final float chance;
    @NotNull
    private final EmiIngredient encryptedHelix;
    @NotNull
    private final EmiStack decryptedHelix;

    public DecryptHelixEmiRecipe(@NotNull EntityType<?> entityType, @NotNull Gene gene, float chance) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
        this.entityType = entityType;
        this.gene = gene;
        this.chance = chance;
        ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)helixStack);
        EntityDnaItem.Companion.setEntityType(helixStack, this.entityType);
        this.encryptedHelix = EmiIngredient.of((Ingredient)DataComponentIngredient.of((boolean)true, (ItemStack)helixStack));
        ItemStack decryptedHelixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)decryptedHelixStack);
        DnaHelixItem.Companion.setGene(decryptedHelixStack, this.gene);
        this.decryptedHelix = EmiStack.of((ItemStack)decryptedHelixStack);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final Gene getGene() {
        return this.gene;
    }

    public final float getChance() {
        return this.chance;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getDNA_DECRYPTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        ResourceLocation entityTypeRl = resourceLocation;
        String string = entityTypeRl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String string2 = this.gene.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        return OtherUtil.INSTANCE.modResource("/dna_extractor/" + entityString + "/to/" + geneString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.encryptedHelix);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.decryptedHelix);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        String string = "%.2f%%";
        Object[] objectArray = new Object[]{Float.valueOf(this.chance * (float)100)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        widgets.addText((Component)Component.literal((String)string2), -40, 4, 0x3E3E3E, false);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.encryptedHelix, 0, 0);
        widgets.addSlot((EmiIngredient)this.decryptedHelix, 58, 0).recipeContext((EmiRecipe)this);
    }
}

