/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.AbstractEmiBrewingRecipe;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/GmoEmiRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/AbstractEmiBrewingRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "ingredientItem", "Lnet/minecraft/world/item/Item;", "idealGene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "geneChance", "", "isMutation", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/Item;Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;FZ)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getIdealGene", "()Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getGeneChance", "()F", "ingredient", "Ldev/emi/emi/api/stack/EmiIngredient;", "getIngredient", "()Ldev/emi/emi/api/stack/EmiIngredient;", "input", "getInput", "output", "Ldev/emi/emi/api/stack/EmiStack;", "getOutput", "()Ldev/emi/emi/api/stack/EmiStack;", "tertiaryItem", "getTertiaryItem", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "getTooltips", "()Ljava/util/List;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "geneticsresequenced-1.21"})
public final class GmoEmiRecipe
extends AbstractEmiBrewingRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Gene idealGene;
    private final float geneChance;
    @NotNull
    private final EmiIngredient ingredient;
    @NotNull
    private final EmiIngredient input;
    @NotNull
    private final EmiStack output;
    @NotNull
    private final EmiStack tertiaryItem;
    @NotNull
    private final List<Component> tooltips;

    public GmoEmiRecipe(@NotNull EntityType<?> entityType, @NotNull Item ingredientItem, @NotNull Gene idealGene, float geneChance, boolean isMutation) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)ingredientItem, (String)"ingredientItem");
        Intrinsics.checkNotNullParameter((Object)idealGene, (String)"idealGene");
        this.entityType = entityType;
        this.idealGene = idealGene;
        this.geneChance = geneChance;
        Object[] objectArray = new ItemLike[]{ingredientItem};
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.ingredient = emiIngredient;
        DeferredHolder<Potion, Potion> requiredPotion = isMutation ? ModPotions.INSTANCE.getMUTATION() : ModPotions.INSTANCE.getCELL_GROWTH();
        ItemStack potionStack = OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)requiredPotion));
        EntityDnaItem.Companion.setEntityType(potionStack, this.entityType);
        ItemStack[] itemStackArray = new ItemStack[]{potionStack};
        this.input = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        ItemStack gmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)gmoStack);
        EntityDnaItem.Companion.setEntityType(gmoStack, this.entityType);
        DnaHelixItem.Companion.setGene(gmoStack, this.idealGene);
        this.output = EmiStack.of((ItemStack)gmoStack);
        Item item = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"CHORUS_FRUIT");
        ItemStack chorusStack = OtherUtil.INSTANCE.getItemStack(item);
        this.tertiaryItem = EmiStack.of((ItemStack)chorusStack);
        Object[] objectArray2 = new MutableComponent[4];
        objectArray = new Object[2];
        String string = "%.2f%%";
        Object[] objectArray3 = new Object[]{Float.valueOf(this.geneChance * (float)100)};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
        objectArray[1] = this.idealGene.getNameComponent();
        objectArray2[0] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.line1", objectArray), ChatFormatting.GRAY);
        objectArray = new Object[]{((Gene)ModGenes.INSTANCE.getBASIC().get()).getNameComponent()};
        objectArray2[1] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.line2", objectArray), ChatFormatting.GRAY);
        objectArray2[2] = Component.literal((String)"");
        objectArray2[3] = OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.line3", new Object[0]), ChatFormatting.GRAY);
        this.tooltips = CollectionsKt.listOf((Object[])objectArray2);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final Gene getIdealGene() {
        return this.idealGene;
    }

    public final float getGeneChance() {
        return this.geneChance;
    }

    @Override
    @NotNull
    public EmiIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @NotNull
    public EmiIngredient getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public EmiStack getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public EmiStack getTertiaryItem() {
        return this.tertiaryItem;
    }

    @Override
    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getGMO_CATEGORY();
    }

    @Override
    @NotNull
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @NotNull
    public ResourceLocation getId() {
        String string = EntityType.getKey(this.entityType).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String entityTypeString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String string2 = this.idealGene.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        return OtherUtil.INSTANCE.modResource("/gmo/" + entityTypeString + "/" + geneString);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/GmoEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/GmoEmiRecipe;", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nGmoEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GmoEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/GmoEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n808#2,11:99\n1557#2:110\n1628#2,3:111\n*S KotlinDebug\n*F\n+ 1 GmoEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/GmoEmiRecipe$Companion\n*L\n38#1:99,11\n40#1:110\n40#1:111,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<GmoEmiRecipe> getAllRecipes() {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = BrewingRecipes.INSTANCE.getAllRecipes();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GmoRecipe)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allRegularGmoRecipes = (List)destination$iv$iv;
            Iterable $this$map$iv = allRegularGmoRecipes;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GmoRecipe gmoRecipe = (GmoRecipe)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GmoEmiRecipe(it.getEntityType(), it.getIngredientItem(), it.getIdealGene(), it.getGeneChance(), it.isMutation()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

