/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.AbstractEmiBrewingRecipe;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.BlackDeathRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/BlackDeathEmiRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/brewing/AbstractEmiBrewingRecipe;", "isMetal", "", "<init>", "(Z)V", "()Z", "ingredient", "Ldev/emi/emi/api/stack/EmiIngredient;", "getIngredient", "()Ldev/emi/emi/api/stack/EmiIngredient;", "input", "getInput", "output", "Ldev/emi/emi/api/stack/EmiStack;", "getOutput", "()Ldev/emi/emi/api/stack/EmiStack;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "getTooltips", "()Ljava/util/List;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21"})
public final class BlackDeathEmiRecipe
extends AbstractEmiBrewingRecipe {
    private final boolean isMetal;
    @NotNull
    private final EmiIngredient ingredient;
    @NotNull
    private final EmiIngredient input;
    @NotNull
    private final EmiStack output;
    @NotNull
    private final List<Component> tooltips;

    public BlackDeathEmiRecipe(boolean isMetal) {
        this.isMetal = isMetal;
        ItemStack[] itemStackArray = new ItemStack[]{BrewingRecipes.INSTANCE.getViralAgentsPotionStack()};
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.input = emiIngredient;
        ItemStack syringeStack = this.isMetal ? ModItems.INSTANCE.getMETAL_SYRINGE().toStack() : ModItems.INSTANCE.getSYRINGE().toStack();
        LocalPlayer localPlayer = ClientUtil.INSTANCE.getLocalPlayer();
        if (localPlayer == null) {
            throw new IllegalStateException("Local player is null");
        }
        LocalPlayer localPlayer2 = localPlayer;
        LivingEntity entity = this.isMetal ? (LivingEntity)new Cow(EntityType.COW, localPlayer2.level()) : (LivingEntity)localPlayer2;
        Intrinsics.checkNotNull((Object)syringeStack);
        SyringeItem.Companion.setEntity(syringeStack, entity, false);
        for (Gene gene : BlackDeathRecipe.Companion.getRequiredGenes()) {
            Intrinsics.checkNotNull((Object)gene);
            SyringeItem.Companion.addGene(syringeStack, gene);
        }
        ItemStack[] itemStackArray2 = new ItemStack[]{syringeStack};
        this.ingredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray2));
        ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)helixStack);
        DnaHelixItem.Companion.setGene(helixStack, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getBLACK_DEATH()));
        this.output = EmiStack.of((ItemStack)helixStack);
        this.tooltips = CollectionsKt.listOf((Object)OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.black_death", new Object[0]), ChatFormatting.GRAY));
    }

    public final boolean isMetal() {
        return this.isMetal;
    }

    @Override
    @NotNull
    public EmiIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @NotNull
    public EmiIngredient getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public EmiStack getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @NotNull
    public ResourceLocation getId() {
        String type = this.isMetal ? "/metal" : "";
        return OtherUtil.INSTANCE.modResource("/brewing/black_death" + type);
    }
}

