/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.data.MobGeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/ModInformationRecipes;", "", "<init>", "()V", "getInformationRecipes", "", "Ldev/emi/emi/api/recipe/EmiInfoRecipe;", "geneDescriptions", "organicMatter", "mobGenes", "geneticsresequenced-1.21"})
public final class ModInformationRecipes {
    @NotNull
    public static final ModInformationRecipes INSTANCE = new ModInformationRecipes();

    private ModInformationRecipes() {
    }

    @NotNull
    public final List<EmiInfoRecipe> getInformationRecipes() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.organicMatter(), (Iterable)this.geneDescriptions()), (Iterable)this.mobGenes());
    }

    private final List<EmiInfoRecipe> geneDescriptions() {
        List recipes = new ArrayList();
        for (Gene gene : GeneRegistry.INSTANCE.getRegistrySorted()) {
            String geneString;
            if (gene.isHidden() || !gene.isActive()) continue;
            List components = new ArrayList();
            MutableComponent mutableComponent = gene.getNameComponent().copy().withStyle(ModInformationRecipes::geneDescriptions$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            components.add(mutableComponent);
            Intrinsics.checkNotNullExpressionValue((Object)gene.getId().toString(), (String)"toString(...)");
            String translationKey = "info.geneticsresequenced.gene_description." + geneString;
            MutableComponent geneDesc = Component.translatable((String)translationKey);
            if (Intrinsics.areEqual((Object)geneDesc.toString(), (Object)translationKey)) {
                GeneticsResequenced.Companion.getLOGGER().error("Missing translation key: " + translationKey);
            }
            Intrinsics.checkNotNull((Object)geneDesc);
            components.add(geneDesc);
            Set<Gene> requiredGenes = gene.getRequiredGenes();
            if (!((Collection)requiredGenes).isEmpty()) {
                MutableComponent mutableComponent2 = Component.literal((String)"\n");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
                components.add(mutableComponent2);
                components.add(ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.requires_genes", new Object[0]));
                for (Gene requiredGene : requiredGenes) {
                    MutableComponent requiredGeneComponent = requiredGene.isNegative() || requiredGene.isMutation() ? requiredGene.getNameComponent() : requiredGene.getNameComponent().copy().withStyle(ModInformationRecipes::geneDescriptions$lambda$1);
                    MutableComponent line = Component.literal((String)"\u2022 ").append((Component)requiredGeneComponent);
                    Intrinsics.checkNotNull((Object)line);
                    components.add(line);
                }
            }
            ItemStack helix = ModItems.INSTANCE.getDNA_HELIX().toStack();
            Intrinsics.checkNotNull((Object)helix);
            DnaHelixItem.Companion.setGene(helix, gene);
            ItemStack[] itemStackArray = new ItemStack[]{helix};
            EmiInfoRecipe recipe = new EmiInfoRecipe(CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray))), CollectionsKt.toList((Iterable)components), OtherUtil.INSTANCE.modResource("/info/gene/" + StringsKt.replace$default((String)geneString, (char)':', (char)'/', (boolean)false, (int)4, null)));
            recipes.add(recipe);
        }
        return recipes;
    }

    private final List<EmiInfoRecipe> organicMatter() {
        List recipes = new ArrayList();
        for (EntityType<?> entityType : EntityDnaItem.Companion.getValidEntityTypes()) {
            Object[] objectArray = new Object[]{entityType.getDescription()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.organic_matter", objectArray);
            ItemStack organicMatterStack = ModItems.INSTANCE.getORGANIC_MATTER().toStack();
            Intrinsics.checkNotNull((Object)organicMatterStack);
            EntityDnaItem.Companion.setEntityType(organicMatterStack, entityType);
            String string = EntityType.getKey(entityType).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
            ItemStack[] itemStackArray = new ItemStack[]{organicMatterStack};
            EmiInfoRecipe recipe = new EmiInfoRecipe(CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray))), CollectionsKt.listOf((Object)component), OtherUtil.INSTANCE.modResource("/info/organic_matter/" + entityString));
            recipes.add(recipe);
        }
        return recipes;
    }

    private final List<EmiInfoRecipe> mobGenes() {
        List recipes = new ArrayList();
        Set<Map.Entry<EntityType<?>, Map<Gene, Integer>>> allMobGenePairs = MobGeneRegistry.Companion.getRegistry().entrySet();
        for (Map.Entry<EntityType<?>, Map<Gene, Integer>> entry : allMobGenePairs) {
            EntityType<?> entityType = entry.getKey();
            Map<Gene, Integer> genes = entry.getValue();
            Object[] objectArray = new Object[]{entityType.getDescription()};
            MutableComponent informationTextComponent = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.mob_gene.line1", objectArray);
            int sumOfWeights = CollectionsKt.sumOfInt((Iterable)genes.values());
            for (Map.Entry<Gene, Integer> entry2 : genes.entrySet()) {
                Gene gene = entry2.getKey();
                int weight = ((Number)entry2.getValue()).intValue();
                int chance = (int)((double)weight / (double)sumOfWeights * (double)100);
                MutableComponent geneComponent = gene.isNegative() || gene.isMutation() ? gene.getNameComponent() : gene.getNameComponent().copy().withStyle(ModInformationRecipes::mobGenes$lambda$2);
                Object[] objectArray2 = new Object[]{chance, geneComponent};
                MutableComponent component = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.mob_gene.line2", objectArray2);
                informationTextComponent.append((Component)component);
            }
            ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
            Intrinsics.checkNotNull((Object)helixStack);
            EntityDnaItem.Companion.setEntityType(helixStack, entityType);
            String string = EntityType.getKey(entityType).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
            ItemStack[] itemStackArray = new ItemStack[]{helixStack};
            EmiInfoRecipe recipe = new EmiInfoRecipe(CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray))), CollectionsKt.listOf((Object)informationTextComponent), OtherUtil.INSTANCE.modResource("/info/mob_genes/" + entityString));
            recipes.add(recipe);
        }
        return recipes;
    }

    private static final Style geneDescriptions$lambda$0(Style it) {
        return it.withColor(ChatFormatting.RESET).withUnderlined(Boolean.valueOf(true));
    }

    private static final Style geneDescriptions$lambda$1(Style it) {
        return it.withColor(ChatFormatting.RESET);
    }

    private static final Style mobGenes$lambda$2(Style it) {
        return it.withColor(ChatFormatting.RESET);
    }
}

