/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.AntiPlasmidEmiRecipes;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.ModInformationRecipes;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.BlackDeathEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.GmoEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.SetPotionEntityEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.SubstrateCellEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.brewing.VirusEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.blood_purifier.PurifySyringeEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.cell_analyzer.OrganicMatterToCellEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.dna_decryptor.DecryptHelixEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.dna_extractor.CellToHelixEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.plasmid_infuser.PlasmidInfuserEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine.plasmid_injector.PlasmidInjectorEmiRecipe;
import dev.aaronhowser.mods.geneticsresequenced.data.MobGeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.components.EntityTypeItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.item.components.PlasmidProgressItemComponent;
import dev.aaronhowser.mods.geneticsresequenced.recipe.brewing.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@EmiEntrypoint
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/ModEmiPlugin;", "Ldev/emi/emi/api/EmiPlugin;", "<init>", "()V", "register", "", "registry", "Ldev/emi/emi/api/EmiRegistry;", "comparisons", "bloodPurifier", "cellAnalyzer", "dnaExtractor", "dnaDecryptor", "plasmidInfuser", "plasmidInjector", "potions", "substrate", "setPotionEntity", "virus", "gmo", "Companion", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nModEmiPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModEmiPlugin.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/ModEmiPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1863#2,2:237\n827#2:239\n855#2,2:240\n827#2:242\n855#2,2:243\n*S KotlinDebug\n*F\n+ 1 ModEmiPlugin.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/ModEmiPlugin\n*L\n93#1:237,2\n154#1:239\n154#1:240,2\n169#1:242\n169#1:243,2\n*E\n"})
public final class ModEmiPlugin
implements EmiPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EmiStack BLOOD_PURIFIER_STACK;
    @NotNull
    private static final EmiRecipeCategory BLOOD_PURIFIER_CATEGORY;
    @NotNull
    private static final EmiStack CELL_ANALYZER_STACK;
    @NotNull
    private static final EmiRecipeCategory CELL_ANALYZER_CATEGORY;
    @NotNull
    private static final EmiStack DNA_EXTRACTOR_STACK;
    @NotNull
    private static final EmiRecipeCategory DNA_EXTRACTOR_CATEGORY;
    @NotNull
    private static final EmiStack DNA_DECRYPTOR_STACK;
    @NotNull
    private static final EmiRecipeCategory DNA_DECRYPTOR_CATEGORY;
    @NotNull
    private static final EmiStack PLASMID_INFUSER_STACK;
    @NotNull
    private static final EmiRecipeCategory PLASMID_INFUSER_CATEGORY;
    @NotNull
    private static final EmiStack PLASMID_INJECTOR_STACK;
    @NotNull
    private static final EmiRecipeCategory PLASMID_INJECTOR_CATEGORY;
    @NotNull
    private static final EmiStack INCUBATOR_STACK;
    @NotNull
    private static final EmiStack ADVANCED_INCUBATOR_STACK;
    @NotNull
    private static final EmiStack CELL_STACK;
    @NotNull
    private static final EmiStack GMO_CELL_STACK;
    @NotNull
    private static final EmiStack DNA_HELIX_STACK;
    @NotNull
    private static final EmiStack PLASMID_STACK;
    @NotNull
    private static final EmiStack ANTI_PLASMID_STACK;
    @NotNull
    private static final EmiStack BREWING_STAND_STACK;
    @NotNull
    private static final EmiRecipeCategory GMO_CATEGORY;
    @NotNull
    private static final EmiRecipeCategory SET_ENTITY_CATEGORY;
    @NotNull
    private static final EmiRecipeCategory CELL_DUPE_CATEGORY;
    @NotNull
    private static final EmiRecipeCategory VIRUS_CATEGORY;

    public void register(@NotNull EmiRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.bloodPurifier(registry);
        this.cellAnalyzer(registry);
        this.dnaExtractor(registry);
        this.dnaDecryptor(registry);
        this.plasmidInfuser(registry);
        this.plasmidInjector(registry);
        this.potions(registry);
        AntiPlasmidEmiRecipes.INSTANCE.setAntiPlasmidRecipes(registry);
        AntiPlasmidEmiRecipes.INSTANCE.unsetAntiPlasmidRecipes(registry);
        Iterable $this$forEach$iv = ModInformationRecipes.INSTANCE.getInformationRecipes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EmiInfoRecipe it = (EmiInfoRecipe)element$iv;
            boolean bl = false;
            registry.addRecipe((EmiRecipe)it);
        }
        this.comparisons(registry);
    }

    private final void comparisons(EmiRegistry registry) {
        Comparison entityTypeComparison = Comparison.compareData(ModEmiPlugin::comparisons$lambda$1);
        Comparison plasmidProgressComparison = Comparison.compareData(ModEmiPlugin::comparisons$lambda$2);
        registry.setDefaultComparison(CELL_STACK, entityTypeComparison);
        registry.setDefaultComparison(GMO_CELL_STACK, Comparison.compareComponents());
        registry.setDefaultComparison(DNA_HELIX_STACK, Comparison.compareComponents());
        registry.setDefaultComparison(PLASMID_STACK, plasmidProgressComparison);
        registry.setDefaultComparison(ANTI_PLASMID_STACK, plasmidProgressComparison);
    }

    private final void bloodPurifier(EmiRegistry registry) {
        registry.addCategory(BLOOD_PURIFIER_CATEGORY);
        registry.addWorkstation(BLOOD_PURIFIER_CATEGORY, (EmiIngredient)BLOOD_PURIFIER_STACK);
        registry.addRecipe((EmiRecipe)new PurifySyringeEmiRecipe(false));
        registry.addRecipe((EmiRecipe)new PurifySyringeEmiRecipe(true));
    }

    private final void cellAnalyzer(EmiRegistry registry) {
        registry.addCategory(CELL_ANALYZER_CATEGORY);
        registry.addWorkstation(CELL_ANALYZER_CATEGORY, (EmiIngredient)CELL_ANALYZER_STACK);
        for (EntityType<?> entityType : EntityDnaItem.Companion.getValidEntityTypes()) {
            registry.addRecipe((EmiRecipe)new OrganicMatterToCellEmiRecipe(entityType));
        }
    }

    private final void dnaExtractor(EmiRegistry registry) {
        registry.addCategory(DNA_EXTRACTOR_CATEGORY);
        registry.addWorkstation(DNA_EXTRACTOR_CATEGORY, (EmiIngredient)DNA_EXTRACTOR_STACK);
        for (EntityType<?> entityType : EntityDnaItem.Companion.getValidEntityTypes()) {
            registry.addRecipe((EmiRecipe)new CellToHelixEmiRecipe(entityType));
        }
    }

    private final void dnaDecryptor(EmiRegistry registry) {
        registry.addCategory(DNA_DECRYPTOR_CATEGORY);
        registry.addWorkstation(DNA_DECRYPTOR_CATEGORY, (EmiIngredient)DNA_DECRYPTOR_STACK);
        for (Map.Entry<EntityType<?>, Map<Gene, Integer>> entry : MobGeneRegistry.Companion.getRegistry().entrySet()) {
            EntityType<?> entityType = entry.getKey();
            Map<Gene, Integer> map = entry.getValue();
            int totalWeight = CollectionsKt.sumOfInt((Iterable)map.values());
            for (Map.Entry<Gene, Integer> entry2 : map.entrySet()) {
                Gene gene = entry2.getKey();
                int weight = ((Number)entry2.getValue()).intValue();
                float chance = (float)weight / (float)totalWeight;
                registry.addRecipe((EmiRecipe)new DecryptHelixEmiRecipe(entityType, gene, chance));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void plasmidInfuser(EmiRegistry registry) {
        void $this$filterNotTo$iv$iv;
        registry.addCategory(PLASMID_INFUSER_CATEGORY);
        registry.addWorkstation(PLASMID_INFUSER_CATEGORY, (EmiIngredient)PLASMID_INFUSER_STACK);
        Iterable $this$filterNot$iv = GeneRegistry.INSTANCE.getRegistrySorted();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Gene it = (Gene)element$iv$iv;
            boolean bl = false;
            if (it.isHidden()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Gene gene : (List)destination$iv$iv) {
            registry.addRecipe((EmiRecipe)new PlasmidInfuserEmiRecipe(gene, true));
            registry.addRecipe((EmiRecipe)new PlasmidInfuserEmiRecipe(gene, false));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void plasmidInjector(EmiRegistry registry) {
        void $this$filterNotTo$iv$iv;
        registry.addCategory(PLASMID_INJECTOR_CATEGORY);
        registry.addWorkstation(PLASMID_INJECTOR_CATEGORY, (EmiIngredient)PLASMID_INJECTOR_STACK);
        List addingGlass = new ArrayList();
        List addingMetal = new ArrayList();
        List removingGlass = new ArrayList();
        List removingMetal = new ArrayList();
        Iterable $this$filterNot$iv = GeneRegistry.INSTANCE.getRegistrySorted();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Gene it = (Gene)element$iv$iv;
            boolean bl = false;
            if (it.isHidden()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Gene gene : (List)destination$iv$iv) {
            addingGlass.add(new PlasmidInjectorEmiRecipe(gene, false, false));
            addingMetal.add(new PlasmidInjectorEmiRecipe(gene, false, true));
            removingGlass.add(new PlasmidInjectorEmiRecipe(gene, true, false));
            removingMetal.add(new PlasmidInjectorEmiRecipe(gene, true, true));
        }
        for (PlasmidInjectorEmiRecipe recipe : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)addingGlass, (Iterable)addingMetal), (Iterable)removingGlass), (Iterable)removingMetal)) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private final void potions(EmiRegistry registry) {
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, (EmiIngredient)INCUBATOR_STACK);
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, (EmiIngredient)ADVANCED_INCUBATOR_STACK);
        registry.addRecipe((EmiRecipe)new BlackDeathEmiRecipe(false));
        registry.addRecipe((EmiRecipe)new BlackDeathEmiRecipe(true));
        this.substrate(registry);
        this.setPotionEntity(registry);
        this.virus(registry);
        this.gmo(registry);
    }

    private final void substrate(EmiRegistry registry) {
        registry.addCategory(CELL_DUPE_CATEGORY);
        registry.addWorkstation(CELL_DUPE_CATEGORY, (EmiIngredient)BREWING_STAND_STACK);
        registry.addWorkstation(CELL_DUPE_CATEGORY, (EmiIngredient)INCUBATOR_STACK);
        registry.addWorkstation(CELL_DUPE_CATEGORY, (EmiIngredient)ADVANCED_INCUBATOR_STACK);
        for (SubstrateCellEmiRecipe recipe : SubstrateCellEmiRecipe.Companion.getAllRecipes()) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private final void setPotionEntity(EmiRegistry registry) {
        registry.addCategory(SET_ENTITY_CATEGORY);
        registry.addWorkstation(SET_ENTITY_CATEGORY, (EmiIngredient)BREWING_STAND_STACK);
        registry.addWorkstation(SET_ENTITY_CATEGORY, (EmiIngredient)INCUBATOR_STACK);
        registry.addWorkstation(SET_ENTITY_CATEGORY, (EmiIngredient)ADVANCED_INCUBATOR_STACK);
        for (SetPotionEntityEmiRecipe recipe : SetPotionEntityEmiRecipe.Companion.getAllRecipes()) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private final void virus(EmiRegistry registry) {
        registry.addCategory(VIRUS_CATEGORY);
        registry.addWorkstation(VIRUS_CATEGORY, (EmiIngredient)BREWING_STAND_STACK);
        registry.addWorkstation(VIRUS_CATEGORY, (EmiIngredient)INCUBATOR_STACK);
        registry.addWorkstation(VIRUS_CATEGORY, (EmiIngredient)ADVANCED_INCUBATOR_STACK);
        for (VirusEmiRecipe recipe : VirusEmiRecipe.Companion.getAllRecipes()) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private final void gmo(EmiRegistry registry) {
        registry.addCategory(GMO_CATEGORY);
        registry.addWorkstation(GMO_CATEGORY, (EmiIngredient)ADVANCED_INCUBATOR_STACK);
        for (GmoEmiRecipe recipe : GmoEmiRecipe.Companion.getAllRecipes()) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private static final EntityTypeItemComponent comparisons$lambda$1(EmiStack it) {
        return (EntityTypeItemComponent)it.get(EntityTypeItemComponent.Companion.getComponent());
    }

    private static final PlasmidProgressItemComponent comparisons$lambda$2(EmiStack it) {
        return (PlasmidProgressItemComponent)it.get(PlasmidProgressItemComponent.Companion.getComponent());
    }

    static {
        EmiStack emiStack = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getBLOOD_PURIFIER()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        BLOOD_PURIFIER_STACK = emiStack;
        BLOOD_PURIFIER_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("blood_purifier"), (EmiRenderable)BLOOD_PURIFIER_STACK);
        EmiStack emiStack2 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getCELL_ANALYZER()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack2, (String)"of(...)");
        CELL_ANALYZER_STACK = emiStack2;
        CELL_ANALYZER_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("cell_analyzer"), (EmiRenderable)CELL_ANALYZER_STACK);
        EmiStack emiStack3 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getDNA_EXTRACTOR()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack3, (String)"of(...)");
        DNA_EXTRACTOR_STACK = emiStack3;
        DNA_EXTRACTOR_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("dna_extractor"), (EmiRenderable)DNA_EXTRACTOR_STACK);
        EmiStack emiStack4 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getDNA_DECRYPTOR()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack4, (String)"of(...)");
        DNA_DECRYPTOR_STACK = emiStack4;
        DNA_DECRYPTOR_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("dna_decryptor"), (EmiRenderable)DNA_DECRYPTOR_STACK);
        EmiStack emiStack5 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getPLASMID_INFUSER()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack5, (String)"of(...)");
        PLASMID_INFUSER_STACK = emiStack5;
        PLASMID_INFUSER_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("plasmid_infuser"), (EmiRenderable)PLASMID_INFUSER_STACK);
        EmiStack emiStack6 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getPLASMID_INJECTOR()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack6, (String)"of(...)");
        PLASMID_INJECTOR_STACK = emiStack6;
        PLASMID_INJECTOR_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("plasmid_injector"), (EmiRenderable)PLASMID_INJECTOR_STACK);
        EmiStack emiStack7 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getINCUBATOR()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack7, (String)"of(...)");
        INCUBATOR_STACK = emiStack7;
        EmiStack emiStack8 = EmiStack.of((ItemLike)((ItemLike)ModBlocks.INSTANCE.getADVANCED_INCUBATOR()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack8, (String)"of(...)");
        ADVANCED_INCUBATOR_STACK = emiStack8;
        EmiStack emiStack9 = EmiStack.of((ItemLike)((ItemLike)ModItems.INSTANCE.getCELL()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack9, (String)"of(...)");
        CELL_STACK = emiStack9;
        EmiStack emiStack10 = EmiStack.of((ItemLike)((ItemLike)ModItems.INSTANCE.getGMO_CELL()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack10, (String)"of(...)");
        GMO_CELL_STACK = emiStack10;
        EmiStack emiStack11 = EmiStack.of((ItemLike)((ItemLike)ModItems.INSTANCE.getDNA_HELIX()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack11, (String)"of(...)");
        DNA_HELIX_STACK = emiStack11;
        EmiStack emiStack12 = EmiStack.of((ItemLike)((ItemLike)ModItems.INSTANCE.getPLASMID()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack12, (String)"of(...)");
        PLASMID_STACK = emiStack12;
        EmiStack emiStack13 = EmiStack.of((ItemLike)((ItemLike)ModItems.INSTANCE.getANTI_PLASMID()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack13, (String)"of(...)");
        ANTI_PLASMID_STACK = emiStack13;
        EmiStack emiStack14 = EmiStack.of((ItemLike)((ItemLike)Items.BREWING_STAND));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack14, (String)"of(...)");
        BREWING_STAND_STACK = emiStack14;
        GMO_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("gmo"), (EmiRenderable)GMO_CELL_STACK);
        SET_ENTITY_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("set_entity"), (EmiRenderable)EmiStack.of((ItemStack)BrewingRecipes.INSTANCE.getCellGrowthPotionStack()));
        CELL_DUPE_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("cell_dupe"), (EmiRenderable)CELL_STACK);
        VIRUS_CATEGORY = new EmiRecipeCategory(OtherUtil.INSTANCE.modResource("virus"), (EmiRenderable)EmiStack.of((ItemStack)BrewingRecipes.INSTANCE.getViralAgentsPotionStack()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b/\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0007R\u0011\u00100\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000bR\u0011\u00102\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000bR\u0011\u00104\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000bR\u0011\u00106\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000b\u00a8\u00068"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/ModEmiPlugin$Companion;", "", "<init>", "()V", "BLOOD_PURIFIER_STACK", "Ldev/emi/emi/api/stack/EmiStack;", "getBLOOD_PURIFIER_STACK", "()Ldev/emi/emi/api/stack/EmiStack;", "BLOOD_PURIFIER_CATEGORY", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getBLOOD_PURIFIER_CATEGORY", "()Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "CELL_ANALYZER_STACK", "getCELL_ANALYZER_STACK", "CELL_ANALYZER_CATEGORY", "getCELL_ANALYZER_CATEGORY", "DNA_EXTRACTOR_STACK", "getDNA_EXTRACTOR_STACK", "DNA_EXTRACTOR_CATEGORY", "getDNA_EXTRACTOR_CATEGORY", "DNA_DECRYPTOR_STACK", "getDNA_DECRYPTOR_STACK", "DNA_DECRYPTOR_CATEGORY", "getDNA_DECRYPTOR_CATEGORY", "PLASMID_INFUSER_STACK", "getPLASMID_INFUSER_STACK", "PLASMID_INFUSER_CATEGORY", "getPLASMID_INFUSER_CATEGORY", "PLASMID_INJECTOR_STACK", "getPLASMID_INJECTOR_STACK", "PLASMID_INJECTOR_CATEGORY", "getPLASMID_INJECTOR_CATEGORY", "INCUBATOR_STACK", "getINCUBATOR_STACK", "ADVANCED_INCUBATOR_STACK", "getADVANCED_INCUBATOR_STACK", "CELL_STACK", "getCELL_STACK", "GMO_CELL_STACK", "getGMO_CELL_STACK", "DNA_HELIX_STACK", "getDNA_HELIX_STACK", "PLASMID_STACK", "getPLASMID_STACK", "ANTI_PLASMID_STACK", "getANTI_PLASMID_STACK", "BREWING_STAND_STACK", "getBREWING_STAND_STACK", "GMO_CATEGORY", "getGMO_CATEGORY", "SET_ENTITY_CATEGORY", "getSET_ENTITY_CATEGORY", "CELL_DUPE_CATEGORY", "getCELL_DUPE_CATEGORY", "VIRUS_CATEGORY", "getVIRUS_CATEGORY", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EmiStack getBLOOD_PURIFIER_STACK() {
            return BLOOD_PURIFIER_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getBLOOD_PURIFIER_CATEGORY() {
            return BLOOD_PURIFIER_CATEGORY;
        }

        @NotNull
        public final EmiStack getCELL_ANALYZER_STACK() {
            return CELL_ANALYZER_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getCELL_ANALYZER_CATEGORY() {
            return CELL_ANALYZER_CATEGORY;
        }

        @NotNull
        public final EmiStack getDNA_EXTRACTOR_STACK() {
            return DNA_EXTRACTOR_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getDNA_EXTRACTOR_CATEGORY() {
            return DNA_EXTRACTOR_CATEGORY;
        }

        @NotNull
        public final EmiStack getDNA_DECRYPTOR_STACK() {
            return DNA_DECRYPTOR_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getDNA_DECRYPTOR_CATEGORY() {
            return DNA_DECRYPTOR_CATEGORY;
        }

        @NotNull
        public final EmiStack getPLASMID_INFUSER_STACK() {
            return PLASMID_INFUSER_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getPLASMID_INFUSER_CATEGORY() {
            return PLASMID_INFUSER_CATEGORY;
        }

        @NotNull
        public final EmiStack getPLASMID_INJECTOR_STACK() {
            return PLASMID_INJECTOR_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getPLASMID_INJECTOR_CATEGORY() {
            return PLASMID_INJECTOR_CATEGORY;
        }

        @NotNull
        public final EmiStack getINCUBATOR_STACK() {
            return INCUBATOR_STACK;
        }

        @NotNull
        public final EmiStack getADVANCED_INCUBATOR_STACK() {
            return ADVANCED_INCUBATOR_STACK;
        }

        @NotNull
        public final EmiStack getCELL_STACK() {
            return CELL_STACK;
        }

        @NotNull
        public final EmiStack getGMO_CELL_STACK() {
            return GMO_CELL_STACK;
        }

        @NotNull
        public final EmiStack getDNA_HELIX_STACK() {
            return DNA_HELIX_STACK;
        }

        @NotNull
        public final EmiStack getPLASMID_STACK() {
            return PLASMID_STACK;
        }

        @NotNull
        public final EmiStack getANTI_PLASMID_STACK() {
            return ANTI_PLASMID_STACK;
        }

        @NotNull
        public final EmiStack getBREWING_STAND_STACK() {
            return BREWING_STAND_STACK;
        }

        @NotNull
        public final EmiRecipeCategory getGMO_CATEGORY() {
            return GMO_CATEGORY;
        }

        @NotNull
        public final EmiRecipeCategory getSET_ENTITY_CATEGORY() {
            return SET_ENTITY_CATEGORY;
        }

        @NotNull
        public final EmiRecipeCategory getCELL_DUPE_CATEGORY() {
            return CELL_DUPE_CATEGORY;
        }

        @NotNull
        public final EmiRecipeCategory getVIRUS_CATEGORY() {
            return VIRUS_CATEGORY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

