/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.command.ModCommands;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tJ2\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\b\u0002\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J2\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0012\b\u0002\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J2\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\b\u0002\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J&\u0010\u0017\u001a\u00020\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u001b\u001a\u00020\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/command/AddGeneCommand;", "", "<init>", "()V", "GENE_RL_ARGUMENT", "", "GENE_STRING_ARGUMENT", "TARGET_ARGUMENT", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "addGene", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "geneRl", "Lnet/minecraft/resources/ResourceLocation;", "entities", "", "Lnet/minecraft/world/entity/Entity;", "geneString", "geneToAdd", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "handleSingleTarget", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "handleMultipleTargets", "targets", "", "addGeneToTarget", "", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nAddGeneCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/AddGeneCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1611#2,9:211\n1863#2:220\n1864#2:222\n1620#2:223\n1#3:221\n*S KotlinDebug\n*F\n+ 1 AddGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/AddGeneCommand\n*L\n119#1:211,9\n119#1:220\n119#1:222\n119#1:223\n119#1:221\n*E\n"})
public final class AddGeneCommand {
    @NotNull
    public static final AddGeneCommand INSTANCE = new AddGeneCommand();
    @NotNull
    private static final String GENE_RL_ARGUMENT = "geneRl";
    @NotNull
    private static final String GENE_STRING_ARGUMENT = "geneString";
    @NotNull
    private static final String TARGET_ARGUMENT = "targets";

    private AddGeneCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addGene").requires(AddGeneCommand::register$lambda$0)).then(Commands.literal((String)"fromString").then(((RequiredArgumentBuilder)Commands.argument((String)GENE_STRING_ARGUMENT, (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(ModCommands.INSTANCE.getSUGGEST_GENE_STRINGS()).then(Commands.argument((String)TARGET_ARGUMENT, (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(AddGeneCommand::register$lambda$1))).executes(AddGeneCommand::register$lambda$2)))).then(Commands.literal((String)"fromId").then(((RequiredArgumentBuilder)Commands.argument((String)GENE_RL_ARGUMENT, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_GENE_RLS()).then(Commands.argument((String)TARGET_ARGUMENT, (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(AddGeneCommand::register$lambda$3))).executes(AddGeneCommand::register$lambda$4)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final int addGene(CommandContext<CommandSourceStack> context, ResourceLocation geneRl, Collection<? extends Entity> entities) {
        Gene gene = GeneRegistry.INSTANCE.fromId(geneRl);
        if (gene == null) {
            throw new IllegalArgumentException("Gene with id " + geneRl + " does not exist!");
        }
        Gene gene2 = gene;
        return this.addGene(context, gene2, entities);
    }

    static /* synthetic */ int addGene$default(AddGeneCommand addGeneCommand, CommandContext commandContext, ResourceLocation resourceLocation, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return addGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, resourceLocation, (Collection<? extends Entity>)collection);
    }

    private final int addGene(CommandContext<CommandSourceStack> context, String geneString, Collection<? extends Entity> entities) {
        Gene gene = GeneRegistry.INSTANCE.fromIdPath(geneString);
        if (gene == null) {
            throw new IllegalArgumentException("Gene with id " + geneString + " does not exist!");
        }
        Gene gene2 = gene;
        return this.addGene(context, gene2, entities);
    }

    static /* synthetic */ int addGene$default(AddGeneCommand addGeneCommand, CommandContext commandContext, String string, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return addGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, string, (Collection<? extends Entity>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final int addGene(CommandContext<CommandSourceStack> context, Gene geneToAdd, Collection<? extends Entity> entities) {
        List targets;
        Collection<? extends Entity> collection = entities;
        if (collection != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LivingEntity it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Entity it = (Entity)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof LivingEntity ? (LivingEntity)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v1 = (List)destination$iv$iv;
        } else {
            Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
            v1 = targets = CollectionsKt.listOfNotNull((Object)(entity instanceof LivingEntity ? (LivingEntity)entity : null));
        }
        if (targets.size() == 1) {
            this.handleSingleTarget(context, (LivingEntity)CollectionsKt.first((List)targets), geneToAdd);
        } else {
            this.handleMultipleTargets(context, targets, geneToAdd);
        }
        return 1;
    }

    static /* synthetic */ int addGene$default(AddGeneCommand addGeneCommand, CommandContext commandContext, Gene gene, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = null;
        }
        return addGeneCommand.addGene((CommandContext<CommandSourceStack>)commandContext, gene, (Collection<? extends Entity>)collection);
    }

    private final void handleSingleTarget(CommandContext<CommandSourceStack> context, LivingEntity target, Gene geneToAdd) {
        boolean geneWasAdded = this.addGeneToTarget(target, geneToAdd);
        if (geneWasAdded) {
            Object[] objectArray = new Object[]{geneToAdd.getNameComponent(), target.getName()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.success", objectArray);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> AddGeneCommand.handleSingleTarget$lambda$6(component), false);
        } else {
            Object[] objectArray = new Object[]{geneToAdd.getNameComponent(), target.getName()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.fail", objectArray);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)component);
        }
    }

    private final void handleMultipleTargets(CommandContext<CommandSourceStack> context, List<? extends LivingEntity> targets, Gene geneToAdd) {
        MutableComponent component;
        int amountSuccess = 0;
        int amountFail = 0;
        for (LivingEntity objectArray : targets) {
            boolean geneAdded = this.addGeneToTarget(objectArray, geneToAdd);
            if (geneAdded) {
                ++amountSuccess;
                continue;
            }
            ++amountFail;
        }
        if (amountSuccess != 0) {
            Object[] objectArray = new Object[]{geneToAdd.getNameComponent(), amountSuccess};
            component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.success", objectArray);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> AddGeneCommand.handleMultipleTargets$lambda$7(component), false);
        }
        if (amountFail != 0) {
            Object[] objectArray = new Object[]{geneToAdd.getNameComponent(), amountFail};
            component = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.fail", objectArray);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)component);
        }
    }

    private final boolean addGeneToTarget(LivingEntity target, Gene geneToAdd) {
        boolean cantAddToMob;
        boolean alreadyHasGene = GenesData.Companion.hasGene(target, geneToAdd);
        if (alreadyHasGene) {
            GeneticsResequenced.Companion.getLOGGER().info("Tried to add gene " + geneToAdd.getId() + " to " + target.getName().getString() + ", but they already have it!");
            return false;
        }
        boolean bl = cantAddToMob = !(target instanceof Player) && !geneToAdd.getCanMobsHave();
        if (cantAddToMob) {
            GeneticsResequenced.Companion.getLOGGER().info("Tried to add gene " + geneToAdd.getId() + " to " + target.getName().getString() + ", but they can't have it!");
            return false;
        }
        boolean success = GenesData.Companion.addGene(target, geneToAdd);
        return success;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        String string = StringArgumentType.getString((CommandContext)cmd, (String)GENE_STRING_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, string, (Collection<? extends Entity>)EntityArgument.getEntities((CommandContext)cmd, (String)TARGET_ARGUMENT));
    }

    private static final int register$lambda$2(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        String string = StringArgumentType.getString((CommandContext)cmd, (String)GENE_STRING_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, string, null);
    }

    private static final int register$lambda$3(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_RL_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, resourceLocation, (Collection<? extends Entity>)EntityArgument.getEntities((CommandContext)cmd, (String)TARGET_ARGUMENT));
    }

    private static final int register$lambda$4(CommandContext cmd) {
        Intrinsics.checkNotNull((Object)cmd);
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_RL_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.addGene((CommandContext<CommandSourceStack>)cmd, resourceLocation, null);
    }

    private static final Component handleSingleTarget$lambda$6(MutableComponent $component) {
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        return (Component)$component;
    }

    private static final Component handleMultipleTargets$lambda$7(MutableComponent $component) {
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        return (Component)$component;
    }
}

