/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.WrappedHandler;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator.IncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator.IncubatorMenu;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u00017\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0001PB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0014J\u0018\u0010J\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0014J\b\u0010M\u001a\u00020EH\u0016J\b\u0010N\u001a\u00020EH\u0014J\b\u0010O\u001a\u00020?H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u0014\u0010.\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u0014\u00100\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010+R\u0014\u00102\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010+R\u0014\u00104\u001a\u00020)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010+R\u0010\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00108R$\u0010:\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020?8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010@R\u000e\u0010A\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0010R\u0014\u0010K\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0010\u00a8\u0006Q"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator/IncubatorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "potionBrewing", "Lnet/minecraft/world/item/alchemy/PotionBrewing;", "getPotionBrewing", "()Lnet/minecraft/world/item/alchemy/PotionBrewing;", "potionBrewing$delegate", "Lkotlin/Lazy;", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "upItemHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "getUpItemHandler", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "downItemHandler", "getDownItemHandler", "backItemHandler", "getBackItemHandler", "frontItemHandler", "getFrontItemHandler", "rightItemHandler", "getRightItemHandler", "leftItemHandler", "getLeftItemHandler", "data", "dev/aaronhowser/mods/geneticsresequenced/block/machine/incubator/IncubatorBlockEntity$data$1", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator/IncubatorBlockEntity$data$1;", "value", "ticksRemaining", "getTicksRemaining", "setTicksRemaining", "(I)V", "isBrewing", "", "()Z", "ticksRemainingNbtKey", "baseEnergyCostPerTick", "getBaseEnergyCostPerTick", "saveAdditional", "", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "amountOfOverclockers", "getAmountOfOverclockers", "tick", "craftItem", "hasRecipe", "Companion", "geneticsresequenced-1.21"})
public final class IncubatorBlockEntity
extends CraftingMachineBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    @NotNull
    private final Lazy potionBrewing$delegate;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private final WrappedHandler upItemHandler;
    @NotNull
    private final WrappedHandler downItemHandler;
    @NotNull
    private final WrappedHandler backItemHandler;
    @NotNull
    private final WrappedHandler frontItemHandler;
    @NotNull
    private final WrappedHandler rightItemHandler;
    @NotNull
    private final WrappedHandler leftItemHandler;
    @NotNull
    private final data.1 data;
    @NotNull
    private final String ticksRemainingNbtKey;
    private final int baseEnergyCostPerTick;
    public static final int SIMPLE_CONTAINER_SIZE = 1;
    public static final int REMAINING_TICKS_INDEX = 0;
    public static final int TOP_SLOT_INDEX = 0;
    public static final int LEFT_BOTTLE_SLOT_INDEX = 1;
    public static final int MIDDLE_BOTTLE_SLOT_INDEX = 2;
    public static final int RIGHT_BOTTLE_SLOT_INDEX = 3;
    public static final int OVERCLOCKER_SLOT_INDEX = 4;

    public IncubatorBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getINCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "incubator";
        this.energyMaximum = 50000;
        this.energyTransferMaximum = 500;
        this.potionBrewing$delegate = LazyKt.lazy(() -> IncubatorBlockEntity.potionBrewing_delegate$lambda$0(this));
        this.amountOfItemSlots = 5;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            final /* synthetic */ IncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> {
                        PotionBrewing v0 = IncubatorBlockEntity.access$getPotionBrewing(this.this$0);
                        if (v0 != null) {
                            yield v0.isIngredient(stack);
                        }
                        yield false;
                    }
                    case 1, 2, 3 -> {
                        PotionBrewing v2 = IncubatorBlockEntity.access$getPotionBrewing(this.this$0);
                        if (v2 != null) {
                            yield v2.isInput(stack);
                        }
                        yield false;
                    }
                    case 4 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getOVERCLOCKER().get());
                    default -> false;
                };
            }
        };
        this.upItemHandler = Companion.ingredientHandler((IItemHandlerModifiable)this.getItemHandler());
        this.downItemHandler = Companion.outputHandler((IItemHandlerModifiable)this.getItemHandler());
        this.backItemHandler = Companion.inputHandler((IItemHandlerModifiable)this.getItemHandler());
        this.frontItemHandler = Companion.inputHandler((IItemHandlerModifiable)this.getItemHandler());
        this.rightItemHandler = Companion.inputHandler((IItemHandlerModifiable)this.getItemHandler());
        this.leftItemHandler = Companion.inputHandler((IItemHandlerModifiable)this.getItemHandler());
        this.data = new ContainerData(){
            private int remainingTicks;

            public int get(int pIndex) {
                return pIndex == 0 ? this.remainingTicks : 0;
            }

            public void set(int pIndex, int pValue) {
                if (pIndex == 0) {
                    this.remainingTicks = pValue;
                }
            }

            public int getCount() {
                return 1;
            }
        };
        this.ticksRemainingNbtKey = this.getMachineName() + ".ticksRemaining";
        this.baseEnergyCostPerTick = 10;
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new IncubatorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return (Component)ModLanguageProvider.Companion.toComponent("block.geneticsresequenced.incubator", new Object[0]);
    }

    private final PotionBrewing getPotionBrewing() {
        Lazy lazy = this.potionBrewing$delegate;
        return (PotionBrewing)lazy.getValue();
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getUpItemHandler() {
        return this.upItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getDownItemHandler() {
        return this.downItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getBackItemHandler() {
        return this.backItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getFrontItemHandler() {
        return this.frontItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getRightItemHandler() {
        return this.rightItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getLeftItemHandler() {
        return this.leftItemHandler;
    }

    private final int getTicksRemaining() {
        return this.data.get(0);
    }

    private final void setTicksRemaining(int value) {
        this.data.set(0, value);
    }

    private final boolean isBrewing() {
        return this.getTicksRemaining() > 0;
    }

    @Override
    public int getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        pTag.putInt(this.ticksRemainingNbtKey, this.getTicksRemaining());
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.setTicksRemaining(pTag.getInt(this.ticksRemainingNbtKey));
        super.loadAdditional(pTag, pRegistries);
    }

    @Override
    public int getAmountOfOverclockers() {
        return this.getItemHandler().getStackInSlot(4).getCount();
    }

    @Override
    public void tick() {
        boolean hasRecipe = this.hasRecipe();
        if (!this.isBrewing() && hasRecipe) {
            this.setTicksRemaining(Companion.getTicksPerBrew());
        } else if (!hasRecipe) {
            this.setTicksRemaining(0);
            return;
        }
        this.getEnergyStorage().extractEnergy(this.energyCostPerTick(), false);
        this.setTicksRemaining(this.getTicksRemaining() - (1 + this.getAmountOfOverclockers()));
        if (this.getTicksRemaining() <= 0) {
            this.craftItem();
            return;
        }
    }

    @Override
    protected void craftItem() {
        ItemStack topStack = this.getItemHandler().getStackInSlot(0);
        Object object = new Integer[]{1, 2, 3};
        List bottleSlots = CollectionsKt.listOf((Object[])object);
        object = bottleSlots.iterator();
        while (object.hasNext()) {
            PotionBrewing output;
            int slotIndex = ((Number)object.next()).intValue();
            ItemStack bottleStack = this.getItemHandler().getStackInSlot(slotIndex);
            PotionBrewing potionBrewing = this.getPotionBrewing();
            if (potionBrewing == null) continue;
            if ((potionBrewing = potionBrewing.mix(topStack, bottleStack)) == null || (output = potionBrewing).isEmpty()) continue;
            this.getItemHandler().setStackInSlot(slotIndex, (ItemStack)output);
        }
        topStack.shrink(1);
        this.setChanged();
    }

    @Override
    protected boolean hasRecipe() {
        if (!this.hasEnoughEnergy()) {
            return false;
        }
        ItemStack topSlotStack = this.getItemHandler().getStackInSlot(0);
        PotionBrewing potionBrewing = this.getPotionBrewing();
        if (potionBrewing != null) {
            PotionBrewing potionBrewing2;
            PotionBrewing $this$hasRecipe_u24lambda_u241 = potionBrewing2 = potionBrewing;
            boolean bl = false;
            if ($this$hasRecipe_u24lambda_u241.hasMix(this.getItemHandler().getStackInSlot(1), topSlotStack)) {
                return true;
            }
            if ($this$hasRecipe_u24lambda_u241.hasMix(this.getItemHandler().getStackInSlot(2), topSlotStack)) {
                return true;
            }
            if ($this$hasRecipe_u24lambda_u241.hasMix(this.getItemHandler().getStackInSlot(3), topSlotStack)) {
                return true;
            }
        }
        return false;
    }

    private static final PotionBrewing potionBrewing_delegate$lambda$0(IncubatorBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Level level = this$0.level;
        return level != null ? level.potionBrewing() : null;
    }

    public static final /* synthetic */ PotionBrewing access$getPotionBrewing(IncubatorBlockEntity $this) {
        return $this.getPotionBrewing();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator/IncubatorBlockEntity$Companion;", "", "<init>", "()V", "ingredientHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "itemHandler", "Lnet/neoforged/neoforge/items/IItemHandlerModifiable;", "inputHandler", "outputHandler", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator/IncubatorBlockEntity;", "SIMPLE_CONTAINER_SIZE", "", "REMAINING_TICKS_INDEX", "TOP_SLOT_INDEX", "LEFT_BOTTLE_SLOT_INDEX", "MIDDLE_BOTTLE_SLOT_INDEX", "RIGHT_BOTTLE_SLOT_INDEX", "OVERCLOCKER_SLOT_INDEX", "ticksPerBrew", "getTicksPerBrew", "()I", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WrappedHandler ingredientHandler(@NotNull IItemHandlerModifiable itemHandler2) {
            Intrinsics.checkNotNullParameter((Object)itemHandler2, (String)"itemHandler");
            return new WrappedHandler(itemHandler2, (Function1<? super Integer, Boolean>)((Function1)Companion::ingredientHandler$lambda$0), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)Companion::ingredientHandler$lambda$1));
        }

        @NotNull
        public final WrappedHandler inputHandler(@NotNull IItemHandlerModifiable itemHandler2) {
            Intrinsics.checkNotNullParameter((Object)itemHandler2, (String)"itemHandler");
            return new WrappedHandler(itemHandler2, (Function1<? super Integer, Boolean>)((Function1)Companion::inputHandler$lambda$2), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)Companion::inputHandler$lambda$3));
        }

        @NotNull
        public final WrappedHandler outputHandler(@NotNull IItemHandlerModifiable itemHandler2) {
            Intrinsics.checkNotNullParameter((Object)itemHandler2, (String)"itemHandler");
            return new WrappedHandler(itemHandler2, (Function1<? super Integer, Boolean>)((Function1)Companion::outputHandler$lambda$4), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)Companion::outputHandler$lambda$5));
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull IncubatorBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public final int getTicksPerBrew() {
            Object object = ServerConfig.Companion.getIncubatorTicksPerBrew().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        private static final boolean ingredientHandler$lambda$0(int slotId) {
            return slotId == 1;
        }

        private static final boolean ingredientHandler$lambda$1(int slotId, ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return slotId == 0;
        }

        private static final boolean inputHandler$lambda$2(int slotId) {
            return slotId == 1;
        }

        private static final boolean inputHandler$lambda$3(int slotId, ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return slotId == 1 || slotId == 2 || slotId == 3;
        }

        private static final boolean outputHandler$lambda$4(int slotId) {
            return slotId == 1;
        }

        private static final boolean outputHandler$lambda$5(int slotId, ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

