/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator;

import dev.aaronhowser.mods.geneticsresequenced.block.base.menu.MachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.text.NumberFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/menu/MachineMenu;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity;", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity;Lnet/minecraft/world/inventory/ContainerData;)V", "extraData", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "value", "maxBurnTime", "getMaxBurnTime", "()I", "setMaxBurnTime", "(I)V", "burnTimeRemaining", "getBurnTimeRemaining", "setBurnTimeRemaining", "isBurning", "", "()Z", "getPercentDone", "", "getScaledFuelRemaining", "getScaledProgressArrow", "stillValid", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "Companion", "geneticsresequenced-1.21"})
public final class CoalGeneratorMenu
extends MachineMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContainerData containerData;

    public CoalGeneratorMenu(int id, @NotNull Inventory inventory, @NotNull CoalGeneratorBlockEntity blockEntity, @NotNull ContainerData containerData2) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)containerData2, (String)"containerData");
        Object object = ModMenuTypes.INSTANCE.getCOAL_GENERATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, blockEntity, id, inventory);
        this.containerData = containerData2;
        AbstractContainerMenu.checkContainerSize((Container)((Container)inventory), (int)2);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        IItemHandler itemHandler2 = this.getBlockEntity().getItemCapability(null);
        this.addSlot((Slot)new SlotItemHandler(itemHandler2, 0, 52, 34));
        this.addDataSlots(this.containerData);
    }

    public CoalGeneratorMenu(int id, @NotNull Inventory inventory, @NotNull RegistryFriendlyByteBuf extraData) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        BlockEntity blockEntity = inventory.player.level().getBlockEntity(extraData.readBlockPos());
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorBlockEntity");
        this(id, inventory, (CoalGeneratorBlockEntity)blockEntity, (ContainerData)new SimpleContainerData(2));
    }

    private final int getMaxBurnTime() {
        return this.containerData.get(1);
    }

    private final void setMaxBurnTime(int value) {
        this.containerData.set(1, value);
    }

    private final int getBurnTimeRemaining() {
        return this.containerData.get(0);
    }

    private final void setBurnTimeRemaining(int value) {
        this.containerData.set(0, value);
    }

    public final boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }

    public final double getPercentDone() {
        if (this.getMaxBurnTime() == 0) {
            return 0.0;
        }
        return 1.0 - (double)this.getBurnTimeRemaining() / (double)this.getMaxBurnTime();
    }

    public final int getScaledFuelRemaining() {
        int fuelSize = 16;
        return this.getMaxBurnTime() == 0 ? 0 : fuelSize - (int)((double)fuelSize * this.getPercentDone());
    }

    public final int getScaledProgressArrow() {
        int progressArrowWidth = 24;
        return this.getMaxBurnTime() == 0 ? 0 : (int)((double)progressArrowWidth * this.getPercentDone());
    }

    @Override
    public boolean stillValid(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockEntity().getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.INSTANCE.getCOAL_GENERATOR().get()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorMenu$Companion;", "", "<init>", "()V", "showFuelTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        public final void showFuelTooltip(@NotNull ItemTooltipEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ItemStack itemStack = event.getItemStack();
            int fuelPer = itemStack.getBurnTime(RecipeType.SMELTING);
            if (fuelPer <= 0) {
                return;
            }
            int feProducedPer = CoalGeneratorBlockEntity.Companion.getEnergyPerTick() * fuelPer;
            String feStringPer = NumberFormat.getNumberInstance().format((Object)feProducedPer);
            List list = event.getToolTip();
            MutableComponent mutableComponent = Component.literal((String)(feStringPer + " FE"));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            list.add(1, OtherUtil.INSTANCE.withColor(mutableComponent, ChatFormatting.GRAY));
            int amount = itemStack.getCount();
            if (amount > 1) {
                int feProducedTotal = feProducedPer * amount;
                String feStringTotal = NumberFormat.getNumberInstance().format((Object)feProducedTotal);
                Object[] objectArray = new Object[]{feStringTotal};
                event.getToolTip().add(2, OtherUtil.INSTANCE.withColor(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.coal_generator.total_fe", objectArray), ChatFormatting.GRAY));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

