/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator;

import dev.aaronhowser.mods.geneticsresequenced.block.base.InventoryEnergyBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.WrappedHandler;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.coal_generator.CoalGeneratorMenu;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005*\u00012\u0018\u0000 Q2\u00020\u00012\u00020\u0002:\u0001QB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0014J\b\u0010E\u001a\u000207H\u0002J\b\u0010F\u001a\u000207H\u0002J\u0018\u0010G\u001a\u0002072\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u000eH\u0002J\b\u0010K\u001a\u000207H\u0002J\b\u0010O\u001a\u00020MH\u0002J\b\u0010P\u001a\u000207H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010&R\u0014\u0010-\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010&R\u0014\u0010/\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010&R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u000e\u00104\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\u0010\"\u0004\b@\u0010AR$\u0010B\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010\u0010\"\u0004\bD\u0010AR\u0011\u0010L\u001a\u00020M8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010N\u00a8\u0006R"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "allSideHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "upItemHandler", "getUpItemHandler", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "downItemHandler", "getDownItemHandler", "backItemHandler", "getBackItemHandler", "frontItemHandler", "getFrontItemHandler", "rightItemHandler", "getRightItemHandler", "leftItemHandler", "getLeftItemHandler", "data", "dev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity$data$1", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity$data$1;", "burnTicksLeftNbtKey", "maxBurnTicksNbtKey", "saveAdditional", "", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "value", "maxBurnTime", "getMaxBurnTime", "setMaxBurnTime", "(I)V", "burnTimeRemaining", "getBurnTimeRemaining", "setBurnTimeRemaining", "tryToStartBurning", "stopBurning", "startBurning", "inputItem", "Lnet/minecraft/world/item/ItemStack;", "fuel", "generateEnergy", "isBurning", "", "()Z", "hasRoomForEnergy", "pushEnergyToAdjacent", "Companion", "geneticsresequenced-1.21"})
public final class CoalGeneratorBlockEntity
extends InventoryEnergyBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private final WrappedHandler allSideHandler;
    @NotNull
    private final WrappedHandler upItemHandler;
    @NotNull
    private final WrappedHandler downItemHandler;
    @NotNull
    private final WrappedHandler backItemHandler;
    @NotNull
    private final WrappedHandler frontItemHandler;
    @NotNull
    private final WrappedHandler rightItemHandler;
    @NotNull
    private final WrappedHandler leftItemHandler;
    @NotNull
    private final data.1 data;
    @NotNull
    private final String burnTicksLeftNbtKey;
    @NotNull
    private final String maxBurnTicksNbtKey;
    public static final int SIMPLE_CONTAINER_SIZE = 2;
    public static final int INPUT_SLOT = 0;
    public static final int REMAINING_TICKS_INDEX = 0;
    public static final int MAX_BURN_TIME_INDEX = 1;

    public CoalGeneratorBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getCOAL_GENERATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "coal_generator";
        Object object2 = ServerConfig.Companion.getCoalGeneratorEnergyCapacity().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.energyMaximum = ((Number)object2).intValue();
        Object object3 = ServerConfig.Companion.getCoalGeneratorEnergyTransferRate().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.energyTransferMaximum = ((Number)object3).intValue();
        this.amountOfItemSlots = 1;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            private final Object2BooleanOpenHashMap<Item> replacementCache;
            final /* synthetic */ CoalGeneratorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
                this.replacementCache = new Object2BooleanOpenHashMap();
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
            }

            private final boolean isReplacementItem(Item item) {
                return this.replacementCache.computeIfAbsent((Object)item, arg_0 -> itemHandler.1.isReplacementItem$lambda$1(item, arg_0));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                if (stack.getBurnTime(RecipeType.SMELTING) > 0) {
                    return true;
                }
                boolean bl = false;
                boolean isFuel = bl;
                if (isFuel) return true;
                Item item = stack.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                if (!this.isReplacementItem(item)) return false;
                return true;
            }

            private static final boolean isReplacementItem$lambda$1(Item $item, Item it) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
                    DefaultedRegistry defaultedRegistry = BuiltInRegistries.ITEM;
                    Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"ITEM");
                    Iterable $this$any$iv = (Iterable)defaultedRegistry;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Item it2 = (Item)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it2.getCraftingRemainingItem(new ItemStack((ItemLike)$item)).getItem(), (Object)$item)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean isReplacement = bl;
                return isReplacement;
            }
        };
        this.upItemHandler = this.allSideHandler = new WrappedHandler((IItemHandlerModifiable)this.getItemHandler(), (Function1<? super Integer, Boolean>)((Function1)CoalGeneratorBlockEntity::allSideHandler$lambda$0), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)(arg_0, arg_1) -> CoalGeneratorBlockEntity.allSideHandler$lambda$1(this, arg_0, arg_1)));
        this.downItemHandler = this.allSideHandler;
        this.backItemHandler = this.allSideHandler;
        this.frontItemHandler = this.allSideHandler;
        this.rightItemHandler = this.allSideHandler;
        this.leftItemHandler = this.allSideHandler;
        this.data = new ContainerData(){
            private int _totalTicksToBurn;
            private int _ticksToBurnRemaining;

            private final void set_totalTicksToBurn(int value) {
                this._totalTicksToBurn = value;
                this.set_ticksToBurnRemaining(RangesKt.coerceAtMost((int)this._ticksToBurnRemaining, (int)this._totalTicksToBurn));
            }

            private final void set_ticksToBurnRemaining(int value) {
                this._ticksToBurnRemaining = RangesKt.coerceIn((int)value, (int)0, (int)this._totalTicksToBurn);
            }

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> this._ticksToBurnRemaining;
                    case 1 -> this._totalTicksToBurn;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        this.set_ticksToBurnRemaining(pValue);
                        break;
                    }
                    case 1: {
                        this.set_totalTicksToBurn(pValue);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.burnTicksLeftNbtKey = this.getMachineName() + ".burn_ticks_left";
        this.maxBurnTicksNbtKey = this.getMachineName() + ".max_burn_ticks";
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new CoalGeneratorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return (Component)ModLanguageProvider.Companion.toComponent("block.geneticsresequenced.coal_generator", new Object[0]);
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getUpItemHandler() {
        return this.upItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getDownItemHandler() {
        return this.downItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getBackItemHandler() {
        return this.backItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getFrontItemHandler() {
        return this.frontItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getRightItemHandler() {
        return this.rightItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getLeftItemHandler() {
        return this.leftItemHandler;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        pTag.putInt(this.burnTicksLeftNbtKey, this.getBurnTimeRemaining());
        pTag.putInt(this.maxBurnTicksNbtKey, this.getMaxBurnTime());
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.setMaxBurnTime(pTag.getInt(this.maxBurnTicksNbtKey));
        this.setBurnTimeRemaining(pTag.getInt(this.burnTicksLeftNbtKey));
        super.loadAdditional(pTag, pRegistries);
    }

    private final int getMaxBurnTime() {
        return this.data.get(1);
    }

    private final void setMaxBurnTime(int value) {
        this.data.set(1, value);
        this.setChanged();
    }

    private final int getBurnTimeRemaining() {
        int t = this.data.get(0);
        return t;
    }

    private final void setBurnTimeRemaining(int value) {
        this.data.set(0, value);
        this.setChanged();
    }

    private final void tryToStartBurning() {
        ItemStack inputItem = this.getItemHandler().getStackInSlot(0);
        int fuel = inputItem.getBurnTime(RecipeType.SMELTING);
        if (fuel <= 0) {
            this.stopBurning();
        } else {
            Intrinsics.checkNotNull((Object)inputItem);
            this.startBurning(inputItem, fuel);
        }
        this.setChanged();
    }

    private final void stopBurning() {
        block0: {
            this.setMaxBurnTime(0);
            this.setBurnTimeRemaining(0);
            BlockState state = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.Companion.getBURNING(), (Comparable)Boolean.valueOf(false));
            Level level = this.level;
            if (level == null) break block0;
            level.setBlock(this.getBlockPos(), state, 3);
        }
    }

    private final void startBurning(ItemStack inputItem, int fuel) {
        BlockState state = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.Companion.getBURNING(), (Comparable)Boolean.valueOf(true));
        Level level = this.level;
        if (level != null) {
            level.setBlock(this.getBlockPos(), state, 3);
        }
        ItemStack fuelReplacedItem = inputItem.getCraftingRemainingItem();
        this.setMaxBurnTime(fuel);
        this.setBurnTimeRemaining(fuel);
        this.getItemHandler().extractItem(0, 1, false);
        if (!fuelReplacedItem.isEmpty() && this.getItemHandler().getStackInSlot(0).isEmpty()) {
            this.getItemHandler().insertItem(0, fuelReplacedItem, false);
        }
    }

    private final void generateEnergy() {
        this.getEnergyStorage().receiveEnergy(Companion.getEnergyPerTick(), false);
        this.setBurnTimeRemaining(this.getBurnTimeRemaining() - 1);
        this.setChanged();
    }

    public final boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }

    private final boolean hasRoomForEnergy() {
        int maxEnergy = this.getEnergyStorage().getMaxEnergyStored();
        int currentEnergy = this.getEnergyStorage().getEnergyStored();
        return currentEnergy + Companion.getEnergyPerTick() <= maxEnergy;
    }

    private final void pushEnergyToAdjacent() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : EntriesMappings.entries$0) {
            int n;
            IEnergyStorage neighborEnergy;
            BlockPos neighborPos = this.getBlockPos().offset(direction.getNormal());
            BlockState block = level2.getBlockState(neighborPos);
            BlockEntity blockEntity = level2.getBlockEntity(neighborPos);
            if ((IEnergyStorage)level2.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite()) == null || !neighborEnergy.canReceive()) continue;
            Object object = ServerConfig.Companion.getCoalGeneratorEnergyTransferRate().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int n2 = neighborEnergy.receiveEnergy(((Number)object).intValue(), true);
            int energyToTransfer = Math.min(n2, n = neighborEnergy.getMaxEnergyStored() - neighborEnergy.getEnergyStored());
            if (energyToTransfer <= 0) continue;
            neighborEnergy.receiveEnergy(this.getEnergyStorage().extractEnergy(energyToTransfer, false), false);
        }
    }

    private static final boolean allSideHandler$lambda$0(int it) {
        return true;
    }

    private static final boolean allSideHandler$lambda$1(CoalGeneratorBlockEntity this$0, int slot, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this$0.getItemHandler().isItemValid(slot, stack);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/coal_generator/CoalGeneratorBlockEntity;", "SIMPLE_CONTAINER_SIZE", "", "INPUT_SLOT", "energyPerTick", "getEnergyPerTick", "()I", "REMAINING_TICKS_INDEX", "MAX_BURN_TIME_INDEX", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull CoalGeneratorBlockEntity blockEntity) {
            CoalGeneratorBlockEntity coalGeneratorBlockEntity;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            CoalGeneratorBlockEntity $this$tick_u24lambda_u240 = coalGeneratorBlockEntity = blockEntity;
            boolean bl = false;
            $this$tick_u24lambda_u240.pushEnergyToAdjacent();
            if (!$this$tick_u24lambda_u240.hasRoomForEnergy()) {
                return;
            }
            if ($this$tick_u24lambda_u240.isBurning()) {
                $this$tick_u24lambda_u240.generateEnergy();
            } else {
                $this$tick_u24lambda_u240.tryToStartBurning();
            }
        }

        public final int getEnergyPerTick() {
            Object object = ServerConfig.Companion.getCoalGeneratorEnergyPerTick().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

