/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.cell_analyzer;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.cell_analyzer.CellAnalyzerMenu;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/cell_analyzer/CellAnalyzerBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "baseEnergyCostPerTick", "getBaseEnergyCostPerTick", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "craftItem", "", "hasRecipe", "", "outputSlotHasRoom", "inventory", "Lnet/minecraft/world/SimpleContainer;", "potentialOutput", "Lnet/minecraft/world/item/ItemStack;", "Companion", "geneticsresequenced-1.21"})
public final class CellAnalyzerBlockEntity
extends CraftingMachineBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    private final int baseEnergyCostPerTick;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;

    public CellAnalyzerBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getCELL_ANALYZER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "cell_analyzer";
        this.energyMaximum = 60000;
        this.energyTransferMaximum = 256;
        this.baseEnergyCostPerTick = 32;
        this.amountOfItemSlots = 3;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            final /* synthetic */ CellAnalyzerBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> stack.is((Item)ModItems.INSTANCE.getORGANIC_MATTER().get());
                    case 2 -> stack.is((Item)ModItems.INSTANCE.getOVERCLOCKER().get());
                    case 1 -> false;
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @Override
    public int getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new CellAnalyzerMenu(pContainerId, pPlayerInventory, this, this.getContainerData());
    }

    @NotNull
    public Component getDisplayName() {
        return (Component)ModLanguageProvider.Companion.toComponent("block.geneticsresequenced.cell_analyzer", new Object[0]);
    }

    @Override
    protected void craftItem() {
        if (!this.hasRecipe()) {
            return;
        }
        ItemStack inputItem = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNull((Object)inputItem);
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(inputItem);
        if (entityType == null) {
            return;
        }
        EntityType<?> inputEntity = entityType;
        ItemStack outputItem = EntityDnaItem.Companion.setEntityType(new ItemStack((ItemLike)ModItems.INSTANCE.getCELL().get()), inputEntity);
        int amountAlreadyInOutput = this.getItemHandler().getStackInSlot(1).getCount();
        outputItem.setCount(amountAlreadyInOutput + 1);
        this.getItemHandler().extractItem(0, 1, false);
        this.getItemHandler().setStackInSlot(1, outputItem);
    }

    @Override
    protected boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.getItemHandler().getSlots());
        int n = this.getItemHandler().getSlots();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.getItemHandler().getStackInSlot(i));
        }
        ItemStack inputItemStack = inventory.getItem(0);
        if (!inputItemStack.is((Item)ModItems.INSTANCE.getORGANIC_MATTER().get())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)inputItemStack);
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(inputItemStack);
        if (entityType == null) {
            return false;
        }
        EntityType<?> mobType = entityType;
        ItemStack itemStack = EntityDnaItem.Companion.setEntityType(new ItemStack((ItemLike)ModItems.INSTANCE.getCELL().get()), mobType);
        if (itemStack == null) {
            return false;
        }
        ItemStack outputItem = itemStack;
        return this.outputSlotHasRoom(inventory, outputItem);
    }

    private final boolean outputSlotHasRoom(SimpleContainer inventory, ItemStack potentialOutput) {
        ItemStack outputSlot = inventory.getItem(1);
        if (outputSlot.isEmpty()) {
            return true;
        }
        if (outputSlot.getCount() + potentialOutput.getCount() > outputSlot.getMaxStackSize()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)outputSlot);
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(outputSlot);
        if (entityType == null) {
            return false;
        }
        EntityType<?> mobAlreadyInSlot = entityType;
        EntityType<?> entityType2 = EntityDnaItem.Companion.getEntityType(potentialOutput);
        if (entityType2 == null) {
            return false;
        }
        EntityType<?> mobToInsert = entityType2;
        return Intrinsics.areEqual(mobAlreadyInSlot, mobToInsert);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/cell_analyzer/CellAnalyzerBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/cell_analyzer/CellAnalyzerBlockEntity;", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull CellAnalyzerBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

