/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base;

import dev.aaronhowser.mods.geneticsresequenced.block.base.InventoryEnergyBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.ModEnergyStorage;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.WrappedHandler;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010N\u001a\u0002052\b\u00103\u001a\u0004\u0018\u00010.H\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020U0TH\u0016J\b\u0010V\u001a\u00020WH\u0016J\u0006\u0010X\u001a\u00020WJ\u0018\u0010Y\u001a\u00020W2\u0006\u0010Z\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0014J\u0018\u0010[\u001a\u00020W2\u0006\u0010Z\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0014R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0012\u0010\u0018\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0012\u0010$\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u0012\u0010&\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010!R\u0012\u0010(\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u0012\u0010*\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010!R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001f0-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001b\u00104\u001a\u0002058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b6\u00107R\u001b\u0010:\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00109\u001a\u0004\b;\u00107R\u001b\u0010=\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u00109\u001a\u0004\b>\u00107R\u001b\u0010@\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u00109\u001a\u0004\bA\u00107R\u001b\u0010C\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u00109\u001a\u0004\bD\u00107R\u001b\u0010F\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u00109\u001a\u0004\bG\u00107R\u001b\u0010I\u001a\u0002058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u00109\u001a\u0004\bJ\u00107R \u0010L\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002050-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u00100\u00a8\u0006\\"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "inventoryNbtKey", "getInventoryNbtKey", "energyNbtKey", "getEnergyNbtKey", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "upItemHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "getUpItemHandler", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "downItemHandler", "getDownItemHandler", "backItemHandler", "getBackItemHandler", "frontItemHandler", "getFrontItemHandler", "rightItemHandler", "getRightItemHandler", "leftItemHandler", "getLeftItemHandler", "directionWrappedHandlerMap", "", "Lnet/minecraft/core/Direction;", "getDirectionWrappedHandlerMap", "()Ljava/util/Map;", "getItemCapability", "Lnet/neoforged/neoforge/items/IItemHandler;", "side", "energyStorage", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/ModEnergyStorage;", "getEnergyStorage", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/ModEnergyStorage;", "energyStorage$delegate", "Lkotlin/Lazy;", "upEnergyStorage", "getUpEnergyStorage", "upEnergyStorage$delegate", "downEnergyStorage", "getDownEnergyStorage", "downEnergyStorage$delegate", "backEnergyStorage", "getBackEnergyStorage", "backEnergyStorage$delegate", "frontEnergyStorage", "getFrontEnergyStorage", "frontEnergyStorage$delegate", "rightEnergyStorage", "getRightEnergyStorage", "rightEnergyStorage$delegate", "leftEnergyStorage", "getLeftEnergyStorage", "leftEnergyStorage$delegate", "directionModEnergyStorageMap", "getDirectionModEnergyStorageMap", "getEnergyCapability", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "setChanged", "", "dropDrops", "saveAdditional", "pTag", "loadAdditional", "geneticsresequenced-1.21"})
public abstract class InventoryEnergyBlockEntity
extends BlockEntity {
    @NotNull
    private final Lazy energyStorage$delegate;
    @NotNull
    private final Lazy upEnergyStorage$delegate;
    @NotNull
    private final Lazy downEnergyStorage$delegate;
    @NotNull
    private final Lazy backEnergyStorage$delegate;
    @NotNull
    private final Lazy frontEnergyStorage$delegate;
    @NotNull
    private final Lazy rightEnergyStorage$delegate;
    @NotNull
    private final Lazy leftEnergyStorage$delegate;

    public InventoryEnergyBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super(blockEntityType, pPos, pBlockState);
        this.energyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.energyStorage_delegate$lambda$0(this));
        this.upEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.upEnergyStorage_delegate$lambda$1(this));
        this.downEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.downEnergyStorage_delegate$lambda$2(this));
        this.backEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.backEnergyStorage_delegate$lambda$3(this));
        this.frontEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.frontEnergyStorage_delegate$lambda$4(this));
        this.rightEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.rightEnergyStorage_delegate$lambda$5(this));
        this.leftEnergyStorage$delegate = LazyKt.lazy(() -> InventoryEnergyBlockEntity.leftEnergyStorage_delegate$lambda$6(this));
    }

    @NotNull
    public abstract String getMachineName();

    @NotNull
    protected final String getInventoryNbtKey() {
        return this.getMachineName() + ".inventory";
    }

    @NotNull
    protected final String getEnergyNbtKey() {
        return this.getMachineName() + ".energy";
    }

    public abstract int getEnergyMaximum();

    public abstract int getEnergyTransferMaximum();

    public abstract int getAmountOfItemSlots();

    @NotNull
    public abstract ItemStackHandler getItemHandler();

    @NotNull
    protected abstract WrappedHandler getUpItemHandler();

    @NotNull
    protected abstract WrappedHandler getDownItemHandler();

    @NotNull
    protected abstract WrappedHandler getBackItemHandler();

    @NotNull
    protected abstract WrappedHandler getFrontItemHandler();

    @NotNull
    protected abstract WrappedHandler getRightItemHandler();

    @NotNull
    protected abstract WrappedHandler getLeftItemHandler();

    private final Map<Direction, WrappedHandler> getDirectionWrappedHandlerMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Direction.DOWN, (Object)this.getDownItemHandler()), TuplesKt.to((Object)Direction.UP, (Object)this.getUpItemHandler()), TuplesKt.to((Object)Direction.NORTH, (Object)this.getBackItemHandler()), TuplesKt.to((Object)Direction.SOUTH, (Object)this.getFrontItemHandler()), TuplesKt.to((Object)Direction.EAST, (Object)this.getRightItemHandler()), TuplesKt.to((Object)Direction.WEST, (Object)this.getLeftItemHandler())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public IItemHandler getItemCapability(@Nullable Direction side) {
        Direction directionFacing;
        if (side == null) {
            return (IItemHandler)this.getItemHandler();
        }
        if (side == Direction.UP) {
            return (IItemHandler)this.getUpItemHandler();
        }
        if (side == Direction.DOWN) {
            return (IItemHandler)this.getDownItemHandler();
        }
        Direction direction = directionFacing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                WrappedHandler v1 = this.getDirectionWrappedHandlerMap().get(side.getOpposite());
                Intrinsics.checkNotNull((Object)v1);
                yield (IItemHandler)v1;
            }
            case 2 -> {
                WrappedHandler v3 = this.getDirectionWrappedHandlerMap().get(side);
                Intrinsics.checkNotNull((Object)v3);
                yield (IItemHandler)v3;
            }
            case 3 -> {
                WrappedHandler v4 = this.getDirectionWrappedHandlerMap().get(side.getClockWise());
                Intrinsics.checkNotNull((Object)v4);
                yield (IItemHandler)v4;
            }
            case 4 -> {
                WrappedHandler v5 = this.getDirectionWrappedHandlerMap().get(side.getCounterClockWise());
                Intrinsics.checkNotNull((Object)v5);
                yield (IItemHandler)v5;
            }
            default -> {
                WrappedHandler v6 = this.getDirectionWrappedHandlerMap().get(side);
                Intrinsics.checkNotNull((Object)v6);
                yield (IItemHandler)v6;
            }
        };
    }

    @NotNull
    public ModEnergyStorage getEnergyStorage() {
        Lazy lazy = this.energyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getUpEnergyStorage() {
        Lazy lazy = this.upEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getDownEnergyStorage() {
        Lazy lazy = this.downEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getBackEnergyStorage() {
        Lazy lazy = this.backEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getFrontEnergyStorage() {
        Lazy lazy = this.frontEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getRightEnergyStorage() {
        Lazy lazy = this.rightEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    @NotNull
    protected ModEnergyStorage getLeftEnergyStorage() {
        Lazy lazy = this.leftEnergyStorage$delegate;
        return (ModEnergyStorage)((Object)lazy.getValue());
    }

    private final Map<Direction, ModEnergyStorage> getDirectionModEnergyStorageMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Direction.DOWN, (Object)((Object)this.getDownEnergyStorage())), TuplesKt.to((Object)Direction.UP, (Object)((Object)this.getUpEnergyStorage())), TuplesKt.to((Object)Direction.NORTH, (Object)((Object)this.getBackEnergyStorage())), TuplesKt.to((Object)Direction.SOUTH, (Object)((Object)this.getFrontEnergyStorage())), TuplesKt.to((Object)Direction.EAST, (Object)((Object)this.getRightEnergyStorage())), TuplesKt.to((Object)Direction.WEST, (Object)((Object)this.getLeftEnergyStorage()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public ModEnergyStorage getEnergyCapability(@Nullable Direction side) {
        Direction directionFacing;
        if (side == null) {
            return this.getEnergyStorage();
        }
        if (side == Direction.UP || side == Direction.DOWN) {
            ModEnergyStorage modEnergyStorage = this.getDirectionModEnergyStorageMap().get(side);
            Intrinsics.checkNotNull((Object)((Object)modEnergyStorage));
            return modEnergyStorage;
        }
        Direction direction = directionFacing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                ModEnergyStorage v2 = this.getDirectionModEnergyStorageMap().get(side.getOpposite());
                Intrinsics.checkNotNull((Object)((Object)v2));
                yield v2;
            }
            case 2 -> {
                ModEnergyStorage v4 = this.getDirectionModEnergyStorageMap().get(side);
                Intrinsics.checkNotNull((Object)((Object)v4));
                yield v4;
            }
            case 3 -> {
                ModEnergyStorage v5 = this.getDirectionModEnergyStorageMap().get(side.getClockWise());
                Intrinsics.checkNotNull((Object)((Object)v5));
                yield v5;
            }
            case 4 -> {
                ModEnergyStorage v6 = this.getDirectionModEnergyStorageMap().get(side.getCounterClockWise());
                Intrinsics.checkNotNull((Object)((Object)v6));
                yield v6;
            }
            default -> {
                ModEnergyStorage v7 = this.getDirectionModEnergyStorageMap().get(side);
                Intrinsics.checkNotNull((Object)((Object)v7));
                yield v7;
            }
        };
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public void setChanged() {
        block0: {
            super.setChanged();
            Level level = this.level;
            if (level == null) break block0;
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public final void dropDrops() {
        SimpleContainer inventory = new SimpleContainer(this.getItemHandler().getSlots());
        int n = this.getItemHandler().getSlots();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.getItemHandler().getStackInSlot(i));
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        Containers.dropContents((Level)level, (BlockPos)this.getBlockPos(), (Container)((Container)inventory));
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        pTag.put(this.getInventoryNbtKey(), (Tag)this.getItemHandler().serializeNBT(pRegistries));
        pTag.putInt(this.getEnergyNbtKey(), this.getEnergyStorage().getEnergyStored());
        super.saveAdditional(pTag, pRegistries);
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.getItemHandler().deserializeNBT(pRegistries, pTag.getCompound(this.getInventoryNbtKey()));
        this.getEnergyStorage().setEnergy(pTag.getInt(this.getEnergyNbtKey()));
        super.loadAdditional(pTag, pRegistries);
    }

    private static final energyStorage.2.1 energyStorage_delegate$lambda$0(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int n = this$0.getEnergyMaximum();
        int n2 = this$0.getEnergyTransferMaximum();
        return new ModEnergyStorage(this$0, n, n2){
            final /* synthetic */ InventoryEnergyBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void onEnergyChanged() {
                this.this$0.setChanged();
            }
        };
    }

    private static final ModEnergyStorage upEnergyStorage_delegate$lambda$1(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    private static final ModEnergyStorage downEnergyStorage_delegate$lambda$2(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    private static final ModEnergyStorage backEnergyStorage_delegate$lambda$3(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    private static final ModEnergyStorage frontEnergyStorage_delegate$lambda$4(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    private static final ModEnergyStorage rightEnergyStorage_delegate$lambda$5(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    private static final ModEnergyStorage leftEnergyStorage_delegate$lambda$6(InventoryEnergyBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getEnergyStorage();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

