/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J0\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J0\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "blockEntityType", "Ljava/lang/Class;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Ljava/lang/Class;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "pContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "pBuilder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "pState", "onRemove", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pNewState", "pIsMoving", "", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "geneticsresequenced-1.21"})
public abstract class CraftingMachineBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    @NotNull
    private final Class<? extends CraftingMachineBlockEntity> blockEntityType;

    public CraftingMachineBlock(@NotNull BlockBehaviour.Properties properties, @NotNull Class<? extends CraftingMachineBlockEntity> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        super(properties);
        this.blockEntityType = blockEntityType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    public /* synthetic */ CraftingMachineBlock(BlockBehaviour.Properties properties, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            properties = BlockBehaviour.Properties.of().sound(SoundType.METAL);
        }
        this(properties, clazz);
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        Object object = this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        Intrinsics.checkNotNullParameter(pBuilder, (String)"pBuilder");
        super.createBlockStateDefinition(pBuilder);
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING};
        pBuilder.add(propertyArray);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        return RenderShape.MODEL;
    }

    protected void onRemove(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pNewState, (String)"pNewState");
        if (!Intrinsics.areEqual((Object)pState.getBlock(), (Object)pNewState.getBlock())) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            CraftingMachineBlockEntity craftingMachineBlockEntity = blockEntity instanceof CraftingMachineBlockEntity ? (CraftingMachineBlockEntity)blockEntity : null;
            if (craftingMachineBlockEntity == null) {
                throw new IllegalStateException("No block entity found at " + pPos);
            }
            CraftingMachineBlockEntity blockEntity2 = craftingMachineBlockEntity;
            blockEntity2.dropDrops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Object[] objectArray = new Class[]{BlockPos.class, BlockState.class};
        Constructor<? extends CraftingMachineBlockEntity> constructor = this.blockEntityType.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{pPos, pState};
        return constructor.newInstance(objectArray);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHitResult) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHitResult, (String)"pHitResult");
        if (!(pPlayer instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        CraftingMachineBlockEntity craftingMachineBlockEntity = blockEntity instanceof CraftingMachineBlockEntity ? (CraftingMachineBlockEntity)blockEntity : null;
        if (craftingMachineBlockEntity == null) {
            throw new IllegalStateException("No block entity found at " + pPos);
        }
        CraftingMachineBlockEntity blockEntity2 = craftingMachineBlockEntity;
        pPlayer.openMenu((MenuProvider)blockEntity2, pPos);
        return InteractionResult.SUCCESS;
    }
}

