/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\u0011H\u0014J8\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/AntiFieldBlock;", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getProperties", "()Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "codec", "Lcom/mojang/serialization/MapCodec;", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "pContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "pBuilder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "neighborChanged", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pNeighborBlock", "pNeighborPos", "pMovedByPiston", "", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21"})
public final class AntiFieldBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockBehaviour.Properties properties;
    @NotNull
    private static final BooleanProperty DISABLED;

    public AntiFieldBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false)));
    }

    public /* synthetic */ AntiFieldBlock(BlockBehaviour.Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            properties = BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(0.3f);
        }
        this(properties);
    }

    @NotNull
    public final BlockBehaviour.Properties getProperties() {
        return this.properties;
    }

    @NotNull
    protected MapCodec<? extends AntiFieldBlock> codec() {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(AntiFieldBlock::codec$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        return mapCodec;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        Intrinsics.checkNotNullParameter((Object)pContext, (String)"pContext");
        return (BlockState)this.defaultBlockState().setValue((Property)DISABLED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        Intrinsics.checkNotNullParameter(pBuilder, (String)"pBuilder");
        super.createBlockStateDefinition(pBuilder);
        Property[] propertyArray = new Property[]{DISABLED};
        pBuilder.add(propertyArray);
    }

    protected void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pNeighborBlock, @NotNull BlockPos pNeighborPos, boolean pMovedByPiston) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pNeighborBlock, (String)"pNeighborBlock");
        Intrinsics.checkNotNullParameter((Object)pNeighborPos, (String)"pNeighborPos");
        boolean isPowered = pLevel.hasNeighborSignal(pPos);
        if (!Intrinsics.areEqual((Object)pState.getValue((Property)DISABLED), (Object)isPowered)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)DISABLED, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    @NotNull
    public final BlockBehaviour.Properties component1() {
        return this.properties;
    }

    @NotNull
    public final AntiFieldBlock copy(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new AntiFieldBlock(properties);
    }

    public static /* synthetic */ AntiFieldBlock copy$default(AntiFieldBlock antiFieldBlock, BlockBehaviour.Properties properties, int n, Object object) {
        if ((n & 1) != 0) {
            properties = antiFieldBlock.properties;
        }
        return antiFieldBlock.copy(properties);
    }

    @NotNull
    public String toString() {
        return "AntiFieldBlock(properties=" + this.properties + ")";
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AntiFieldBlock)) {
            return false;
        }
        AntiFieldBlock antiFieldBlock = (AntiFieldBlock)((Object)other);
        return Intrinsics.areEqual((Object)this.properties, (Object)antiFieldBlock.properties);
    }

    private static final App codec$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Block.propertiesCodec()).apply((Applicative)instance, AntiFieldBlock::new);
    }

    public AntiFieldBlock() {
        this(null, 1, null);
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.POWERED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"POWERED");
        DISABLED = booleanProperty;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/AntiFieldBlock$Companion;", "", "<init>", "()V", "DISABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getDISABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getNearestActiveAntifield", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/Level;", "location", "isNearActiveAntifield", "", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getDISABLED() {
            return DISABLED;
        }

        @NotNull
        public final Optional<BlockPos> getNearestActiveAntifield(@NotNull Level level, @NotNull BlockPos location) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Integer radius = (Integer)ServerConfig.Companion.getAntifieldBlockRadius().get();
            Intrinsics.checkNotNull((Object)radius);
            Optional optional = BlockPos.findClosestMatch((BlockPos)location, (int)radius, (int)radius, arg_0 -> Companion.getNearestActiveAntifield$lambda$0(level, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findClosestMatch(...)");
            return optional;
        }

        public final boolean isNearActiveAntifield(@NotNull Level level, @NotNull BlockPos location) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return this.getNearestActiveAntifield(level, location).isPresent();
        }

        private static final boolean getNearestActiveAntifield$lambda$0(Level $level, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
            BlockState blockState = $level.getBlockState(pos);
            return Intrinsics.areEqual((Object)blockState.getBlock(), (Object)ModBlocks.INSTANCE.getANTI_FIELD_BLOCK().get()) && (Boolean)blockState.getValue((Property)Companion.getDISABLED()) == false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

