/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.attachment;

import com.mojang.serialization.Codec;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.event.CustomEvents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttachmentTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData;", "", "genes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "<init>", "(Ljava/util/Set;)V", "()V", "getGenes", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21"})
public final class GenesData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Gene> genes;
    @NotNull
    private static final Codec<GenesData> CODEC;
    @NotNull
    private static final Lazy<AttachmentType<GenesData>> attachment$delegate;

    public GenesData(@NotNull Set<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        this.genes = genes;
    }

    @NotNull
    public final Set<Gene> getGenes() {
        return this.genes;
    }

    public GenesData() {
        this(new HashSet());
    }

    @NotNull
    public final Set<Gene> component1() {
        return this.genes;
    }

    @NotNull
    public final GenesData copy(@NotNull Set<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        return new GenesData(genes);
    }

    public static /* synthetic */ GenesData copy$default(GenesData genesData, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = genesData.genes;
        }
        return genesData.copy(set);
    }

    @NotNull
    public String toString() {
        return "GenesData(genes=" + this.genes + ")";
    }

    public int hashCode() {
        return ((Object)this.genes).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenesData)) {
            return false;
        }
        GenesData genesData = (GenesData)other;
        return Intrinsics.areEqual(this.genes, genesData.genes);
    }

    private static final GenesData CODEC$lambda$0(List list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        return new GenesData(new HashSet(list));
    }

    private static final GenesData CODEC$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GenesData)$tmp0.invoke(p0);
    }

    private static final List CODEC$lambda$2(GenesData genes) {
        Intrinsics.checkNotNullParameter((Object)genes, (String)"genes");
        return new ArrayList(genes.genes);
    }

    private static final List CODEC$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final AttachmentType attachment_delegate$lambda$4() {
        return (AttachmentType)ModAttachmentTypes.INSTANCE.getGENE_CONTAINER().get();
    }

    static {
        Codec codec = Gene.Companion.getCODEC().listOf().xmap(arg_0 -> GenesData.CODEC$lambda$1(GenesData::CODEC$lambda$0, arg_0), arg_0 -> GenesData.CODEC$lambda$3(GenesData::CODEC$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"xmap(...)");
        CODEC = codec;
        attachment$delegate = LazyKt.lazy(GenesData::attachment_delegate$lambda$4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011J\u0012\u0010\u001b\u001a\u00020\u0019*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0011J\u0012\u0010\u001d\u001a\u00020\u0019*\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011J\n\u0010\u001f\u001a\u00020 *\u00020\u0013J\u0014\u0010!\u001a\u00020 *\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "attachment", "Lnet/neoforged/neoforge/attachment/AttachmentType;", "getAttachment", "()Lnet/neoforged/neoforge/attachment/AttachmentType;", "attachment$delegate", "Lkotlin/Lazy;", "value", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "genes", "Lnet/minecraft/world/entity/LivingEntity;", "getGenes", "(Lnet/minecraft/world/entity/LivingEntity;)Ljava/util/Set;", "setGenes", "(Lnet/minecraft/world/entity/LivingEntity;Ljava/util/Set;)V", "addGene", "", "newGene", "removeGene", "removedGene", "hasGene", "gene", "removeAllGenes", "", "addAlLGenes", "includeNegative", "geneticsresequenced-1.21"})
    @SourceDebugExtension(value={"SMAP\nGenesData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenesData.kt\ndev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n17#2:119\n17#2:120\n17#2:121\n17#2:122\n774#3:123\n865#3,2:124\n*S KotlinDebug\n*F\n+ 1 GenesData.kt\ndev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion\n*L\n66#1:119\n75#1:120\n84#1:121\n93#1:122\n110#1:123\n110#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<GenesData> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final AttachmentType<GenesData> getAttachment() {
            Lazy lazy = attachment$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (AttachmentType)object;
        }

        @NotNull
        public final Set<Gene> getGenes(@NotNull LivingEntity $this$genes) {
            Intrinsics.checkNotNullParameter((Object)$this$genes, (String)"<this>");
            return ((GenesData)$this$genes.getData(this.getAttachment())).getGenes();
        }

        private final void setGenes(LivingEntity $this$genes, Set<Gene> value) {
            $this$genes.setData(this.getAttachment(), (Object)new GenesData(value));
        }

        public final boolean addGene(@NotNull LivingEntity $this$addGene, @NotNull Gene newGene) {
            Intrinsics.checkNotNullParameter((Object)$this$addGene, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)newGene, (String)"newGene");
            if (this.hasGene($this$addGene, newGene)) {
                return false;
            }
            if (newGene.isHidden()) {
                GeneticsResequenced.Companion.getLOGGER().debug("Cannot add hidden gene " + newGene + " to entity.");
                return false;
            }
            if ($this$addGene instanceof Player && newGene.isNegative() && ((Boolean)ServerConfig.Companion.getDisableGivingPlayersNegativeGenes().get()).booleanValue() && !Intrinsics.areEqual((Object)newGene, (Object)ModGenes.INSTANCE.getCRINGE().get())) {
                GeneticsResequenced.Companion.getLOGGER().debug("Tried to give negative gene " + newGene + " to player " + $this$addGene + ", but \"disableGivingPlayersNegativeGenes\" is true in the server config.");
                return false;
            }
            if (!($this$addGene instanceof Player) && !newGene.getCanMobsHave()) {
                GeneticsResequenced.Companion.getLOGGER().debug("Tried to give gene " + newGene + " to mob " + $this$addGene + ", but mobs cannot have that gene!");
                return false;
            }
            CustomEvents.GeneChangeEvent.Pre eventPre = new CustomEvents.GeneChangeEvent.Pre($this$addGene, newGene, true);
            boolean $i$f$getFORGE_BUS = false;
            IEventBus iEventBus = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
            boolean wasCanceled = ((CustomEvents.GeneChangeEvent.Pre)iEventBus.post((Event)eventPre)).isCanceled();
            if (wasCanceled) {
                GeneticsResequenced.Companion.getLOGGER().debug("Event was canceled: " + eventPre);
                return false;
            }
            this.setGenes($this$addGene, SetsKt.plus(this.getGenes($this$addGene), (Object)newGene));
            CustomEvents.GeneChangeEvent.Post eventPost = new CustomEvents.GeneChangeEvent.Post($this$addGene, newGene, true);
            boolean $i$f$getFORGE_BUS2 = false;
            IEventBus iEventBus2 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
            iEventBus2.post((Event)eventPost);
            return true;
        }

        public final boolean removeGene(@NotNull LivingEntity $this$removeGene, @NotNull Gene removedGene) {
            Intrinsics.checkNotNullParameter((Object)$this$removeGene, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)removedGene, (String)"removedGene");
            if (!this.hasGene($this$removeGene, removedGene)) {
                return false;
            }
            CustomEvents.GeneChangeEvent.Pre eventPre = new CustomEvents.GeneChangeEvent.Pre($this$removeGene, removedGene, false);
            boolean $i$f$getFORGE_BUS = false;
            IEventBus iEventBus = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
            boolean wasCanceled = ((CustomEvents.GeneChangeEvent.Pre)iEventBus.post((Event)eventPre)).isCanceled();
            if (wasCanceled) {
                GeneticsResequenced.Companion.getLOGGER().debug("Event was canceled: " + eventPre);
                return false;
            }
            this.setGenes($this$removeGene, SetsKt.minus(this.getGenes($this$removeGene), (Object)removedGene));
            CustomEvents.GeneChangeEvent.Post eventPost = new CustomEvents.GeneChangeEvent.Post($this$removeGene, removedGene, false);
            boolean $i$f$getFORGE_BUS2 = false;
            IEventBus iEventBus2 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
            iEventBus2.post((Event)eventPost);
            return true;
        }

        public final boolean hasGene(@NotNull LivingEntity $this$hasGene, @NotNull Gene gene) {
            Intrinsics.checkNotNullParameter((Object)$this$hasGene, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
            return this.getGenes($this$hasGene).contains(gene);
        }

        public final void removeAllGenes(@NotNull LivingEntity $this$removeAllGenes) {
            Intrinsics.checkNotNullParameter((Object)$this$removeAllGenes, (String)"<this>");
            for (Gene gene : this.getGenes($this$removeAllGenes)) {
                this.removeGene($this$removeAllGenes, gene);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addAlLGenes(@NotNull LivingEntity $this$addAlLGenes, boolean includeNegative) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$addAlLGenes, (String)"<this>");
            Iterable $this$filter$iv = (Iterable)GeneRegistry.INSTANCE.getGENE_REGISTRY();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Gene it = (Gene)element$iv$iv;
                boolean bl = false;
                if (!(includeNegative || !it.isNegative())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List genesToAdd = (List)destination$iv$iv;
            for (Gene gene : genesToAdd) {
                Intrinsics.checkNotNull((Object)gene);
                this.addGene($this$addAlLGenes, gene);
            }
        }

        public static /* synthetic */ void addAlLGenes$default(Companion companion, LivingEntity livingEntity, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            companion.addAlLGenes(livingEntity, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

