/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.api.genes;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/api/genes/GeneRegistry;", "", "<init>", "()V", "GENE_REGISTRY_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "getGENE_REGISTRY_KEY", "()Lnet/minecraft/resources/ResourceKey;", "GENE_REGISTRY", "getGENE_REGISTRY", "()Lnet/minecraft/core/Registry;", "fromId", "id", "Lnet/minecraft/resources/ResourceLocation;", "", "fromIdPath", "path", "getRegistrySorted", "", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nGeneRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneRegistry.kt\ndev/aaronhowser/mods/geneticsresequenced/api/genes/GeneRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1#2:40\n1053#3:41\n*S KotlinDebug\n*F\n+ 1 GeneRegistry.kt\ndev/aaronhowser/mods/geneticsresequenced/api/genes/GeneRegistry\n*L\n36#1:41\n*E\n"})
public final class GeneRegistry {
    @NotNull
    public static final GeneRegistry INSTANCE = new GeneRegistry();
    @NotNull
    private static final ResourceKey<Registry<Gene>> GENE_REGISTRY_KEY;
    @NotNull
    private static final Registry<Gene> GENE_REGISTRY;

    private GeneRegistry() {
    }

    @NotNull
    public final ResourceKey<Registry<Gene>> getGENE_REGISTRY_KEY() {
        return GENE_REGISTRY_KEY;
    }

    @NotNull
    public final Registry<Gene> getGENE_REGISTRY() {
        return GENE_REGISTRY;
    }

    @Nullable
    public final Gene fromId(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Gene)GENE_REGISTRY.get(id);
    }

    @Nullable
    public final Gene fromId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Gene)GENE_REGISTRY.get(ResourceLocation.parse((String)id));
    }

    @Nullable
    public final Gene fromIdPath(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable iterable = (Iterable)GENE_REGISTRY;
            for (Object t : iterable) {
                Gene it = (Gene)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().getPath(), (Object)path)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<Gene> getRegistrySorted() {
        List mutations = new ArrayList();
        List negatives = new ArrayList();
        List other = new ArrayList();
        for (Gene gene : GENE_REGISTRY) {
            boolean bl;
            if (gene.isMutation()) {
                Intrinsics.checkNotNull((Object)gene);
                bl = mutations.add(gene);
                continue;
            }
            if (gene.isNegative()) {
                Intrinsics.checkNotNull((Object)gene);
                bl = negatives.add(gene);
                continue;
            }
            Intrinsics.checkNotNull((Object)gene);
            bl = other.add(gene);
        }
        Iterable $this$sortedBy$iv = other;
        boolean $i$f$sortedBy = false;
        Collection collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Gene it = (Gene)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getId();
                it = (Gene)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getId()));
            }
        });
        $this$sortedBy$iv = mutations;
        $i$f$sortedBy = false;
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Gene it = (Gene)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getId();
                it = (Gene)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getId()));
            }
        }));
        $this$sortedBy$iv = negatives;
        $i$f$sortedBy = false;
        return CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Gene it = (Gene)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getId();
                it = (Gene)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getId()));
            }
        }));
    }

    static {
        ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)OtherUtil.INSTANCE.modResource("genes"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"createRegistryKey(...)");
        GENE_REGISTRY_KEY = resourceKey;
        Registry registry = new RegistryBuilder(GENE_REGISTRY_KEY).sync(true).create();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"create(...)");
        GENE_REGISTRY = registry;
    }
}

