/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.api.genes;

import com.mojang.serialization.Codec;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneProperties;
import dev.aaronhowser.mods.geneticsresequenced.api.genes.GeneRegistry;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000\u001bJ\u0014\u0010%\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000\u001bJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000'J\b\u00103\u001a\u00020#H\u0002J\b\u00104\u001a\u0004\u0018\u000105J\u0016\u00106\u001a\u00020#2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR\u0017\u0010(\u001a\u00020\u001e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001e\u00102\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\f\u00a8\u0006;"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "", "properties", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/GeneProperties;", "<init>", "(Ldev/aaronhowser/mods/geneticsresequenced/api/genes/GeneProperties;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "isNegative", "", "()Z", "isHidden", "canMobsHave", "getCanMobsHave", "dnaPointsRequired", "", "getDnaPointsRequired", "()I", "mutatesInto", "potionDetails", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/GeneProperties$PotionDetails;", "attributeModifiers", "", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "toString", "", "requiredGenes", "", "isMutation", "addRequiredGenes", "", "genes", "removeRequiredGenes", "getRequiredGenes", "", "translationKey", "getTranslationKey$annotations", "()V", "getTranslationKey", "()Ljava/lang/String;", "nameComponent", "Lnet/minecraft/network/chat/MutableComponent;", "getNameComponent", "()Lnet/minecraft/network/chat/MutableComponent;", "value", "isActive", "deactivate", "getPotion", "Lnet/minecraft/world/effect/MobEffectInstance;", "setAttributeModifiers", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "isAdding", "Companion", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nGene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gene.kt\ndev/aaronhowser/mods/geneticsresequenced/api/genes/Gene\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1755#2,3:181\n*S KotlinDebug\n*F\n+ 1 Gene.kt\ndev/aaronhowser/mods/geneticsresequenced/api/genes/Gene\n*L\n78#1:181,3\n*E\n"})
public final class Gene {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation id;
    private final boolean isNegative;
    private final boolean isHidden;
    private final boolean canMobsHave;
    private final int dnaPointsRequired;
    @Nullable
    private final Gene mutatesInto;
    @Nullable
    private final GeneProperties.PotionDetails potionDetails;
    @NotNull
    private final Map<Holder<Attribute>, Collection<AttributeModifier>> attributeModifiers;
    @NotNull
    private final Set<Gene> requiredGenes;
    @NotNull
    private final String translationKey;
    private boolean isActive;
    @NotNull
    private static final MutableComponent unknownGeneComponent = ModLanguageProvider.Companion.toComponent("gene.geneticsresequenced.unknown", new Object[0]);
    @NotNull
    private static final Lazy<Set<Gene>> requiredGenes$delegate = LazyKt.lazy(Gene::requiredGenes_delegate$lambda$2);
    @NotNull
    private static final Codec<Gene> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, Gene> STREAM_CODEC;

    public Gene(@NotNull GeneProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.id = properties.getId();
        this.isNegative = properties.isNegative();
        this.isHidden = properties.isHidden();
        this.canMobsHave = properties.getCanMobsHave();
        this.dnaPointsRequired = properties.getDnaPointsRequired();
        this.mutatesInto = properties.getMutatesInto();
        this.potionDetails = properties.getPotionDetails();
        this.attributeModifiers = properties.getAttributeModifiers();
        this.requiredGenes = new LinkedHashSet();
        this.translationKey = "gene." + this.id.getNamespace() + "." + this.id.getPath();
        this.isActive = true;
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    public final boolean isNegative() {
        return this.isNegative;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    public final boolean getCanMobsHave() {
        return this.canMobsHave;
    }

    public final int getDnaPointsRequired() {
        return this.dnaPointsRequired;
    }

    @NotNull
    public String toString() {
        return "Gene(" + this.id + ")";
    }

    public final boolean isMutation() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)GeneRegistry.INSTANCE.getGENE_REGISTRY();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Gene it = (Gene)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.mutatesInto, (Object)this)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void addRequiredGenes(@NotNull Collection<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        this.requiredGenes.addAll(genes);
    }

    public final void removeRequiredGenes(@NotNull Collection<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        this.requiredGenes.removeAll(CollectionsKt.toSet((Iterable)genes));
    }

    @NotNull
    public final Set<Gene> getRequiredGenes() {
        return CollectionsKt.toSet((Iterable)this.requiredGenes);
    }

    @NotNull
    public final String getTranslationKey() {
        return this.translationKey;
    }

    public static /* synthetic */ void getTranslationKey$annotations() {
    }

    @NotNull
    public final MutableComponent getNameComponent() {
        ChatFormatting color = this.isActive ? (this.isNegative ? ChatFormatting.RED : (this.isMutation() ? ChatFormatting.DARK_PURPLE : ChatFormatting.GRAY)) : ChatFormatting.DARK_RED;
        MutableComponent component = ModLanguageProvider.Companion.toComponent(this.translationKey, new Object[0]).withStyle(arg_0 -> Gene._get_nameComponent_$lambda$1(color, this, arg_0));
        if (!this.isActive) {
            component.append((Component)ModLanguageProvider.Companion.toComponent("gene.geneticsresequenced.gene_disabled", new Object[0]));
        }
        Intrinsics.checkNotNull((Object)component);
        return component;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final void deactivate() {
        this.isActive = false;
        GeneticsResequenced.Companion.getLOGGER().info("Deactivated gene " + this.id);
    }

    @Nullable
    public final MobEffectInstance getPotion() {
        GeneProperties.PotionDetails potionDetails = this.potionDetails;
        if (potionDetails == null) {
            return null;
        }
        GeneProperties.PotionDetails potionDetails2 = potionDetails;
        return new MobEffectInstance(potionDetails2.getEffect(), potionDetails2.getDuration(), potionDetails2.getLevel() - 1, true, false, potionDetails2.getShowIcon());
    }

    public final void setAttributeModifiers(@NotNull LivingEntity livingEntity, boolean isAdding) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        for (Map.Entry<Holder<Attribute>, Collection<AttributeModifier>> entry : this.attributeModifiers.entrySet()) {
            Holder<Attribute> attribute = entry.getKey();
            Collection<AttributeModifier> modifiers = entry.getValue();
            if (livingEntity.getAttribute(attribute) == null) {
                throw new IllegalArgumentException("Living Entity does not have attribute " + attribute);
            }
            for (AttributeModifier modifier : modifiers) {
                AttributeInstance attributeInstance;
                if (isAdding) {
                    if (attributeInstance.hasModifier(modifier.id())) continue;
                    attributeInstance.addPermanentModifier(modifier);
                    continue;
                }
                if (!attributeInstance.hasModifier(modifier.id())) continue;
                attributeInstance.removeModifier(modifier);
            }
        }
    }

    private static final Style _get_nameComponent_$lambda$1(ChatFormatting $color, Gene this$0, Style it) {
        Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{this$0.id.toString()};
        return it.withColor($color).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.copy_gene_id", objectArray))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this$0.id.toString()));
    }

    private static final Set requiredGenes_delegate$lambda$2() {
        return SetsKt.setOf((Object)ModGenes.INSTANCE.getBASIC().get());
    }

    static {
        Codec codec = GeneRegistry.INSTANCE.getGENE_REGISTRY().byNameCodec();
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"byNameCodec(...)");
        CODEC = codec;
        StreamCodec streamCodec = ByteBufCodecs.registry(GeneRegistry.INSTANCE.getGENE_REGISTRY_KEY());
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"registry(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R)\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\f0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene$Companion;", "", "<init>", "()V", "unknownGeneComponent", "Lnet/minecraft/network/chat/MutableComponent;", "getUnknownGeneComponent", "()Lnet/minecraft/network/chat/MutableComponent;", "checkDeactivationConfig", "", "requiredGenes", "", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "kotlin.jvm.PlatformType", "getRequiredGenes", "()Ljava/util/Set;", "requiredGenes$delegate", "Lkotlin/Lazy;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableComponent getUnknownGeneComponent() {
            return unknownGeneComponent;
        }

        public final void checkDeactivationConfig() {
            List disabledGenes = (List)ServerConfig.Companion.getDisabledGenes().get();
            for (String disabledGene : disabledGenes) {
                Gene gene = GeneRegistry.INSTANCE.fromId(disabledGene);
                if (gene == null) {
                    GeneticsResequenced.Companion.getLOGGER().warn("Tried to disable gene " + disabledGene + ", but it does not exist!");
                    continue;
                }
                if (this.getRequiredGenes().contains(gene)) {
                    GeneticsResequenced.Companion.getLOGGER().warn("Tried to disable gene " + disabledGene + ", but it is required for the mod to function!");
                    continue;
                }
                gene.deactivate();
            }
        }

        private final Set<Gene> getRequiredGenes() {
            Lazy lazy = requiredGenes$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Codec<Gene> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, Gene> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

