/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.advancement;

import dev.aaronhowser.mods.geneticsresequenced.api.genes.Gene;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers;", "", "<init>", "()V", "completeAdvancement", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "advancement", "Lnet/minecraft/advancements/AdvancementHolder;", "decryptDnaAdvancement", "stack", "Lnet/minecraft/world/item/ItemStack;", "geneAdvancements", "gene", "Ldev/aaronhowser/mods/geneticsresequenced/api/genes/Gene;", "wasAdded", "", "getAllScareGenes", "getFlightGeneAdvancement", "slimyDeathAdvancement", "getCringeGeneAdvancement", "getAnyGeneAdvancement", "getMilkedAdvancement", "blackDeath", "geneticsresequenced-1.21"})
@SourceDebugExtension(value={"SMAP\nAdvancementTriggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancementTriggers.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1755#2,3:114\n*S KotlinDebug\n*F\n+ 1 AdvancementTriggers.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/AdvancementTriggers\n*L\n61#1:114,3\n*E\n"})
public final class AdvancementTriggers {
    @NotNull
    public static final AdvancementTriggers INSTANCE = new AdvancementTriggers();

    private AdvancementTriggers() {
    }

    private final void completeAdvancement(ServerPlayer player, AdvancementHolder advancement) {
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
        if (progress.isDone()) {
            return;
        }
        for (String criterion : progress.getRemainingCriteria()) {
            player.getAdvancements().award(advancement, criterion);
        }
    }

    public final void decryptDnaAdvancement(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get())) {
            return;
        }
        if (!DnaHelixItem.Companion.hasGene(stack)) {
            return;
        }
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/decrypt_dna"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void geneAdvancements(@NotNull ServerPlayer player, @NotNull Gene gene, boolean wasAdded) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)gene, (String)"gene");
        if (wasAdded) {
            this.getAnyGeneAdvancement(player);
            Gene gene2 = gene;
            if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getCRINGE().get())) {
                this.getCringeGeneAdvancement(player);
            } else if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getFLIGHT().get())) {
                this.getFlightGeneAdvancement(player);
            } else if (Intrinsics.areEqual((Object)gene2, (Object)ModGenes.INSTANCE.getSCARE_SPIDERS().get())) {
                this.getAllScareGenes(player);
            }
        }
    }

    private final void getAllScareGenes(ServerPlayer player) {
        boolean bl;
        block5: {
            Object[] objectArray = new Gene[]{ModGenes.INSTANCE.getSCARE_SPIDERS().get(), ModGenes.INSTANCE.getSCARE_CREEPERS().get(), ModGenes.INSTANCE.getSCARE_SKELETONS().get(), ModGenes.INSTANCE.getSCARE_ZOMBIES().get()};
            List genes = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = genes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Gene it = (Gene)element$iv;
                    boolean bl2 = false;
                    LivingEntity livingEntity = (LivingEntity)player;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(!GenesData.Companion.hasGene(livingEntity, it))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/get_all_scare_genes"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getFlightGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/get_flight"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void slimyDeathAdvancement(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/trigger_slimy_death"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getCringeGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/get_cringe"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    private final void getAnyGeneAdvancement(ServerPlayer player) {
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/get_gene"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void getMilkedAdvancement(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/get_milked"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }

    public final void blackDeath(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get()) || Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getPLASMID().get())) {
            if (!Intrinsics.areEqual((Object)DnaHelixItem.Companion.getGene(stack), (Object)ModGenes.INSTANCE.getBLACK_DEATH().get())) {
                return;
            }
        } else if (SyringeItem.Companion.isSyringe(stack)) {
            if (!SyringeItem.Companion.getGenes(stack).contains(ModGenes.INSTANCE.getBLACK_DEATH().get())) {
                return;
            }
        } else {
            return;
        }
        AdvancementHolder advancementHolder = player.server.getAdvancements().get(OtherUtil.INSTANCE.modResource("guide/black_death"));
        if (advancementHolder == null) {
            return;
        }
        AdvancementHolder advancement = advancementHolder;
        this.completeAdvancement(player, advancement);
    }
}

