/*
 * Decompiled with CFR 0.152.
 */
package co.uk.mommyheather.advancedbackups.core.backups;

import co.uk.mommyheather.advancedbackups.core.ABCore;
import co.uk.mommyheather.advancedbackups.core.backups.BackupCheckEnum;
import co.uk.mommyheather.advancedbackups.core.backups.BackupStatusInstance;
import co.uk.mommyheather.advancedbackups.core.backups.BackupWrapper;
import co.uk.mommyheather.advancedbackups.core.backups.ThreadedBackup;
import co.uk.mommyheather.advancedbackups.core.config.ConfigManager;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;

public class BackupTimer {
    private static int loops = 0;
    private static int index = 0;
    private static long prev = 0L;
    private static long lastConsole = 0L;
    private static long lastClient = 0L;
    private static long nextBackup = System.currentTimeMillis() + BackupTimer.calculateNextBackupTime();

    public static void check() {
        BackupTimer.checkLogging();
        if (ThreadedBackup.running) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (ThreadedBackup.wasRunning) {
            ThreadedBackup.wasRunning = false;
            ABCore.enableSaving();
            nextBackup = BackupTimer.calculateNextBackupTime() + currentTime;
            return;
        }
        if (currentTime < nextBackup) {
            return;
        }
        if (BackupWrapper.checkBackups().equals((Object)BackupCheckEnum.SUCCESS)) {
            BackupWrapper.makeSingleBackup(0L, false);
        } else {
            nextBackup = BackupTimer.calculateNextBackupTime() + currentTime;
        }
    }

    private static long calculateNextBackupTime() {
        long forcedMillis = BackupWrapper.mostRecentBackupTime() + (long)(ConfigManager.maxFrequency.get().floatValue() * 3600000.0f);
        forcedMillis = forcedMillis <= System.currentTimeMillis() ? 300000L : (forcedMillis -= System.currentTimeMillis());
        long ret = Long.MAX_VALUE;
        if (ConfigManager.uptime.get().booleanValue() && !BackupWrapper.configuredPlaytime.isEmpty()) {
            ArrayList<Long> timings = new ArrayList<Long>(BackupWrapper.configuredPlaytime);
            if (index >= timings.size()) {
                index = 0;
                ++loops;
            }
            ret = timings.get(index) + timings.get(timings.size() - 1) * (long)loops;
            ret -= prev;
            prev += ret;
            ++index;
        } else if (!BackupWrapper.configuredPlaytime.isEmpty()) {
            long nextTime = 0L;
            long currentTime = System.currentTimeMillis();
            long startTime = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
            ArrayList<Long> timings = new ArrayList<Long>(BackupWrapper.configuredPlaytime);
            for (long time : timings) {
                if ((time += startTime) < currentTime) continue;
                nextTime = time;
                break;
            }
            ret = nextTime >= currentTime ? nextTime - currentTime : 86640000L - currentTime;
        }
        return Math.min(forcedMillis, ret);
    }

    private static void checkLogging() {
        if (BackupStatusInstance.getInstanceCopy() == null) {
            return;
        }
        BackupStatusInstance instance = BackupStatusInstance.getInstanceCopy();
        boolean console = false;
        boolean clients = false;
        long time = System.currentTimeMillis();
        if (time - ConfigManager.consoleFrequency.get() >= lastConsole) {
            console = true;
            if (instance.getAge() > lastConsole && ConfigManager.console.get().booleanValue()) {
                lastConsole = instance.getAge();
                if (instance.getState() == BackupStatusInstance.State.STARTED) {
                    int percent = (int)((float)instance.getProgress() / (float)instance.getMax() * 100.0f);
                    ABCore.infoLogger.accept("Backup in progress : " + percent + "%");
                }
            }
        }
        if (time - ConfigManager.clientFrequency.get() >= lastClient) {
            clients = true;
            if (instance.getAge() > lastClient && !ConfigManager.clients.get().equals("none")) {
                ABCore.clientContactor.handle(instance, ConfigManager.clients.get().equals("all"));
            }
        }
        if ((instance.getState() == BackupStatusInstance.State.COMPLETE || instance.getState() == BackupStatusInstance.State.CANCELLED || instance.getState() == BackupStatusInstance.State.FAILED) && console && clients) {
            BackupStatusInstance.setInstance(null);
        }
    }
}

