/*
 * Decompiled with CFR 0.152.
 */
package co.uk.mommyheather.advancedbackups;

import co.uk.mommyheather.advancedbackups.AdvancedBackupsCommand;
import co.uk.mommyheather.advancedbackups.client.ClientContactor;
import co.uk.mommyheather.advancedbackups.client.ClientWrapper;
import co.uk.mommyheather.advancedbackups.core.ABCore;
import co.uk.mommyheather.advancedbackups.core.backups.BackupTimer;
import co.uk.mommyheather.advancedbackups.core.backups.BackupWrapper;
import co.uk.mommyheather.advancedbackups.core.config.ConfigManager;
import co.uk.mommyheather.advancedbackups.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="advancedbackups")
public class AdvancedBackups {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Consumer<String> infoLogger = arg_0 -> ((Logger)LOGGER).info(arg_0);
    public static final Consumer<String> warningLogger = arg_0 -> ((Logger)LOGGER).warn(arg_0);
    public static final Consumer<String> errorLogger = arg_0 -> ((Logger)LOGGER).error(arg_0);
    public static final ArrayList<String> players = new ArrayList();
    public static final String savesDisabledMessage = "\n\n***************************************\nSAVING DISABLED - PREPARING FOR BACKUP!\n***************************************\n";
    public static final String savesEnabledMessage = "\n\n*********************************\nSAVING ENABLED - BACKUP COMPLETE!\n*********************************\n";
    public static final String saveCompleteMessage = "\n\n*************************************\nSAVE COMPLETE - PREPARING FOR BACKUP!\n*************************************\n";

    public AdvancedBackups(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(NetworkHandler::onRegisterPayloadHandler);
        modEventBus.addListener(this::clientSetup);
        ABCore.infoLogger = infoLogger;
        ABCore.warningLogger = warningLogger;
        ABCore.errorLogger = errorLogger;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        ABCore.worldName = event.getServer().getWorldData().getLevelName();
        ABCore.worldDir = event.getServer().getWorldPath(LevelResource.ROOT);
        ABCore.disableSaving = AdvancedBackups::disableSaving;
        ABCore.enableSaving = AdvancedBackups::enableSaving;
        ABCore.saveOnce = AdvancedBackups::saveOnce;
        ABCore.resetActivity = AdvancedBackups::resetActivity;
        ABCore.clientContactor = new ClientContactor();
        ABCore.modJar = ModList.get().getModFileById("advancedbackups").getFile().getFilePath().toFile();
        ConfigManager.loadOrCreateConfig();
        LOGGER.info("Config loaded!!");
    }

    public void clientSetup(FMLClientSetupEvent e) {
        ClientWrapper.init(e);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        BackupWrapper.checkStartupBackups();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        BackupWrapper.checkShutdownBackups();
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        ABCore.setActivity(true);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        AdvancedBackupsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPostTick(ServerTickEvent.Post event) {
        BackupTimer.check();
    }

    public static void disableSaving() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerLevel level : server.getAllLevels()) {
            if (level == null || level.noSave) continue;
            level.noSave = true;
        }
        warningLogger.accept(savesDisabledMessage);
    }

    public static void enableSaving() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerLevel level : server.getAllLevels()) {
            if (level == null || !level.noSave) continue;
            level.noSave = false;
        }
        warningLogger.accept(savesEnabledMessage);
    }

    public static void saveOnce(boolean flush) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        server.saveEverything(true, flush, true);
        warningLogger.accept(saveCompleteMessage);
    }

    public static void resetActivity() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        List players = server.getPlayerList().getPlayers();
        ABCore.setActivity(!players.isEmpty());
    }
}

