/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.CGDataComponents;
import com.direwolf20.charginggadgets.Config;
import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationTile;
import com.direwolf20.charginggadgets.utils.MagicHelpers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChargingStationItem
extends BlockItem {
    public ChargingStationItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        int power = (Integer)stack.getOrDefault(CGDataComponents.ENERGY, (Object)0);
        if (power == 0) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"screen.charginggadgets.energy", (Object[])new Object[]{MagicHelpers.withSuffix(power), MagicHelpers.withSuffix((Integer)Config.GENERAL.chargerMaxPower.get())}).withStyle(ChatFormatting.GREEN));
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof ChargingStationTile) {
            ChargingStationTile station = (ChargingStationTile)te;
            station.energyStorage.receiveEnergy((Integer)stack.getOrDefault(CGDataComponents.ENERGY, (Object)0), false);
        }
        return super.updateCustomBlockEntityTag(pos, worldIn, player, stack, state);
    }
}

