/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets;

import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="charginggadgets", bus=EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new GeneratorLanguage(packOutput));
        generator.addProvider(includeClient, (DataProvider)new GeneratorBlockStates(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(GeneratorLoots::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        generator.addProvider(includeServer, (DataProvider)new GeneratorRecipes(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new GeneratorBlockTags(packOutput, lookupProvider, event.getExistingFileHelper()));
        generator.addProvider(includeServer, (DataProvider)new GeneratorItemModels(packOutput, event.getExistingFileHelper()));
    }

    static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(PackOutput output) {
            super(output, "charginggadgets", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)BlockRegistry.CHARGING_STATION, "Charging Station");
            this.add("itemGroup.charginggadgets", "Charging Gadgets");
            this.add("screen.charginggadgets.energy", "Energy: %s/%s FE");
            this.add("screen.charginggadgets.no_fuel", "Fuel source empty");
            this.add("screen.charginggadgets.burn_time", "Burn time left: %ss");
        }
    }

    static class GeneratorBlockStates
    extends BlockStateProvider {
        public GeneratorBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "charginggadgets", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.horizontalBlock((Block)BlockRegistry.CHARGING_STATION.get(), (ModelFile)this.models().orientableWithBottom(BlockRegistry.CHARGING_STATION.getId().getPath(), this.modLoc("block/charging_station_side"), this.modLoc("block/charging_station_fronton"), this.modLoc("block/charging_station_bottom"), this.modLoc("block/charging_station_top")));
        }
    }

    static class GeneratorRecipes
    extends RecipeProvider {
        public GeneratorRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(output, completableFuture);
        }

        protected void buildRecipes(RecipeOutput consumer) {
            Block block = (Block)BlockRegistry.CHARGING_STATION.get();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)block).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('l'), Tags.Items.STORAGE_BLOCKS_COAL).define(Character.valueOf('d'), Tags.Items.GEMS_LAPIS).pattern("iri").pattern("drd").pattern("ili").unlockedBy("has_diamonds", GeneratorRecipes.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer);
        }
    }

    static class GeneratorBlockTags
    extends BlockTagsProvider {
        public GeneratorBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "charginggadgets", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)BlockRegistry.CHARGING_STATION.get()));
        }
    }

    static class GeneratorItemModels
    extends ItemModelProvider {
        public GeneratorItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "charginggadgets", existingFileHelper);
        }

        protected void registerModels() {
            String path = BlockRegistry.CHARGING_STATION.getId().getPath();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String getName() {
            return "Item Models";
        }
    }

    static class GeneratorLoots
    extends VanillaBlockLoot {
        public GeneratorLoots(HolderLookup.Provider p_344962_) {
            super(p_344962_);
        }

        protected void generate() {
            this.dropSelf((Block)BlockRegistry.CHARGING_STATION.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> knownBlocks = new ArrayList<Block>();
            knownBlocks.addAll(BlockRegistry.BLOCKS.getEntries().stream().map(DeferredHolder::get).toList());
            return knownBlocks;
        }
    }
}

