/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.upgrade;

import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.util.CodecHelpers;
import com.direwolf20.mininggadgets.setup.MGDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class UpgradeTools {
    private static final String KEY_UPGRADES = "upgrades";
    private static final String KEY_UPGRADE = "upgrade";
    private static final String KEY_ENABLED = "enabled";

    private static void setUpgradeNBT(ItemStack tool, UpgradeCard upgrade) {
        ArrayList<CodecHelpers.UpgradeData> upgradeData = new ArrayList<CodecHelpers.UpgradeData>((Collection)tool.getOrDefault(MGDataComponents.UPGRADE_DATA, new ArrayList()));
        CodecHelpers.UpgradeData newUpgrade = new CodecHelpers.UpgradeData(upgrade.getUpgrade().getName(), upgrade.getUpgrade().isEnabled());
        upgradeData.removeIf(k -> k.upgradeName().equals(upgrade.getUpgrade().getName()));
        upgradeData.add(newUpgrade);
        tool.set(MGDataComponents.UPGRADE_DATA, upgradeData);
    }

    public static void setUpgrade(ItemStack tool, UpgradeCard upgrade) {
        UpgradeTools.setUpgradeNBT(tool, upgrade);
    }

    public static void updateUpgrade(ItemStack tool, Upgrade upgrade) {
        List upgradeData = (List)tool.getOrDefault(MGDataComponents.UPGRADE_DATA, new ArrayList());
        ArrayList newUpgradeData = new ArrayList();
        upgradeData.forEach(e -> {
            String name = e.upgradeName();
            boolean enabled = e.isActive();
            if (name.contains(Upgrade.FORTUNE_1.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.SILK) || name.equals(Upgrade.SILK.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.FORTUNE_1)) {
                enabled = false;
            }
            if (name.equals(upgrade.getName())) {
                enabled = !enabled;
            }
            newUpgradeData.add(new CodecHelpers.UpgradeData(name, enabled));
        });
        tool.set(MGDataComponents.UPGRADE_DATA, newUpgradeData);
    }

    public static List<Upgrade> getUpgrades(ItemStack tool) {
        List upgradeData = (List)tool.getOrDefault(MGDataComponents.UPGRADE_DATA, new ArrayList());
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgradeData.isEmpty()) {
            return functionalUpgrades;
        }
        for (CodecHelpers.UpgradeData data : upgradeData) {
            Upgrade type = UpgradeTools.getUpgradeByName(data.upgradeName());
            if (type == null) continue;
            type.setEnabled(data.isActive());
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    public static CompoundTag setUpgradesNBT(List<Upgrade> laserUpgrades) {
        CompoundTag listCompound = new CompoundTag();
        ListTag list = new ListTag();
        laserUpgrades.forEach(upgrade -> {
            CompoundTag compound = new CompoundTag();
            compound.putString(KEY_UPGRADE, upgrade.getName());
            compound.putBoolean(KEY_ENABLED, upgrade.isEnabled());
            list.add((Object)compound);
        });
        listCompound.put(KEY_UPGRADES, (Tag)list);
        return listCompound;
    }

    public static List<Upgrade> getUpgradesFromTag(CompoundTag tagCompound) {
        ListTag upgrades = tagCompound.getList(KEY_UPGRADES, 10);
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgrades.isEmpty()) {
            return functionalUpgrades;
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            CompoundTag tag = upgrades.getCompound(i);
            Upgrade type = UpgradeTools.getUpgradeByName(tag.getString(KEY_UPGRADE));
            if (type == null) continue;
            type.setEnabled(!tag.contains(KEY_ENABLED) || tag.getBoolean(KEY_ENABLED));
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    public static List<Upgrade> getActiveUpgrades(ItemStack tool) {
        List upgradeData = (List)tool.getOrDefault(MGDataComponents.UPGRADE_DATA, new ArrayList());
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgradeData.isEmpty()) {
            return functionalUpgrades;
        }
        for (CodecHelpers.UpgradeData data : upgradeData) {
            Upgrade type = UpgradeTools.getUpgradeByName(data.upgradeName());
            if (type == null) continue;
            type.setEnabled(data.isActive());
            if (!type.isEnabled()) continue;
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    @Nullable
    public static Upgrade getUpgradeByName(String name) {
        try {
            Upgrade type = Upgrade.valueOf(name.toUpperCase());
            return type;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static boolean containsUpgrades(ItemStack tool) {
        return tool.has(MGDataComponents.UPGRADE_DATA);
    }

    public static Optional<Upgrade> getUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        if (upgrades == null || upgrades.isEmpty()) {
            return Optional.empty();
        }
        return upgrades.stream().filter(upgrade -> upgrade.getBaseName().equals(type.getBaseName())).findFirst();
    }

    public static Optional<Upgrade> getUpgradeFromGadget(ItemStack tool, Upgrade type) {
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(tool);
        return UpgradeTools.getUpgradeFromList(upgrades, type);
    }

    public static void removeUpgrade(ItemStack tool, Upgrade upgrade) {
        ArrayList<CodecHelpers.UpgradeData> upgradeData = new ArrayList<CodecHelpers.UpgradeData>((Collection)tool.getOrDefault(MGDataComponents.UPGRADE_DATA, new ArrayList()));
        upgradeData.removeIf(k -> k.upgradeName().equals(upgrade.getName()));
        tool.set(MGDataComponents.UPGRADE_DATA, upgradeData);
    }

    public static boolean containsUpgrade(ItemStack tool, Upgrade type) {
        return UpgradeTools.getUpgradeFromGadget(tool, type).isPresent();
    }

    public static boolean containsActiveUpgrade(ItemStack tool, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromGadget(tool, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsActiveUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromList(upgrades, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        return UpgradeTools.getUpgradeFromList(upgrades, type).isPresent();
    }

    public static int getMaxBeamRange(int tier) {
        return (tier + 1) * 5;
    }

    public static Component getName(Upgrade upgrade) {
        return Component.translatable((String)upgrade.getLocal());
    }

    public static int getMaxMiningRange(int tier) {
        return 1 + tier * 2;
    }
}

