/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.gadget;

import com.direwolf20.mininggadgets.common.blocks.MinersLight;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MiningCollect {
    public static List<BlockPos> collect(Player player, BlockHitResult startBlock, Level world, int range, MiningProperties.SizeMode sizeMode) {
        int midRange;
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        BlockPos startPos = startBlock.getBlockPos();
        if (range == 1) {
            if (!MiningCollect.isValid(player, startBlock.getBlockPos(), world)) {
                return coordinates;
            }
            coordinates.add(startBlock.getBlockPos());
            return coordinates;
        }
        Direction side = startBlock.getDirection();
        boolean vertical = side.getAxis().isVertical();
        Direction up = vertical ? player.getDirection() : Direction.UP;
        Direction down = up.getOpposite();
        Direction right = vertical ? up.getClockWise() : side.getCounterClockWise();
        Direction left = right.getOpposite();
        int upRange = midRange = (range - 1) / 2;
        int downRange = midRange;
        if (!vertical && range > 3) {
            if (sizeMode == MiningProperties.SizeMode.AUTO) {
                double hitBlockPos;
                double myYPos = player.position().get(Direction.UP.getAxis());
                if (Math.abs(myYPos - (hitBlockPos = (double)startBlock.getBlockPos().get(Direction.UP.getAxis()))) < 2.0) {
                    downRange = 1;
                    upRange = range - 2;
                }
            } else if (sizeMode == MiningProperties.SizeMode.PATHWAY) {
                downRange = 1;
                upRange = range - 2;
            }
        }
        BlockPos topLeft = startPos.relative(up, upRange).relative(left, midRange);
        BlockPos bottomRight = startPos.relative(down, downRange).relative(right, midRange);
        return BlockPos.betweenClosedStream((BlockPos)topLeft, (BlockPos)bottomRight).map(BlockPos::immutable).filter(e -> MiningCollect.isValid(player, e, world)).collect(Collectors.toList());
    }

    private static boolean isValid(Player player, BlockPos pos, Level world) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof RenderBlock) {
            return true;
        }
        if (!state.getFluidState().isEmpty() && !state.hasProperty((Property)BlockStateProperties.WATERLOGGED) || world.isEmptyBlock(pos)) {
            return false;
        }
        if (state.getDestroySpeed((BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null && !(te instanceof RenderBlockTileEntity)) {
            return false;
        }
        if (state.getBlock() instanceof DoorBlock) {
            return false;
        }
        return !(state.getBlock() instanceof MinersLight);
    }
}

