/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items;

import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.client.particles.playerparticle.PlayerParticleData;
import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.blocks.MinersLight;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.sounds.LaserLoopSound;
import com.direwolf20.mininggadgets.common.sounds.OurSounds;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.direwolf20.mininggadgets.common.util.CodecHelpers;
import com.direwolf20.mininggadgets.common.util.MagicHelpers;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.direwolf20.mininggadgets.setup.Config;
import com.direwolf20.mininggadgets.setup.Registration;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.level.BlockEvent;

public class MiningGadget
extends Item {
    private final Random rand = new Random();
    private LaserLoopSound laserLoopSound;

    public MiningGadget() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    public int getEnergyMax() {
        return (Integer)Config.MININGGADGET_MAXPOWER.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getEnergyMax();
    }

    public boolean isBarVisible(ItemStack stack) {
        if (MiningProperties.getBatteryTier(stack) == Upgrade.BATTERY_CREATIVE.getTier()) {
            return false;
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return false;
        }
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public int getBarWidth(ItemStack stack) {
        if (MiningProperties.getBatteryTier(stack) == Upgrade.BATTERY_CREATIVE.getTier()) {
            return 13;
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 13;
        }
        return Math.min(13 * energy.getEnergyStored() / energy.getMaxEnergyStored(), 13);
    }

    public int getBarColor(ItemStack stack) {
        if (MiningProperties.getBatteryTier(stack) == Upgrade.BATTERY_CREATIVE.getTier()) {
            return Mth.color((float)0.0f, (float)1.0f, (float)0.0f);
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            super.getBarColor(stack);
        }
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        boolean sneakPressed = Screen.hasShiftDown();
        if (!sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"mininggadgets.tooltip.item.show_upgrades", (Object[])new Object[]{"shift"}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"mininggadgets.tooltip.item.break_cost", (Object[])new Object[]{MiningGadget.getEnergyCost(stack)}).withStyle(ChatFormatting.RED));
            if (!upgrades.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"mininggadgets.tooltip.item.upgrades").withStyle(ChatFormatting.AQUA));
                for (Upgrade upgrade : upgrades) {
                    tooltip.add((Component)Component.literal((String)(" - " + I18n.get((String)upgrade.getLocal(), (Object[])new Object[0]))).withStyle(ChatFormatting.GRAY));
                }
            }
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return;
        }
        MutableComponent energyText = !sneakPressed ? Component.translatable((String)"mininggadgets.gadget.energy", (Object[])new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}) : Component.translatable((String)"mininggadgets.gadget.energy", (Object[])new Object[]{String.format("%,d", energy.getEnergyStored()), String.format("%,d", energy.getMaxEnergyStored())});
        tooltip.add((Component)energyText.withStyle(ChatFormatting.GREEN));
    }

    public static void changeRange(ItemStack tool) {
        int maxRange = MiningProperties.getMaxMiningRange(tool);
        if (maxRange == 1) {
            MiningProperties.setRange(tool, 1);
            return;
        }
        int range = MiningProperties.getRange(tool);
        if (range == maxRange) {
            MiningProperties.setRange(tool, 1);
        } else {
            MiningProperties.setRange(tool, range + 2);
        }
    }

    public static boolean canMine(ItemStack tool) {
        if (MiningProperties.getBatteryTier(tool) == Upgrade.BATTERY_CREATIVE.getTier()) {
            return true;
        }
        IEnergyStorage energy = (IEnergyStorage)tool.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return false;
        }
        int cost = MiningGadget.getEnergyCost(tool);
        int range = MiningProperties.getRange(tool);
        if (range > 1) {
            cost *= range * range;
        }
        return energy.getEnergyStored() >= cost;
    }

    public static boolean canMineBlock(ItemStack tool, Level world, Player player, BlockPos pos, BlockState state) {
        if (!player.mayBuild() || !world.mayInteract(player, pos)) {
            return false;
        }
        if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))).isCanceled()) {
            return false;
        }
        return MiningGadget.canMine(tool);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                MiningProperties.setCanMine(itemstack, true);
            }
            if (world.isClientSide && OurKeys.shiftClickGuiBinding.getKey() == InputConstants.UNKNOWN) {
                ModScreens.openGadgetSettingsScreen(itemstack);
                return InteractionResultHolder.pass((Object)itemstack);
            }
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (world.isClientSide) {
            float volume = MiningProperties.getVolume(itemstack);
            if (volume != 0.0f) {
                if (itemstack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                    player.playSound(SoundEvents.STONE_HIT, volume * 0.5f, 1.0f);
                } else {
                    player.playSound(OurSounds.LASER_START.get(), volume * 0.5f, 1.0f);
                }
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (!MiningGadget.canMine(itemstack)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public List<BlockPos> findSources(Level world, List<BlockPos> coords) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        for (BlockPos coord : coords) {
            for (Direction side : Direction.values()) {
                BlockPos sidePos = coord.relative(side);
                FluidState state = world.getFluidState(sidePos);
                if (!state.getType().isSame((Fluid)Fluids.LAVA) && !state.getType().isSame((Fluid)Fluids.WATER) || sources.contains(sidePos)) continue;
                sources.add(sidePos);
            }
        }
        return sources;
    }

    private void spawnFreezeParticle(Player player, BlockPos sourcePos, Level world, ItemStack stack) {
        float randomPartSize = 0.05f + 0.075f * this.rand.nextFloat();
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        double alpha = -0.5 + 0.5 * this.rand.nextDouble();
        Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 look = player.getLookAngle();
        int range = MiningProperties.getBeamRange(stack);
        BlockHitResult lookAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, range);
        Vec3 lookingAt = lookAt.getLocation();
        Vec3 right = new Vec3(-look.z, 0.0, look.x).normalize();
        Vec3 forward = look;
        Vec3 backward = look.multiply(-1.0, 1.0, -1.0);
        Vec3 down = right.cross(forward);
        right = right.scale((double)0.65f);
        forward = forward.scale((double)0.85f);
        down = down.scale(-0.35);
        backward = backward.scale(0.05);
        Vec3 laserPos = playerPos.add(right);
        laserPos = laserPos.add(forward);
        laserPos = laserPos.add(down);
        lookingAt = lookingAt.add(backward);
        PlayerParticleData data = PlayerParticleData.playerparticle("ice", (double)sourcePos.getX() + randomTX, (double)sourcePos.getY() + randomTY, (double)sourcePos.getZ() + randomTZ, randomPartSize, 1.0f, 1.0f, 1.0f, 120.0f, true);
        world.addParticle((ParticleOptions)data, laserPos.x, laserPos.y, laserPos.z, 0.025, (double)0.025f, 0.025);
    }

    private void spawnFireParticle(BlockPos sourcePos, ServerLevel world) {
        double partType = this.rand.nextDouble();
        if (partType < 0.75) {
            return;
        }
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        if (partType < 0.95) {
            world.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)sourcePos.getX() + randomTX, (double)sourcePos.getY() + randomTY, (double)sourcePos.getZ() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            world.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)sourcePos.getX() + randomTX, (double)sourcePos.getY() + randomTY, (double)sourcePos.getZ() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLoopSound(LivingEntity player, ItemStack stack) {
        float volume = MiningProperties.getVolume(stack);
        LocalPlayer myplayer = Minecraft.getInstance().player;
        if (myplayer.equals((Object)player) && volume != 0.0f) {
            if (stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                if (player.level().getGameTime() % 5L == 0L) {
                    if (this.rand.nextDouble() > 0.005) {
                        player.playSound(SoundEvents.STONE_HIT, volume * 0.5f, 1.0f);
                    } else {
                        player.playSound(SoundEvents.CREEPER_PRIMED, volume * 1.0f, 1.0f);
                    }
                }
            } else if (this.laserLoopSound == null) {
                this.laserLoopSound = new LaserLoopSound((Player)player, volume, player.level().random);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.laserLoopSound);
            }
        }
    }

    public void onUseTick(Level world, LivingEntity livingEntity, ItemStack stack, int count) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (world.isClientSide) {
            this.playLoopSound((LivingEntity)player, stack);
        }
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        if (!world.isClientSide && stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("rgb")) {
            CodecHelpers.LaserColor laserColor = MiningProperties.getColors(stack);
            float beam2r = (float)laserColor.innerRed() / 255.0f;
            float beam2g = (float)laserColor.innerGreen() / 255.0f;
            float beam2b = (float)laserColor.innerBlue() / 255.0f;
            float r = (float)laserColor.red() / 255.0f;
            float g = (float)laserColor.green() / 255.0f;
            float b = (float)laserColor.blue() / 255.0f;
            short newInnerRed = laserColor.innerRed();
            short newInnerGreen = laserColor.innerGreen();
            short newInnerBlue = laserColor.innerBlue();
            short newRed = laserColor.red();
            short newGreen = laserColor.green();
            short newBlue = laserColor.blue();
            if (beam2r < 1.0f && beam2g == 0.0f) {
                newInnerRed = (short)(beam2r * 255.0f + Math.min(255.0f - beam2r * 255.0f, 5.0f));
            } else if (beam2b > 0.0f && beam2r == 1.0f) {
                newInnerBlue = (short)(beam2b * 255.0f - Math.min(Math.abs(0.0f - beam2b * 255.0f), 5.0f));
            } else if (beam2g < 1.0f && beam2r == 1.0f) {
                newInnerGreen = (short)(beam2g * 255.0f + Math.min(255.0f - beam2g * 255.0f, 5.0f));
            } else if (beam2r > 0.0f && beam2g == 1.0f) {
                newInnerRed = (short)(beam2r * 255.0f - Math.min(Math.abs(0.0f - beam2r * 255.0f), 5.0f));
            } else if (beam2b < 1.0f && beam2g == 1.0f) {
                newInnerBlue = (short)(beam2b * 255.0f + Math.min(255.0f - beam2b * 255.0f, 5.0f));
            } else if (beam2g > 0.0f && beam2b == 1.0f) {
                newInnerGreen = (short)(beam2g * 255.0f - Math.min(Math.abs(0.0f - beam2g * 255.0f), 5.0f));
            }
            if (r < 1.0f && g == 0.0f) {
                newRed = (short)(r * 255.0f + Math.min(255.0f - r * 255.0f, 5.0f));
            } else if (b > 0.0f && r == 1.0f) {
                newBlue = (short)(b * 255.0f - Math.min(Math.abs(0.0f - b * 255.0f), 5.0f));
            } else if (g < 1.0f && r == 1.0f) {
                newGreen = (short)(g * 255.0f + Math.min(255.0f - g * 255.0f, 5.0f));
            } else if (r > 0.0f && g == 1.0f) {
                newRed = (short)(r * 255.0f - Math.min(Math.abs(0.0f - r * 255.0f), 5.0f));
            } else if (b < 1.0f && g == 1.0f) {
                newBlue = (short)(b * 255.0f + Math.min(255.0f - b * 255.0f, 5.0f));
            } else if (g > 0.0f && b == 1.0f) {
                newGreen = (short)(g * 255.0f - Math.min(Math.abs(0.0f - g * 255.0f), 5.0f));
            }
            CodecHelpers.LaserColor newLaserColor = new CodecHelpers.LaserColor(newRed, newGreen, newBlue, newInnerRed, newInnerGreen, newInnerBlue);
            MiningProperties.setColor(stack, newLaserColor);
        }
        int range = MiningProperties.getBeamRange(stack);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, range);
        if (world.getBlockState(VectorHelper.getLookingAt(player, stack, range).getBlockPos()) == Blocks.AIR.defaultBlockState()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect(player, lookingAt, world, MiningProperties.getRange(stack), MiningProperties.getSizeMode(stack));
        if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.FREEZING)) {
            for (BlockPos sourcePos : this.findSources(player.level(), coords)) {
                int delay = MiningProperties.getFreezeDelay(stack);
                if (delay != 0 && count % delay != 0) continue;
                this.spawnFreezeParticle(player, sourcePos, player.level(), stack);
            }
        }
        if (!world.isClientSide) {
            int energy;
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (cap == null) {
                return;
            }
            int efficiency = 0;
            if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.EFFICIENCY_1)) {
                efficiency = UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier();
            }
            float hardness = MiningGadget.getHardness(coords, player, efficiency);
            hardness = hardness * (float)MiningProperties.getRange(stack) * 1.0f;
            if ((hardness = (float)Math.floor(hardness)) == 0.0f) {
                hardness = 1.0f;
            }
            for (BlockPos coord : coords) {
                BlockState state = world.getBlockState(coord);
                if (!(state.getBlock() instanceof RenderBlock)) {
                    if (!MiningGadget.canMineBlock(stack, world, player, coord, state)) {
                        return;
                    }
                    List<Upgrade> gadgetUpgrades = UpgradeTools.getUpgrades(stack);
                    boolean placed = world.setBlockAndUpdate(coord, ((RenderBlock)((Object)Registration.RENDER_BLOCK.get())).defaultBlockState());
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.getBlockEntity(coord);
                    if (!placed || te == null) {
                        return;
                    }
                    te.setRenderBlock(state);
                    te.setBreakType(MiningProperties.getBreakType(stack));
                    te.setGadgetUpgrades(gadgetUpgrades);
                    te.setGadgetFilters(MiningProperties.getFiltersAsList(stack));
                    te.setGadgetIsWhitelist(MiningProperties.getWhiteList(stack));
                    te.setPriorDurability((int)hardness + 1);
                    te.setOriginalDurability((int)hardness + 1);
                    te.setDurability((int)hardness, stack);
                    te.setPlayer(player);
                    te.setBlockAllowed();
                } else {
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.getBlockEntity(coord);
                    if (te != null) {
                        int durability = te.getDurability();
                        if (--durability <= 0) {
                            cap.receiveEnergy(MiningGadget.getEnergyCost(stack) * -1, false);
                            if (MiningProperties.getPrecisionMode(stack)) {
                                MiningProperties.setCanMine(stack, false);
                                player.stopUsingItem();
                            }
                        }
                        te.setDurability(durability, stack);
                    }
                }
                if (!stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains("wildfirev")) continue;
                this.spawnFireParticle(coord, (ServerLevel)player.level());
            }
            if (!UpgradeTools.containsActiveUpgrade(stack, Upgrade.LIGHT_PLACER)) {
                return;
            }
            Direction side = lookingAt.getDirection();
            boolean vertical = side.getAxis().isVertical();
            Direction up = vertical ? player.getDirection() : Direction.UP;
            Direction right = vertical ? up.getClockWise() : side.getCounterClockWise();
            int rightAmt = MiningProperties.getRange(stack) / 2;
            BlockPos pos = lookingAt.getBlockPos().relative(side).relative(right, rightAmt);
            if (world.getMaxLocalRawBrightness(pos) <= 7 && world.getBlockState(pos).isAir() && (energy = cap.getEnergyStored()) > (Integer)Config.UPGRADECOST_LIGHT.get()) {
                world.setBlockAndUpdate(pos, ((MinersLight)((Object)Registration.MINERS_LIGHT.get())).defaultBlockState());
                cap.receiveEnergy((Integer)Config.UPGRADECOST_LIGHT.get() * -1, false);
            }
        }
    }

    public static int getEnergyCost(ItemStack stack) {
        if (MiningProperties.getBatteryTier(stack) == Upgrade.BATTERY_CREATIVE.getTier()) {
            return 0;
        }
        int cost = (Integer)Config.MININGGADGET_BASECOST.get();
        List<Upgrade> upgrades = UpgradeTools.getActiveUpgrades(stack);
        if (upgrades.isEmpty()) {
            return cost;
        }
        return cost + upgrades.stream().mapToInt(Upgrade::getCostPerBlock).sum();
    }

    private static float getHardness(List<BlockPos> coords, Player player, int efficiency) {
        MobEffectInstance miningFatigue;
        MobEffectInstance hasteEffect;
        float hardness = 0.0f;
        float toolSpeed = 8.0f;
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if ((hasteEffect = player.getEffect(MobEffects.DIG_SPEED)) != null) {
            int hasteLevel = hasteEffect.getAmplifier() + 1;
            toolSpeed += toolSpeed * ((float)hasteLevel * 20.0f / 100.0f);
        }
        if ((miningFatigue = player.getEffect(MobEffects.DIG_SLOWDOWN)) != null) {
            toolSpeed /= 3.0f;
        }
        Level world = player.level();
        for (BlockPos coord : coords) {
            RenderBlockTileEntity blockEntity;
            BlockState state = world.getBlockState(coord);
            float temphardness = state.getDestroySpeed((BlockGetter)world, coord);
            if (state.getBlock() instanceof RenderBlock && (blockEntity = (RenderBlockTileEntity)world.getBlockEntity(coord)) != null) {
                temphardness = blockEntity.getRenderBlock().getDestroySpeed((BlockGetter)world, coord);
            }
            hardness += temphardness * 30.0f / toolSpeed;
        }
        return hardness / (float)coords.size();
    }

    public static void applyUpgrade(ItemStack tool, UpgradeCard upgradeCard) {
        if (UpgradeTools.containsUpgrade(tool, upgradeCard.getUpgrade())) {
            return;
        }
        UpgradeTools.setUpgrade(tool, upgradeCard);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (worldIn.isClientSide && this.laserLoopSound != null) {
            float volume = MiningProperties.getVolume(stack);
            if (volume != 0.0f && !this.laserLoopSound.isStopped()) {
                entityLiving.playSound(OurSounds.LASER_END.get(), volume * 0.5f, 1.0f);
            }
            this.laserLoopSound = null;
        }
        if (entityLiving instanceof Player) {
            entityLiving.stopUsingItem();
        }
        if (!worldIn.isClientSide) {
            MiningProperties.setCanMine(stack, true);
        }
    }

    public static ItemStack getGadget(Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof MiningGadget) && !((heldItem = player.getOffhandItem()).getItem() instanceof MiningGadget)) {
            return ItemStack.EMPTY;
        }
        return heldItem;
    }

    public static boolean isHolding(Player entity) {
        return MiningGadget.getGadget(entity).getItem() instanceof MiningGadget;
    }
}

