/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.config.integrated;

import com.christofmeg.justenoughbreeding.jei.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MinecraftIntegration {
    static final String MOD = "minecraft";
    static final List<String> animalNames = new ArrayList<String>();
    static final List<String> tamableOnly = new ArrayList<String>();
    static final List<String> trustableOnly = new ArrayList<String>();
    static final Map<String, String> ingredients = new HashMap<String, String>();
    static final Map<String, Boolean> needsToBeTamed = new HashMap<String, Boolean>();
    static final Map<String, String> resultEggs = new HashMap<String, String>();
    static final Map<String, Integer> eggsAmountMin = new HashMap<String, Integer>();
    static final Map<String, Integer> eggsAmountMax = new HashMap<String, Integer>();
    static final Map<String, Integer> breedingCooldown = new HashMap<String, Integer>();
    static final Map<String, String> tamingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> tamingChance = new HashMap<String, Integer>();
    static final Map<String, List<TemperRecipe>> temperDataMap = new HashMap<String, List<TemperRecipe>>();
    static final Map<String, String> trustingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> trustingChance = new HashMap<String, Integer>();

    public static void init() {
        CommonUtils.addTrustingOnly("allay", "*", trustableOnly, trustingIngredients, trustingChance);
        CommonUtils.addAnimal("armadillo", "#armadillo_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("axolotl", "#axolotl_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("bee", "#bee_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("camel", "#camel_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("cat", "#cat_food", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableOnly("cat", "#cat_food", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimal("chicken", "#chicken_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("cow", "#cow_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("donkey", "minecraft:golden_apple, minecraft:enchanted_golden_apple, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("donkey", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimal("fox", "#fox_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalEggLaying("frog", "#frog_food", "minecraft:frogspawn", 1, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimal("goat", "#goat_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("hoglin", "#hoglin_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("horse", "minecraft:golden_apple, minecraft:enchanted_golden_apple, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("horse", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimalWithTamedTag("llama", "minecraft:hay_block", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("llama", new String[]{"minecraft:wheat", "minecraft:hay_block"}, new int[]{3, 6}, temperDataMap);
        CommonUtils.addAnimal("mooshroom", "#cow_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTemperAnimal("mule", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimal("ocelot", "#ocelot_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTrustingOnly("ocelot", "#ocelot_food", trustableOnly, trustingIngredients, trustingChance);
        CommonUtils.addAnimal("panda", "#panda_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTamableOnly("parrot", "#parrot_food", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimal("pig", "#pig_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("rabbit", "#rabbit_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("sheep", "#sheep_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalEggLaying("sniffer", "#sniffer_food", "minecraft:sniffer_egg", 1, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimal("strider", "#strider_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("trader_llama", "minecraft:hay_block", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("trader_llama", new String[]{"minecraft:wheat", "minecraft:hay_block"}, new int[]{3, 6}, temperDataMap);
        CommonUtils.addAnimalEggLaying("turtle", "#turtle_food", "minecraft:turtle_egg", 4, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimalWithTamedTag("wolf", "#wolf_food", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableOnly("wolf", "minecraft:bone", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimalNames(animalNames, ingredients, MOD, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableAnimalNames(tamableOnly, tamingIngredients, tamingChance, MOD);
        CommonUtils.addTrustingAnimalNames(trustableOnly, trustingIngredients, trustingChance, MOD);
        CommonUtils.addAnimalTempers(temperDataMap, MOD);
        CommonUtils.addAnimalNames(animalNames, ingredients, MOD, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
    }
}

