/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;
import owmii.powah.lib.logistics.energy.Energy;

public class Draw {
    public static void gaugeV(TextureAtlasSprite sprite, int x, int y, int w, int h, int cap, int cur) {
        if (cap > 0 && cur > 0) {
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            int i = (int)((float)cur / (float)cap * (float)h);
            int j = i / 16;
            int k = i - j * 16;
            for (int l = 0; l <= j; ++l) {
                int height = l == j ? k : 16;
                int yy = y - (l + 1) * 16 + h;
                if (height <= 0) continue;
                int m = 16 - height;
                int n = 16 - w;
                float uMin = sprite.getU0();
                float uMax = sprite.getU1();
                float vMin = sprite.getV0();
                float vMax = sprite.getV1();
                uMax -= (float)n / 16.0f * (uMax - uMin);
                vMin -= (float)m / 16.0f * (vMin - vMax);
                buffer.addVertex((float)x, (float)(yy + 16), 0.0f).setUv(uMin, vMax);
                buffer.addVertex((float)(x + w), (float)(yy + 16), 0.0f).setUv(uMax, vMax);
                buffer.addVertex((float)(x + w), (float)(yy + m), 0.0f).setUv(uMax, vMin);
                buffer.addVertex((float)x, (float)(yy + m), 0.0f).setUv(uMin, vMin);
            }
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
    }

    public static void gaugeH(int x, int y, int w, int h, int uvX, int uvY, Energy energy) {
        Draw.gaugeH(x, y, w, h, uvX, uvY, energy.getCapacity(), energy.getStored());
    }

    public static void gaugeH(int x, int y, int w, int h, int uvX, int uvY, long cap, long cur) {
        if (cap > 0L && cur > 0L) {
            w = (int)((float)cur / (float)cap * (float)w);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            buffer.addVertex((float)x, (float)(y + h), 0.0f).setUv((float)uvX, (float)(uvY + h));
            buffer.addVertex((float)(x + w), (float)(y + h), 0.0f).setUv((float)(uvX + w), (float)(uvY + h));
            buffer.addVertex((float)(x + w), (float)y, 0.0f).setUv((float)(uvX + w), (float)uvY);
            buffer.addVertex((float)x, (float)y, 0.0f).setUv((float)uvX, (float)uvY);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
    }

    public static void drawTexturedModalRect(GuiGraphics gui, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        BufferBuilder wr = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = gui.pose().last().pose();
        wr.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)u * 0.00390625f, (float)(v + height) * 0.00390625f);
        wr.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f);
        wr.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * 0.00390625f, (float)v * 0.00390625f);
        wr.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)u * 0.00390625f, (float)v * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)wr.buildOrThrow());
    }
}

