/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.container;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.container.AbstractContainerScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.logistics.inventory.AbstractTileContainer;
import owmii.powah.network.Network;
import owmii.powah.network.packet.NextRedstoneModePacket;

public class AbstractTileScreen<T extends AbstractTileEntity<?, ?>, C extends AbstractTileContainer<T>>
extends AbstractContainerScreen<C> {
    protected final T te;
    protected IconButton redStoneButton = IconButton.EMPTY;

    public AbstractTileScreen(C container, Inventory inv, Component title, Texture backGround) {
        super(container, inv, title, backGround);
        this.te = ((AbstractTileContainer)((Object)container)).te;
    }

    protected void addRedstoneButton(int x, int y) {
        if (this.hasRedstone()) {
            this.redStoneButton = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + this.imageWidth + x + 2, this.topPos + y + 3, Texture.REDSTONE.get((Object)((AbstractTileEntity)this.te).getRedstoneMode()), b -> {
                Network.toServer(new NextRedstoneModePacket(this.te.getBlockPos()));
                ((AbstractTileEntity)this.te).setRedstoneMode(((AbstractTileEntity)this.te).getRedstoneMode().next());
            }, (Screen)this).setTooltipSupplier(() -> List.of(((AbstractTileEntity)this.te).getRedstoneMode().getDisplayName())));
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.hasRedstone()) {
            this.redStoneButton.setTexture(Texture.REDSTONE.get((Object)((AbstractTileEntity)this.te).getRedstoneMode()));
        }
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.hasRedstone()) {
            Texture.REDSTONE_BTN_BG.draw(guiGraphics, this.redStoneButton.getX() - 2, this.redStoneButton.getY() - 4);
        }
    }

    protected boolean hasRedstone() {
        return true;
    }
}

