/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import owmii.powah.api.energy.IEnergyConnector;
import owmii.powah.block.Tier;
import owmii.powah.config.IConfigHolder;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.item.IEnergyItemProvider;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.util.EnergyUtil;
import owmii.powah.util.Util;

public abstract class AbstractEnergyBlock<C extends IEnergyConfig<Tier>, B extends AbstractEnergyBlock<C, B>>
extends AbstractBlock<Tier, B>
implements IConfigHolder<Tier, C>,
InfoBox.IInfoBoxHolder,
IEnergyItemProvider {
    public AbstractEnergyBlock(BlockBehaviour.Properties properties) {
        this(properties, (Tier)IVariant.getEmpty());
    }

    public AbstractEnergyBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return new EnergyBlockItem(this, properties, group);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof AbstractEnergyStorage) {
            return ((AbstractEnergyStorage)tile).getEnergy().toComparatorPower();
        }
        return super.getAnalogOutputSignal(state, world, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (this.checkValidEnergySide()) {
            Level level;
            Direction side = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockPos pos1 = pos.relative(side);
            return world.getBlockState(pos1).getBlock() instanceof IEnergyConnector || world instanceof Level && EnergyUtil.hasEnergy(level = (Level)world, pos1, side.getOpposite());
        }
        return super.canSurvive(state, world, pos);
    }

    protected boolean checkValidEnergySide() {
        return false;
    }

    @Override
    public boolean isChargeable(ItemStack stack) {
        return this.getTransferType().canReceive;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Energy.ifPresent(stack, energy -> {
            this.addEnergyInfo(stack, (Energy.Item)energy, tooltip);
            this.addEnergyTransferInfo(stack, (Energy.Item)energy, tooltip);
            this.additionalEnergyInfo(stack, (Energy.Item)energy, tooltip);
        });
    }

    public void addEnergyInfo(ItemStack stack, Energy.Item storage, List<Component> tooltip) {
        if (storage.getCapacity() > 0L) {
            tooltip.add((Component)Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(storage.getStored()), Util.numFormat(storage.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
        }
    }

    public void addEnergyTransferInfo(ItemStack stack, Energy.Item storage, List<Component> tooltip) {
        long re;
        long ext = storage.getMaxExtract();
        if (ext + (re = storage.getMaxReceive()) > 0L) {
            if (ext == re) {
                tooltip.add((Component)Component.translatable((String)"info.lollipop.max.io").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(ext)}).withStyle(ChatFormatting.DARK_GRAY)));
            } else {
                if (ext > 0L) {
                    tooltip.add((Component)Component.translatable((String)"info.lollipop.max.extract").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(ext)}).withStyle(ChatFormatting.DARK_GRAY)));
                }
                if (re > 0L) {
                    tooltip.add((Component)Component.translatable((String)"info.lollipop.max.receive").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(re)}).withStyle(ChatFormatting.DARK_GRAY)));
                }
            }
        }
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<Component> tooltip) {
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, storage -> {
            if (storage.getMaxEnergyStored() > 0L) {
                box.set(Component.translatable((String)"info.lollipop.capacity"), Component.translatable((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(storage.getCapacity())}));
            }
            box.set(Component.translatable((String)"info.lollipop.max.io"), Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(storage.getMaxExtract())}));
        });
        return box;
    }
}

